/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.publisher.rootfiles;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.tycho.core.shared.BuildProperties;
import org.eclipse.tycho.p2.impl.publisher.rootfiles.ConfigSpec;
import org.eclipse.tycho.p2.impl.publisher.rootfiles.RootFilePatternParser;
import org.eclipse.tycho.p2.impl.publisher.rootfiles.RootFilesProperties;
import org.eclipse.tycho.p2.impl.publisher.rootfiles.SegmentHelper;

public class RootPropertiesParser {
    static final String ROOT_KEY_SEGMENT = "root";
    private static final String LITERAL_DOT_EXPRESSION = "\\.";
    File baseDir;
    Map<String, String> rootEntries;
    ParsingResult parsingResult = new ParsingResult();
    String[] keySegments;
    String[] valueSegments;
    private boolean useDefaultExcludes;

    public RootPropertiesParser(File baseDir, BuildProperties buildProperties) {
        this.baseDir = baseDir;
        this.rootEntries = buildProperties.getRootEntries();
        this.useDefaultExcludes = buildProperties.isRootFilesUseDefaultExcludes();
    }

    public HashMap<ConfigSpec, RootFilesProperties> getPermissionsAndLinksResult() {
        return this.parsingResult.getPropertiesPerConfigMap();
    }

    public void parse() {
        for (Map.Entry<String, String> entry : this.rootEntries.entrySet()) {
            this.keySegments = RootPropertiesParser.splitKey(entry.getKey());
            this.valueSegments = RootPropertiesParser.splitAndTrimValue(entry.getValue());
            this.parseBuildPropertiesLine();
        }
        this.resolvePermissionWildcards();
    }

    private void resolvePermissionWildcards() {
        for (RootFilesProperties rootProperty : this.parsingResult.getPropertiesPerConfigMap().values()) {
            rootProperty.resolvePermissionWildcards(this.useDefaultExcludes);
        }
    }

    private static String[] splitKey(String string) {
        return string.split(LITERAL_DOT_EXPRESSION, -1);
    }

    private static String[] splitAndTrimValue(String value) {
        String[] segments = value.split(",");
        int ix = 0;
        while (ix < segments.length) {
            segments[ix] = segments[ix].trim();
            ++ix;
        }
        return segments;
    }

    private void parseBuildPropertiesLine() {
        if (SegmentHelper.segmentEquals(this.keySegments, 0, ROOT_KEY_SEGMENT)) {
            this.parseRootPropertiesLine();
        }
    }

    void parseRootPropertiesLine() {
        RootKeyType[] rootKeyTypeArray = RootKeyType.values();
        int n = rootKeyTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RootKeyType keyType = rootKeyTypeArray[n2];
            int indexOfTypeSegment = RootPropertiesParser.findTypeInKey(this.keySegments, keyType);
            if (indexOfTypeSegment >= 0) {
                String parameter = RootPropertiesParser.getParameterFromKey(this.keySegments, indexOfTypeSegment);
                ConfigSpec config = RootPropertiesParser.getConfigFromKey(this.keySegments, indexOfTypeSegment);
                RootPropertiesParser.verifyNumberOfParameters(this.keySegments, keyType, parameter);
                this.storeRootPropertyValue(keyType, parameter, this.parsingResult.getPropertiesForWriting(config));
                return;
            }
            ++n2;
        }
        throw new IllegalArgumentException(String.valueOf(SegmentHelper.segmentsToString(this.keySegments, '.')) + " is an invalid root key");
    }

    void storeRootPropertyValue(RootKeyType keyType, String parameterInKey, RootFilesProperties target) {
        switch (keyType) {
            case FILE: {
                RootFilePatternParser filePatternParser = new RootFilePatternParser(this.baseDir, target, this.useDefaultExcludes);
                filePatternParser.addFilesFromPatterns(this.valueSegments);
                break;
            }
            case FOLDER: {
                throw new UnsupportedOperationException("root.folder.<subfolder> and root.<config>.folder.<subfolder> are not yet supported in build.properties");
            }
            case PERMISSION: {
                target.addPermission(parameterInKey, this.valueSegments);
                break;
            }
            case LINKS: {
                target.addLinks(this.valueSegments);
            }
        }
    }

    static int findTypeInKey(String[] keySegments, RootKeyType keyType) {
        int[] nArray = new int[]{1, 4};
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int candidateIndex = nArray[n2];
            if (SegmentHelper.segmentEqualsOrIsEndSegment(keySegments, candidateIndex, keyType.keySegment)) {
                return candidateIndex;
            }
            ++n2;
        }
        return -1;
    }

    static ConfigSpec getConfigFromKey(String[] keySegments, int indexOfKeyType) {
        if (indexOfKeyType == 4) {
            return ConfigSpec.createFromOsWsArchArray(keySegments, 1);
        }
        return ConfigSpec.GLOBAL;
    }

    static String getParameterFromKey(String[] keySegments, int indexOfKeyType) {
        int indexOfLastSegment = keySegments.length - 1;
        int parameters = indexOfLastSegment - indexOfKeyType;
        if (parameters > 1) {
            throw new IllegalArgumentException(String.valueOf(SegmentHelper.segmentsToString(keySegments, '.')) + " has too many segments");
        }
        if (parameters == 1) {
            return keySegments[indexOfKeyType + 1];
        }
        return null;
    }

    static void verifyNumberOfParameters(String[] keySegments, RootKeyType keyType, String parameter) {
        boolean keyHasArgument = parameter != null;
        boolean typeExpectsParameter = keyType.hasParameter;
        if (typeExpectsParameter != keyHasArgument) {
            throw new IllegalArgumentException(keyType.getSyntaxErrorMessage(keySegments));
        }
    }

    static class ParsingResult {
        private HashMap<ConfigSpec, RootFilesProperties> propertiesPerConfig = new HashMap();

        ParsingResult() {
        }

        RootFilesProperties getPropertiesForWriting(ConfigSpec config) {
            RootFilesProperties properties = this.propertiesPerConfig.get(config);
            if (properties == null) {
                properties = new RootFilesProperties();
                this.propertiesPerConfig.put(config, properties);
            }
            return properties;
        }

        HashMap<ConfigSpec, RootFilesProperties> getPropertiesPerConfigMap() {
            return this.propertiesPerConfig;
        }
    }

    static enum RootKeyType {
        FILE(null, false, "root files"),
        FOLDER("folder", true, "root files with folder specification"),
        PERMISSION("permissions", true, "root file permissions"),
        LINKS("link", false, "root file links");

        final String keySegment;
        private boolean hasParameter;
        private final String message;

        private RootKeyType(String keySegment, boolean hasParameter, String message) {
            this.keySegment = keySegment;
            this.hasParameter = hasParameter;
            this.message = message;
        }

        String getSyntaxErrorMessage(String[] keySegments) {
            return String.valueOf(SegmentHelper.segmentsToString(keySegments, '.')) + " is an invalid key for " + this.message;
        }
    }
}

