/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.target;

import java.io.File;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.Publisher;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherResult;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.p2.impl.publisher.MavenPropertiesAdvice;
import org.eclipse.tycho.p2.impl.publisher.repo.TransientArtifactRepository;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;
import org.eclipse.tycho.p2.repository.MavenRepositoryCoordinates;
import org.eclipse.tycho.repository.local.GAVArtifactDescriptor;
import org.eclipse.tycho.repository.p2base.artifact.provider.IRawArtifactFileProvider;
import org.eclipse.tycho.repository.p2base.artifact.provider.formats.ArtifactTransferPolicies;
import org.eclipse.tycho.repository.p2base.artifact.repository.ArtifactRepositoryBaseImpl;
import org.eclipse.tycho.repository.util.StatusTool;

public class TargetPlatformBundlePublisher {
    private final MavenLogger logger;
    private final PublishedBundlesArtifactRepository publishedArtifacts;

    public TargetPlatformBundlePublisher(File localMavenRepositoryRoot, MavenLogger logger) {
        this.publishedArtifacts = new PublishedBundlesArtifactRepository(localMavenRepositoryRoot);
        this.logger = logger;
    }

    IInstallableUnit attemptToPublishBundle(IArtifactFacade mavenArtifact) {
        IInstallableUnit publishedIU;
        if (!this.isAvailableAsLocalFile(mavenArtifact)) {
            throw new IllegalArgumentException("Not an artifact file: " + mavenArtifact.getLocation());
        }
        if (this.isCertainlyNoBundle(mavenArtifact)) {
            return null;
        }
        PublisherRun publisherRun = new PublisherRun(mavenArtifact);
        IStatus status = publisherRun.execute();
        if (!status.isOK()) {
            this.logger.warn(StatusTool.collectProblems((IStatus)status), status.getException());
        }
        if ((publishedIU = publisherRun.getPublishedUnitIfExists()) != null) {
            IArtifactDescriptor publishedDescriptor = publisherRun.getPublishedArtifactDescriptor();
            this.publishedArtifacts.addPublishedArtifact(publishedDescriptor, mavenArtifact);
        }
        return publishedIU;
    }

    private boolean isAvailableAsLocalFile(IArtifactFacade artifact) {
        File localLocation = artifact.getLocation();
        return localLocation != null && localLocation.isFile();
    }

    private boolean isCertainlyNoBundle(IArtifactFacade artifact) {
        return !artifact.getLocation().getName().endsWith(".jar");
    }

    IRawArtifactFileProvider getArtifactRepoOfPublishedBundles() {
        return this.publishedArtifacts;
    }

    private static class PublishedBundlesArtifactRepository
    extends ArtifactRepositoryBaseImpl<GAVArtifactDescriptor> {
        PublishedBundlesArtifactRepository(File localMavenRepositoryRoot) {
            super(null, localMavenRepositoryRoot.toURI(), ArtifactTransferPolicies.forLocalArtifacts());
        }

        void addPublishedArtifact(IArtifactDescriptor baseDescriptor, IArtifactFacade mavenArtifact) {
            File actualArtifactLocation;
            MavenRepositoryCoordinates repositoryCoordinates = new MavenRepositoryCoordinates(mavenArtifact.getGroupId(), mavenArtifact.getArtifactId(), mavenArtifact.getVersion(), mavenArtifact.getClassifier(), null);
            GAVArtifactDescriptor descriptorForRepository = new GAVArtifactDescriptor(baseDescriptor, repositoryCoordinates);
            File requiredArtifactLocation = new File(this.getBaseDir(), descriptorForRepository.getMavenCoordinates().getLocalRepositoryPath());
            if (!this.equivalentPaths(requiredArtifactLocation, actualArtifactLocation = mavenArtifact.getLocation())) {
                throw new AssertionFailedException("The Maven artifact to be added to the target platform is not stored at the required location on disk: required \"" + requiredArtifactLocation + "\" but was \"" + actualArtifactLocation + "\"");
            }
            this.internalAddInternalDescriptor((IArtifactDescriptor)descriptorForRepository);
        }

        private boolean equivalentPaths(File path, File otherPath) {
            return path.equals(otherPath);
        }

        protected GAVArtifactDescriptor getInternalDescriptorForAdding(IArtifactDescriptor descriptor) {
            throw new UnsupportedOperationException();
        }

        protected IArtifactDescriptor getComparableDescriptor(IArtifactDescriptor descriptor) {
            return this.toInternalDescriptor(descriptor);
        }

        private GAVArtifactDescriptor toInternalDescriptor(IArtifactDescriptor descriptor) {
            if (descriptor instanceof GAVArtifactDescriptor && descriptor.getRepository() == this) {
                return (GAVArtifactDescriptor)descriptor;
            }
            GAVArtifactDescriptor internalDescriptor = new GAVArtifactDescriptor(descriptor);
            internalDescriptor.setRepository((IArtifactRepository)this);
            return internalDescriptor;
        }

        protected File internalGetArtifactStorageLocation(IArtifactDescriptor descriptor) {
            String relativePath = this.toInternalDescriptor(descriptor).getMavenCoordinates().getLocalRepositoryPath();
            return new File(this.getBaseDir(), relativePath);
        }

        private File getBaseDir() {
            return new File(this.getLocation());
        }
    }

    private static class PublisherRun {
        private static final String EXCEPTION_CONTEXT = "Error while adding Maven artifact to the target platform: ";
        private final IArtifactFacade mavenArtifact;
        private PublisherInfo publisherInfo;
        private TransientArtifactRepository collectedDescriptors;
        private PublisherResult publisherResult;

        PublisherRun(IArtifactFacade artifact) {
            this.mavenArtifact = artifact;
        }

        IStatus execute() {
            this.publisherInfo = new PublisherInfo();
            this.enableArtifactDescriptorCollection();
            this.enableUnitAnnotationWithGAV();
            BundlesAction bundlesAction = new BundlesAction(new File[]{this.mavenArtifact.getLocation()});
            IStatus status = this.executePublisherAction(bundlesAction);
            return status;
        }

        private void enableArtifactDescriptorCollection() {
            this.publisherInfo.setArtifactOptions(1);
            this.collectedDescriptors = new TransientArtifactRepository();
            this.publisherInfo.setArtifactRepository((IArtifactRepository)this.collectedDescriptors);
        }

        private void enableUnitAnnotationWithGAV() {
            MavenPropertiesAdvice advice = new MavenPropertiesAdvice(this.mavenArtifact.getGroupId(), this.mavenArtifact.getArtifactId(), this.mavenArtifact.getVersion(), this.mavenArtifact.getClassifier());
            this.publisherInfo.addAdvice((IPublisherAdvice)advice);
        }

        private IStatus executePublisherAction(BundlesAction action) {
            IPublisherAction[] actions = new IPublisherAction[]{action};
            this.publisherResult = new PublisherResult();
            return new Publisher((IPublisherInfo)this.publisherInfo, (IPublisherResult)this.publisherResult).publish(actions, null);
        }

        IInstallableUnit getPublishedUnitIfExists() {
            Collection units = this.publisherResult.getIUs(null, null);
            if (units.isEmpty()) {
                return null;
            }
            if (units.size() == 1) {
                return (IInstallableUnit)units.iterator().next();
            }
            throw new AssertionFailedException("Error while adding Maven artifact to the target platform: BundlesAction produced more than one IU for " + this.mavenArtifact.getLocation());
        }

        IArtifactDescriptor getPublishedArtifactDescriptor() {
            Set<IArtifactDescriptor> descriptors = this.collectedDescriptors.getArtifactDescriptors();
            if (descriptors.isEmpty()) {
                throw new AssertionFailedException("Error while adding Maven artifact to the target platform: BundlesAction did not create an artifact entry for " + this.mavenArtifact.getLocation());
            }
            if (descriptors.size() == 1) {
                return descriptors.iterator().next();
            }
            throw new AssertionFailedException("Error while adding Maven artifact to the target platform: BundlesAction created more than one artifact entry for " + this.mavenArtifact.getLocation());
        }
    }
}

