/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.tools.mirroring;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.internal.repository.mirroring.IArtifactMirrorLog;
import org.eclipse.equinox.p2.internal.repository.tools.RepositoryDescriptor;
import org.eclipse.equinox.p2.internal.repository.tools.SlicingOptions;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.tycho.BuildOutputDirectory;
import org.eclipse.tycho.core.facade.MavenContext;
import org.eclipse.tycho.core.facade.MavenLogger;
import org.eclipse.tycho.core.facade.TargetEnvironment;
import org.eclipse.tycho.p2.tools.BuildContext;
import org.eclipse.tycho.p2.tools.DestinationRepositoryDescriptor;
import org.eclipse.tycho.p2.tools.FacadeException;
import org.eclipse.tycho.p2.tools.RepositoryReferences;
import org.eclipse.tycho.p2.tools.impl.Activator;
import org.eclipse.tycho.p2.tools.mirroring.MirrorApplication;
import org.eclipse.tycho.p2.tools.mirroring.facade.IUDescription;
import org.eclipse.tycho.p2.tools.mirroring.facade.MirrorApplicationService;
import org.eclipse.tycho.p2.tools.mirroring.facade.MirrorOptions;
import org.eclipse.tycho.repository.util.StatusTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MirrorApplicationServiceImpl
implements MirrorApplicationService {
    private static final String MIRROR_FAILURE_MESSAGE = "Mirroring failed";
    private MavenContext mavenContext;

    public void mirrorStandalone(RepositoryReferences sources, DestinationRepositoryDescriptor destination, Collection<IUDescription> seedIUs, MirrorOptions mirrorOptions, BuildOutputDirectory tempDirectory) throws FacadeException {
        IProvisioningAgent agent = Activator.createProvisioningAgent(tempDirectory);
        try {
            MirrorApplication mirrorApp = MirrorApplicationServiceImpl.createMirrorApplication(sources, destination, agent, mirrorOptions.isIncludePacked());
            mirrorApp.setSlicingOptions(MirrorApplicationServiceImpl.createSlicingOptions(mirrorOptions));
            try {
                mirrorApp.setVerbose(true);
                mirrorApp.setLog(new LogListener(this.mavenContext.getLogger()));
                mirrorApp.setSourceIUs(this.querySourceIus(seedIUs, mirrorApp.getCompositeMetadataRepository(), sources));
                IStatus returnStatus = mirrorApp.run(null);
                MirrorApplicationServiceImpl.checkStatus(returnStatus);
            }
            catch (ProvisionException e) {
                throw new FacadeException("Mirroring failed: " + StatusTool.collectProblems((IStatus)e.getStatus()), (Throwable)e);
            }
        }
        finally {
            agent.stop();
        }
    }

    private static SlicingOptions createSlicingOptions(MirrorOptions mirrorOptions) {
        SlicingOptions slicingOptions = new SlicingOptions();
        slicingOptions.considerStrictDependencyOnly(mirrorOptions.isFollowStrictOnly());
        slicingOptions.everythingGreedy(mirrorOptions.isIncludeNonGreedy());
        slicingOptions.followOnlyFilteredRequirements(mirrorOptions.isFollowOnlyFilteredRequirements());
        slicingOptions.includeOptionalDependencies(mirrorOptions.isIncludeOptional());
        slicingOptions.latestVersionOnly(mirrorOptions.isLatestVersionOnly());
        slicingOptions.setFilter(mirrorOptions.getFilter());
        return slicingOptions;
    }

    /*
     * Unable to fully structure code
     */
    private List<IInstallableUnit> querySourceIus(Collection<IUDescription> sourceIUs, IMetadataRepository repository, RepositoryReferences sources) throws FacadeException {
        if (sourceIUs == null || sourceIUs.isEmpty()) {
            return null;
        }
        result = new ArrayList<IInstallableUnit>();
        for (IUDescription iu : sourceIUs) {
            iuQuery = this.createQuery(iu);
            queryResult = repository.query(iuQuery, null).iterator();
            if (queryResult.hasNext()) ** GOTO lbl11
            throw new FacadeException("Could not find IU " + iu.toString() + " in any of the source repositories " + sources.getMetadataRepositories(), null);
lbl-1000:
            // 1 sources

            {
                result.add((IInstallableUnit)queryResult.next());
lbl11:
                // 2 sources

                ** while (queryResult.hasNext())
            }
lbl12:
            // 1 sources

        }
        return result;
    }

    private IQuery<IInstallableUnit> createQuery(IUDescription iu) {
        String id = iu.getId();
        String version = iu.getVersion();
        if (iu.getQueryMatchExpression() != null) {
            return QueryUtil.createMatchQuery((String)iu.getQueryMatchExpression(), (Object[])iu.getQueryParameters());
        }
        if (version == null || version.length() == 0) {
            return QueryUtil.createLatestQuery((IQuery)QueryUtil.createIUQuery((String)id));
        }
        return QueryUtil.createIUQuery((String)id, (Version)Version.parseVersion((String)version));
    }

    public void mirrorReactor(RepositoryReferences sources, DestinationRepositoryDescriptor destination, Collection<?> seedUnits, BuildContext context, boolean includeAllDependencies, boolean includePacked, Map<String, String> filterProperties) throws FacadeException {
        IProvisioningAgent agent = Activator.createProvisioningAgent(context.getTargetDirectory());
        try {
            MirrorApplication mirrorApp = MirrorApplicationServiceImpl.createMirrorApplication(sources, destination, agent, includePacked);
            mirrorApp.setSourceIUs(MirrorApplicationServiceImpl.toInstallableUnitList(seedUnits));
            for (TargetEnvironment environment : context.getEnvironments()) {
                SlicingOptions options = new SlicingOptions();
                options.considerStrictDependencyOnly(!includeAllDependencies);
                Map filter = options.getFilter();
                MirrorApplicationServiceImpl.addFilterForFeatureJARs(filter);
                if (filterProperties != null) {
                    filter.putAll(filterProperties);
                }
                filter.putAll(environment.toFilterProperties());
                mirrorApp.setSlicingOptions(options);
                try {
                    LogListener logListener = new LogListener(this.mavenContext.getLogger());
                    mirrorApp.setLog(logListener);
                    IStatus returnStatus = mirrorApp.run(null);
                    MirrorApplicationServiceImpl.checkStatus(returnStatus);
                    logListener.showHelpForLoggedMessages();
                }
                catch (ProvisionException e) {
                    throw new FacadeException("Mirroring failed: " + StatusTool.collectProblems((IStatus)e.getStatus()), (Throwable)e);
                }
            }
        }
        finally {
            agent.stop();
        }
    }

    private static MirrorApplication createMirrorApplication(RepositoryReferences sources, DestinationRepositoryDescriptor destination, IProvisioningAgent agent, boolean includePacked) {
        MirrorApplication mirrorApp = new MirrorApplication(agent, includePacked);
        List<RepositoryDescriptor> sourceDescriptors = MirrorApplicationServiceImpl.createSourceDescriptors(sources);
        for (RepositoryDescriptor sourceDescriptor : sourceDescriptors) {
            mirrorApp.addSource(sourceDescriptor);
        }
        mirrorApp.addDestination(MirrorApplicationServiceImpl.createDestinationDescriptor(destination));
        return mirrorApp;
    }

    private static RepositoryDescriptor createDestinationDescriptor(DestinationRepositoryDescriptor destination) {
        RepositoryDescriptor destinationDescriptor = new RepositoryDescriptor();
        destinationDescriptor.setLocation(destination.getLocation().toURI());
        destinationDescriptor.setAppend(destination.isAppend());
        destinationDescriptor.setName(destination.getName());
        destinationDescriptor.setCompressed(destination.isCompress());
        if (destination.isMetaDataOnly()) {
            destinationDescriptor.setKind("M");
        }
        return destinationDescriptor;
    }

    private static void addFilterForFeatureJARs(Map<String, String> filter) {
        filter.put("org.eclipse.update.install.features", "true");
    }

    private static List<RepositoryDescriptor> createSourceDescriptors(RepositoryReferences sources) {
        ArrayList<RepositoryDescriptor> result = new ArrayList<RepositoryDescriptor>();
        MirrorApplicationServiceImpl.createSourceRepositories(result, sources.getMetadataRepositories(), "M");
        MirrorApplicationServiceImpl.createSourceRepositories(result, sources.getArtifactRepositories(), "A");
        return result;
    }

    private static void createSourceRepositories(List<RepositoryDescriptor> result, Collection<URI> repositoryLocations, String repositoryKind) {
        for (URI repositoryLocation : repositoryLocations) {
            RepositoryDescriptor repository = new RepositoryDescriptor();
            repository.setKind(repositoryKind);
            repository.setLocation(repositoryLocation);
            result.add(repository);
        }
    }

    private static List<IInstallableUnit> toInstallableUnitList(Collection<?> units) {
        ArrayList<IInstallableUnit> result = new ArrayList<IInstallableUnit>(units.size());
        for (Object unit : units) {
            result.add((IInstallableUnit)unit);
        }
        return result;
    }

    private static void checkStatus(IStatus status) throws FacadeException {
        if (status.matches(4)) {
            throw new FacadeException("Mirroring failed: " + StatusTool.collectProblems((IStatus)status), StatusTool.findException((IStatus)status));
        }
    }

    public void setMavenContext(MavenContext mavenContext) {
        this.mavenContext = mavenContext;
    }

    static class LogListener
    implements IArtifactMirrorLog {
        private static final String MIRROR_TOOL_MESSAGE_PREFIX = "Mirror tool: ";
        private static final URI MIRROR_TOOL_MESSAGE_HELP = URI.create("http://wiki.eclipse.org/Tycho_Messages_Explained#Mirror_tool");
        private final MavenLogger logger;
        private boolean hasLogged = false;

        LogListener(MavenLogger logger) {
            this.logger = logger;
        }

        public void log(IArtifactDescriptor descriptor, IStatus status) {
            if (!status.isOK()) {
                this.logger.debug(MIRROR_TOOL_MESSAGE_PREFIX + StatusTool.collectProblems((IStatus)status));
                this.hasLogged = true;
            }
        }

        public void log(IStatus status) {
            if (!status.isOK()) {
                this.logger.warn(MIRROR_TOOL_MESSAGE_PREFIX + StatusTool.collectProblems((IStatus)status));
                this.hasLogged = true;
            }
        }

        public void showHelpForLoggedMessages() {
            if (this.hasLogged) {
                this.logger.warn("More information on the preceding warning(s) can be found here:");
                this.logger.warn("- " + MIRROR_TOOL_MESSAGE_HELP);
            }
        }

        public void close() {
        }
    }
}

