/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.equinox.launching.internal;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.sisu.equinox.launching.BundleStartLevel;
import org.eclipse.sisu.equinox.launching.EquinoxInstallation;
import org.eclipse.sisu.equinox.launching.EquinoxInstallationDescription;
import org.eclipse.sisu.equinox.launching.EquinoxInstallationFactory;
import org.eclipse.sisu.equinox.launching.internal.DefaultEquinoxInstallation;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.core.osgitools.BundleReader;
import org.eclipse.tycho.core.osgitools.OsgiManifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=EquinoxInstallationFactory.class)
public class DefaultEquinoxInstallationFactory
implements EquinoxInstallationFactory {
    @Requirement
    private PlexusContainer plexus;
    @Requirement
    private BundleReader manifestReader;
    @Requirement
    private Logger log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EquinoxInstallation createInstallation(EquinoxInstallationDescription description, File location) {
        File file;
        Set<String> bundlesToExplode = description.getBundlesToExplode();
        List<File> frameworkExtensions = description.getFrameworkExtensions();
        Map<String, BundleStartLevel> startLevel = description.getBundleStartLevel();
        LinkedHashMap<ArtifactKey, File> effective = new LinkedHashMap<ArtifactKey, File>();
        for (ArtifactDescriptor artifact : description.getBundles()) {
            boolean directoryShape;
            ArtifactKey key = artifact.getKey();
            file = artifact.getLocation();
            OsgiManifest mf = this.manifestReader.loadManifest(file);
            boolean bl = directoryShape = bundlesToExplode.contains(key.getId()) || mf.isDirectoryShape();
            if (!file.isDirectory() && directoryShape) {
                String filename = key.getId() + "_" + key.getVersion();
                File unpacked = new File(location, "plugins/" + filename);
                unpacked.mkdirs();
                this.unpack(file, unpacked);
                effective.put(key, unpacked);
                continue;
            }
            effective.put(key, file);
        }
        try {
            location.mkdirs();
            Properties p = new Properties();
            p.putAll(description.getPlatformProperties());
            String newOsgiBundles = this.toOsgiBundles(effective, startLevel);
            p.setProperty("osgi.bundles", newOsgiBundles);
            p.setProperty("osgi.bundlefile.limit", "100");
            p.setProperty("osgi.install.area", "file:" + location.getAbsolutePath().replace('\\', '/'));
            p.setProperty("osgi.configuration.cascaded", "false");
            p.setProperty("osgi.framework", "org.eclipse.osgi");
            p.setProperty("osgi.bundles.defaultStartLevel", "4");
            String url = p.getProperty("osgi.framework");
            if (url != null) {
                ArtifactDescriptor desc = description.getBundle(url, null);
                if (desc != null) {
                    url = "file:" + desc.getLocation().getAbsolutePath().replace('\\', '/');
                } else if (url.startsWith("file:")) {
                    String path = url.substring("file:".length());
                    file = new File(path);
                    if (!file.isAbsolute()) {
                        file = new File(location, path);
                    }
                    url = "file:" + file.getAbsolutePath().replace('\\', '/');
                }
            }
            if (url != null) {
                p.setProperty("osgi.framework", url);
            }
            if (!frameworkExtensions.isEmpty()) {
                List<String> bundleNames = this.unpackFrameworkExtensions(location, frameworkExtensions);
                p.setProperty("osgi.framework", this.copySystemBundle(description, location));
                p.setProperty("osgi.framework.extensions", StringUtils.join(bundleNames.iterator(), (String)","));
            }
            if (!description.getDevEntries().isEmpty()) {
                p.put("osgi.dev", this.createDevProperties(location, description.getDevEntries()));
            }
            File configIni = new File(location, "configuration/config.ini");
            File configurationLocation = configIni.getParentFile();
            configurationLocation.mkdirs();
            FileOutputStream fos = new FileOutputStream(configIni);
            try {
                p.store(fos, null);
            }
            finally {
                fos.close();
            }
            return new DefaultEquinoxInstallation(description, location, configurationLocation);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception creating test eclipse runtime", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createDevProperties(File location, Map<String, String> devEntries) throws IOException {
        File file = new File(location, "dev.properties");
        Properties properties = new Properties();
        properties.putAll(devEntries);
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
        try {
            properties.store(os, null);
        }
        finally {
            ((OutputStream)os).close();
        }
        return file.toURI().toURL().toExternalForm();
    }

    protected void unpack(File source, File destination) {
        UnArchiver unzip;
        try {
            unzip = (UnArchiver)this.plexus.lookup(UnArchiver.class, "zip");
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Could not lookup required component", e);
        }
        unzip.setIgnorePermissions(true);
        destination.mkdirs();
        unzip.setSourceFile(source);
        unzip.setDestDirectory(destination);
        try {
            unzip.extract();
        }
        catch (ArchiverException e) {
            throw new RuntimeException("Unable to unpack jar " + source, e);
        }
    }

    private List<String> unpackFrameworkExtensions(File location, Collection<File> frameworkExtensions) throws IOException {
        ArrayList<String> bundleNames = new ArrayList<String>();
        for (File bundleFile : frameworkExtensions) {
            OsgiManifest mf = this.manifestReader.loadManifest(bundleFile);
            bundleNames.add(mf.getBundleSymbolicName());
            File bundleDir = new File(location, "plugins/" + mf.getBundleSymbolicName() + "_" + mf.getBundleVersion());
            if (bundleFile.isFile()) {
                this.unpack(bundleFile, bundleDir);
                continue;
            }
            FileUtils.copyDirectoryStructure((File)bundleFile, (File)bundleDir);
        }
        return bundleNames;
    }

    private String copySystemBundle(EquinoxInstallationDescription description, File location) throws IOException {
        ArtifactDescriptor bundle = description.getSystemBundle();
        File srcFile = bundle.getLocation();
        File dstFile = new File(location, "plugins/" + srcFile.getName());
        FileUtils.copyFileIfModified((File)srcFile, (File)dstFile);
        return "file:" + dstFile.getAbsolutePath().replace('\\', '/');
    }

    protected String toOsgiBundles(Map<ArtifactKey, File> bundles, Map<String, BundleStartLevel> startLevel) throws IOException {
        this.log.debug("Installation OSGI bundles:");
        StringBuilder result = new StringBuilder();
        for (Map.Entry<ArtifactKey, File> entry : bundles.entrySet()) {
            BundleStartLevel level = startLevel.get(entry.getKey().getId());
            if (level != null && level.getLevel() == -1) continue;
            if (result.length() > 0) {
                result.append(",");
            }
            StringBuilder line = new StringBuilder();
            line.append(this.appendAbsolutePath(entry.getValue()));
            if (level != null) {
                line.append('@').append(level.getLevel());
                if (level.isAutoStart()) {
                    line.append(":start");
                }
            }
            this.log.debug("\t" + line);
            result.append(line.toString());
        }
        return result.toString();
    }

    private String appendAbsolutePath(File file) throws IOException {
        String url = file.getAbsolutePath().replace('\\', '/');
        return "reference:file:" + url;
    }
}

