/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.json.bind.JsonbException;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;

public class JsonbAnnotated
implements AnnotatedElement {
    protected final Map<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();

    public JsonbAnnotated(Annotation[] initialAnnotations) {
        this.addInitialAnnotations(initialAnnotations);
    }

    private void addInitialAnnotations(Annotation[] initialAnnotations) {
        for (Annotation ann : initialAnnotations) {
            this.annotations.put(ann.annotationType(), ann);
        }
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)((Annotation)annotationClass.cast(this.annotations.get(annotationClass)));
    }

    @Override
    public Annotation[] getAnnotations() {
        Collection<Annotation> values = this.annotations.values();
        return values.toArray(new Annotation[values.size()]);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        throw new UnsupportedOperationException("Jsonb elements don't track declared annotations");
    }

    public void putAnnotation(Annotation annotation) {
        if (this.annotations.containsKey(annotation.annotationType())) {
            throw new JsonbException(Messages.getMessage(MessageKeys.INTERNAL_ERROR, "Annotation already present: " + annotation));
        }
        this.annotations.put(annotation.annotationType(), annotation);
    }
}

