/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.spark.sql;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.InitializationUtils;
import org.elasticsearch.hadoop.rest.RestRepository;
import org.elasticsearch.hadoop.serialization.FieldType;
import org.elasticsearch.hadoop.serialization.dto.mapping.Field;
import org.elasticsearch.hadoop.serialization.dto.mapping.GeoField;
import org.elasticsearch.hadoop.serialization.dto.mapping.GeoPointType;
import org.elasticsearch.hadoop.serialization.dto.mapping.GeoShapeType;
import org.elasticsearch.hadoop.serialization.dto.mapping.MappingUtils;
import org.elasticsearch.hadoop.serialization.field.FieldFilter;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.IOUtils;
import org.elasticsearch.hadoop.util.SettingsUtils;
import org.elasticsearch.hadoop.util.StringUtils;
import org.elasticsearch.spark.sql.SchemaUtils;
import org.elasticsearch.spark.sql.Utils;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class SchemaUtils$ {
    public static final SchemaUtils$ MODULE$;

    static {
        new SchemaUtils$();
    }

    public SchemaUtils.Schema discoverMapping(Settings cfg) {
        Tuple2<Field, Map<String, GeoField>> tuple2 = this.discoverMappingAsField(cfg);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Field field = (Field)tuple2._1();
            Map geoInfo = (Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)field, (Object)geoInfo);
            Field field2 = (Field)tuple23._1();
            Map geoInfo2 = (Map)tuple23._2();
            StructType struct = this.convertToStruct(field2, geoInfo2, cfg);
            return new SchemaUtils.Schema(field2, struct);
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<Field, Map<String, GeoField>> discoverMappingAsField(Settings cfg) {
        InitializationUtils.validateSettings(cfg);
        InitializationUtils.discoverEsVersion(cfg, Utils.LOGGER);
        RestRepository repo = new RestRepository(cfg);
        try {
            if (repo.indexExists(true)) {
                Field field = repo.getMapping();
                if (field == null) {
                    throw new EsHadoopIllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find mapping for ", " - one is required before using Spark SQL"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cfg.getResourceRead()})));
                }
                field = MappingUtils.filterMapping(field, cfg);
                Map<String, GeoField> geoInfo = repo.sampleGeoFields(field);
                if (StringUtils.hasText(cfg.getReadFieldInclude()) || StringUtils.hasText(cfg.getReadFieldExclude())) {
                    cfg.setProperty("es.internal.mr.target.fields", StringUtils.concatenate(Field.toLookupMap(field).keySet(), ","));
                }
                return new Tuple2((Object)field, geoInfo);
            }
            throw new EsHadoopIllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find mapping for ", " - one is required before using Spark SQL"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cfg.getResourceRead()})));
        }
        finally {
            repo.close();
        }
    }

    public StructType convertToStruct(Field rootField, Map<String, GeoField> geoInfo, Settings cfg) {
        List<FieldFilter.NumberedInclude> arrayIncludes = SettingsUtils.getFieldArrayFilterInclude(cfg);
        List<String> arrayExcludes = StringUtils.tokenize(cfg.getReadFieldAsArrayExclude());
        StructField[] fields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])rootField.properties()).map((Function1)new Serializable(geoInfo, cfg, arrayIncludes, arrayExcludes){
            public static final long serialVersionUID = 0L;
            private final Map geoInfo$2;
            private final Settings cfg$2;
            private final List arrayIncludes$2;
            private final List arrayExcludes$2;

            public final StructField apply(Field fl) {
                return SchemaUtils$.MODULE$.org$elasticsearch$spark$sql$SchemaUtils$$convertField(fl, this.geoInfo$2, null, this.arrayIncludes$2, this.arrayExcludes$2, this.cfg$2);
            }
            {
                this.geoInfo$2 = geoInfo$2;
                this.cfg$2 = cfg$2;
                this.arrayIncludes$2 = arrayIncludes$2;
                this.arrayExcludes$2 = arrayExcludes$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        if (cfg.getReadMetadata()) {
            StructField metadataMap = DataTypes.createStructField((String)cfg.getReadMetadataField(), (DataType)DataTypes.createMapType((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$, (boolean)true), (boolean)true);
            fields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])fields).$colon$plus((Object)metadataMap, ClassTag$.MODULE$.apply(StructField.class));
        }
        return DataTypes.createStructType((StructField[])fields);
    }

    private StructType convertToStruct(Field field, Map<String, GeoField> geoInfo, String parentName, List<FieldFilter.NumberedInclude> arrayIncludes, List<String> arrayExcludes, Settings cfg) {
        return DataTypes.createStructType((StructField[])((StructField[])Predef$.MODULE$.refArrayOps((Object[])field.properties()).map((Function1)new Serializable(geoInfo, parentName, arrayIncludes, arrayExcludes, cfg){
            public static final long serialVersionUID = 0L;
            private final Map geoInfo$1;
            private final String parentName$1;
            private final List arrayIncludes$1;
            private final List arrayExcludes$1;
            private final Settings cfg$1;

            public final StructField apply(Field fl) {
                return SchemaUtils$.MODULE$.org$elasticsearch$spark$sql$SchemaUtils$$convertField(fl, this.geoInfo$1, this.parentName$1, this.arrayIncludes$1, this.arrayExcludes$1, this.cfg$1);
            }
            {
                this.geoInfo$1 = geoInfo$1;
                this.parentName$1 = parentName$1;
                this.arrayIncludes$1 = arrayIncludes$1;
                this.arrayExcludes$1 = arrayExcludes$1;
                this.cfg$1 = cfg$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StructField org$elasticsearch$spark$sql$SchemaUtils$$convertField(Field field, Map<String, GeoField> geoInfo, String parentName, List<FieldFilter.NumberedInclude> arrayIncludes, List<String> arrayExcludes, Settings cfg) {
        NullType$ nullType$;
        String absoluteName = parentName == null ? field.name() : new StringBuilder().append((Object)parentName).append((Object)".").append((Object)field.name()).toString();
        FieldFilter.Result matched = FieldFilter.filter(absoluteName, arrayIncludes, arrayExcludes, false);
        boolean createArray = !arrayIncludes.isEmpty() && matched.matched;
        FieldType fieldType = Utils.extractType(field);
        if (((Object)((Object)FieldType.NULL)).equals((Object)fieldType)) {
            nullType$ = NullType$.MODULE$;
        } else if (((Object)((Object)FieldType.BINARY)).equals((Object)fieldType)) {
            nullType$ = BinaryType$.MODULE$;
        } else if (((Object)((Object)FieldType.BOOLEAN)).equals((Object)fieldType)) {
            nullType$ = BooleanType$.MODULE$;
        } else if (((Object)((Object)FieldType.BYTE)).equals((Object)fieldType)) {
            nullType$ = ByteType$.MODULE$;
        } else if (((Object)((Object)FieldType.SHORT)).equals((Object)fieldType)) {
            nullType$ = ShortType$.MODULE$;
        } else if (((Object)((Object)FieldType.INTEGER)).equals((Object)fieldType)) {
            nullType$ = IntegerType$.MODULE$;
        } else if (((Object)((Object)FieldType.LONG)).equals((Object)fieldType)) {
            nullType$ = LongType$.MODULE$;
        } else if (((Object)((Object)FieldType.FLOAT)).equals((Object)fieldType)) {
            nullType$ = FloatType$.MODULE$;
        } else if (((Object)((Object)FieldType.DOUBLE)).equals((Object)fieldType)) {
            nullType$ = DoubleType$.MODULE$;
        } else if (((Object)((Object)FieldType.STRING)).equals((Object)fieldType)) {
            nullType$ = StringType$.MODULE$;
        } else if (((Object)((Object)FieldType.TEXT)).equals((Object)fieldType)) {
            nullType$ = StringType$.MODULE$;
        } else if (((Object)((Object)FieldType.KEYWORD)).equals((Object)fieldType)) {
            nullType$ = StringType$.MODULE$;
        } else if (((Object)((Object)FieldType.DATE)).equals((Object)fieldType)) {
            nullType$ = cfg.getMappingDateRich() ? TimestampType$.MODULE$ : StringType$.MODULE$;
        } else if (((Object)((Object)FieldType.OBJECT)).equals((Object)fieldType)) {
            nullType$ = this.convertToStruct(field, geoInfo, absoluteName, arrayIncludes, arrayExcludes, cfg);
        } else if (((Object)((Object)FieldType.NESTED)).equals((Object)fieldType)) {
            nullType$ = DataTypes.createArrayType((DataType)this.convertToStruct(field, geoInfo, absoluteName, arrayIncludes, arrayExcludes, cfg));
        } else if (((Object)((Object)FieldType.GEO_POINT)).equals((Object)fieldType)) {
            ArrayType arrayType;
            GeoField geoField = geoInfo.get(absoluteName);
            if (GeoPointType.LON_LAT_ARRAY.equals(geoField)) {
                arrayType = DataTypes.createArrayType((DataType)DoubleType$.MODULE$);
            } else if (GeoPointType.GEOHASH.equals(geoField)) {
                arrayType = StringType$.MODULE$;
            } else if (GeoPointType.LAT_LON_STRING.equals(geoField)) {
                arrayType = StringType$.MODULE$;
            } else {
                if (!GeoPointType.LAT_LON_OBJECT.equals(geoField)) throw new MatchError((Object)geoField);
                StructField lat = DataTypes.createStructField((String)"lat", (DataType)DoubleType$.MODULE$, (boolean)true);
                StructField lon = DataTypes.createStructField((String)"lon", (DataType)DoubleType$.MODULE$, (boolean)true);
                arrayType = DataTypes.createStructType((StructField[])((StructField[])((Object[])new StructField[]{lat, lon})));
            }
            ArrayType geoPoint = arrayType;
            if (Utils.LOGGER.isDebugEnabled()) {
                Utils.LOGGER.debug((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Detected field [", "] as a GeoPoint with format ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{absoluteName, geoPoint.simpleString()})));
            }
            nullType$ = geoPoint;
        } else if (((Object)((Object)FieldType.GEO_SHAPE)).equals((Object)fieldType)) {
            boolean bl;
            ArrayList<StructField> fields = new ArrayList<StructField>();
            fields.add(DataTypes.createStructField((String)"type", (DataType)StringType$.MODULE$, (boolean)true));
            String COORD = "coordinates";
            GeoField geoField = geoInfo.get(absoluteName);
            if (GeoShapeType.POINT.equals(geoField)) {
                bl = fields.add(DataTypes.createStructField((String)COORD, (DataType)DataTypes.createArrayType((DataType)DoubleType$.MODULE$), (boolean)true));
            } else if (GeoShapeType.LINE_STRING.equals(geoField)) {
                bl = fields.add(DataTypes.createStructField((String)COORD, (DataType)this.createNestedArray((DataType)DoubleType$.MODULE$, 2), (boolean)true));
            } else if (GeoShapeType.POLYGON.equals(geoField)) {
                fields.add(DataTypes.createStructField((String)COORD, (DataType)this.createNestedArray((DataType)DoubleType$.MODULE$, 3), (boolean)true));
                bl = fields.add(DataTypes.createStructField((String)"orientation", (DataType)StringType$.MODULE$, (boolean)true));
            } else if (GeoShapeType.MULTI_POINT.equals(geoField)) {
                bl = fields.add(DataTypes.createStructField((String)COORD, (DataType)this.createNestedArray((DataType)DoubleType$.MODULE$, 2), (boolean)true));
            } else if (GeoShapeType.MULTI_LINE_STRING.equals(geoField)) {
                bl = fields.add(DataTypes.createStructField((String)COORD, (DataType)this.createNestedArray((DataType)DoubleType$.MODULE$, 3), (boolean)true));
            } else if (GeoShapeType.MULTI_POLYGON.equals(geoField)) {
                bl = fields.add(DataTypes.createStructField((String)COORD, (DataType)this.createNestedArray((DataType)DoubleType$.MODULE$, 4), (boolean)true));
            } else {
                if (GeoShapeType.GEOMETRY_COLLECTION.equals(geoField)) {
                    throw new EsHadoopIllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Geoshape ", " not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{geoInfo})));
                }
                if (GeoShapeType.ENVELOPE.equals(geoField)) {
                    bl = fields.add(DataTypes.createStructField((String)COORD, (DataType)this.createNestedArray((DataType)DoubleType$.MODULE$, 2), (boolean)true));
                } else {
                    if (!GeoShapeType.CIRCLE.equals(geoField)) throw new MatchError((Object)geoField);
                    fields.add(DataTypes.createStructField((String)COORD, (DataType)DataTypes.createArrayType((DataType)DoubleType$.MODULE$), (boolean)true));
                    bl = fields.add(DataTypes.createStructField((String)"radius", (DataType)StringType$.MODULE$, (boolean)true));
                }
            }
            StructType geoShape = DataTypes.createStructType(fields);
            if (Utils.LOGGER.isDebugEnabled()) {
                Utils.LOGGER.debug((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Detected field [", "] as a GeoShape with format ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{absoluteName, geoShape.simpleString()})));
            }
            nullType$ = geoShape;
        } else {
            nullType$ = StringType$.MODULE$;
        }
        ObjectRef dataType = ObjectRef.create((Object)nullType$);
        if (!createArray) return DataTypes.createStructField((String)field.name(), (DataType)((DataType)dataType.elem), (boolean)true);
        boolean currentDepth = false;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), matched.depth).foreach$mVc$sp((Function1)new Serializable(dataType){
            public static final long serialVersionUID = 0L;
            private final ObjectRef dataType$1;

            public final void apply(int currentDepth) {
                this.apply$mcVI$sp(currentDepth);
            }

            public void apply$mcVI$sp(int currentDepth) {
                this.dataType$1.elem = DataTypes.createArrayType((DataType)((DataType)this.dataType$1.elem));
            }
            {
                this.dataType$1 = dataType$1;
            }
        });
        return DataTypes.createStructField((String)field.name(), (DataType)((DataType)dataType.elem), (boolean)true);
    }

    private DataType createNestedArray(DataType elementType, int depth) {
        boolean currentDepth = false;
        ObjectRef array = ObjectRef.create((Object)elementType);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), depth).foreach$mVc$sp((Function1)new Serializable(array){
            public static final long serialVersionUID = 0L;
            private final ObjectRef array$1;

            public final void apply(int currentDepth) {
                this.apply$mcVI$sp(currentDepth);
            }

            public void apply$mcVI$sp(int currentDepth) {
                this.array$1.elem = DataTypes.createArrayType((DataType)((DataType)this.array$1.elem));
            }
            {
                this.array$1 = array$1;
            }
        });
        return (DataType)array.elem;
    }

    public void setRowInfo(Settings settings, StructType struct) {
        Tuple2<Properties, Properties> rowInfo = this.detectRowInfo(settings, struct);
        settings.setProperty(Utils.ROW_INFO_ORDER_PROPERTY, IOUtils.propsToString((Properties)rowInfo._1()));
        settings.setProperty(Utils.ROW_INFO_ARRAY_PROPERTY, IOUtils.propsToString((Properties)rowInfo._2()));
    }

    public Tuple2<LinkedHashMap<String, Seq<String>>, LinkedHashSet<String>> getRowInfo(Settings settings) {
        String rowOrderString = settings.getProperty(Utils.ROW_INFO_ORDER_PROPERTY);
        Assert.hasText(rowOrderString, "no schema/row order detected...");
        Properties rowOrderProps = IOUtils.propsFromString(rowOrderString);
        String rowArrayString = settings.getProperty(Utils.ROW_INFO_ARRAY_PROPERTY);
        Properties rowArrayProps = StringUtils.hasText(rowArrayString) ? IOUtils.propsFromString(rowArrayString) : new Properties();
        LinkedHashMap order = new LinkedHashMap();
        ((IterableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(rowOrderProps).asScala()).foreach((Function1)new Serializable(order){
            public static final long serialVersionUID = 0L;
            private final LinkedHashMap order$1;

            public final Object apply(Tuple2<String, String> prop) {
                Buffer value = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(StringUtils.tokenize((String)prop._2())).asScala();
                return value.isEmpty() ? BoxedUnit.UNIT : this.order$1.put(prop._1(), (Object)new ArrayBuffer().$plus$plus$eq((TraversableOnce)value));
            }
            {
                this.order$1 = order$1;
            }
        });
        LinkedHashSet needToBeArray = new LinkedHashSet();
        ((IterableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(rowArrayProps).asScala()).foreach((Function1)new Serializable(needToBeArray){
            public static final long serialVersionUID = 0L;
            private final LinkedHashSet needToBeArray$1;

            public final boolean apply(Tuple2<String, String> prop) {
                return this.needToBeArray$1.add(prop._1());
            }
            {
                this.needToBeArray$1 = needToBeArray$1;
            }
        });
        return new Tuple2((Object)order, needToBeArray);
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Properties, Properties> detectRowInfo(Settings settings, StructType struct) {
        void var3_3;
        Tuple2 rowInfo = new Tuple2((Object)new Properties(), (Object)new Properties());
        this.org$elasticsearch$spark$sql$SchemaUtils$$doDetectInfo((Tuple2<Properties, Properties>)rowInfo, Utils.ROOT_LEVEL_NAME, (DataType)struct);
        String csv = SettingsUtils.determineSourceFields(settings);
        Object object = StringUtils.hasText(csv) ? (settings.getReadMetadata() ? ((Properties)rowInfo._1()).setProperty(Utils.ROOT_LEVEL_NAME, new StringBuilder().append((Object)csv).append((Object)",").append((Object)settings.getReadMetadataField()).toString()) : ((Properties)rowInfo._1()).setProperty(Utils.ROOT_LEVEL_NAME, csv)) : BoxedUnit.UNIT;
        return var3_3;
    }

    public void org$elasticsearch$spark$sql$SchemaUtils$$doDetectInfo(Tuple2<Properties, Properties> info, String level, DataType dataType) {
        block3: {
            while (true) {
                DataType dataType2;
                if ((dataType2 = dataType) instanceof StructType) {
                    StructType structType = (StructType)dataType2;
                    ArrayList fields = new ArrayList();
                    structType.foreach((Function1)new Serializable(info, level, fields){
                        public static final long serialVersionUID = 0L;
                        private final Tuple2 info$1;
                        private final String level$1;
                        private final ArrayList fields$1;

                        public final void apply(StructField field) {
                            this.fields$1.add(field.name());
                            String string = this.level$1;
                            String string2 = Utils.ROOT_LEVEL_NAME;
                            SchemaUtils$.MODULE$.org$elasticsearch$spark$sql$SchemaUtils$$doDetectInfo((Tuple2<Properties, Properties>)this.info$1, !(string != null ? !string.equals(string2) : string2 != null) ? field.name() : new StringBuilder().append((Object)this.level$1).append((Object)".").append((Object)field.name()).toString(), field.dataType());
                        }
                        {
                            this.info$1 = info$1;
                            this.level$1 = level$1;
                            this.fields$1 = fields$1;
                        }
                    });
                    ((Properties)info._1()).setProperty(level, StringUtils.concatenate(fields, ","));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(dataType2 instanceof ArrayType)) break;
                ArrayType arrayType = (ArrayType)dataType2;
                String prop = ((Properties)info._2()).getProperty(level);
                int depth = 0;
                if (StringUtils.hasText(prop)) {
                    depth = Integer.parseInt(prop);
                }
                ((Properties)info._2()).setProperty(level, String.valueOf(++depth));
                dataType = arrayType.elementType();
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private SchemaUtils$() {
        MODULE$ = this;
    }
}

