/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.IOUtils;
import org.elasticsearch.hadoop.util.ObjectUtils;
import org.elasticsearch.hadoop.util.StringUtils;

public abstract class SettingsUtils {
    private static List<String> qualifyNodes(String nodes, int defaultPort) {
        List<String> list = StringUtils.tokenize(nodes);
        for (int i = 0; i < list.size(); ++i) {
            String host = list.get(i);
            list.set(i, SettingsUtils.qualifyNode(host, defaultPort));
        }
        return list;
    }

    private static String qualifyNode(String node, int defaultPort) {
        return node.contains(":") ? node : node + ":" + defaultPort;
    }

    public static void pinNode(Settings settings, String node) {
        SettingsUtils.pinNode(settings, node, settings.getPort());
    }

    public static void pinNode(Settings settings, String node, int port) {
        if (StringUtils.hasText(node) && port > 0) {
            settings.setProperty("es.internal.pinned.node", SettingsUtils.qualifyNode(node, port));
        }
    }

    public static boolean hasPinnedNode(Settings settings) {
        return StringUtils.hasText(settings.getProperty("es.internal.pinned.node"));
    }

    public static String getPinnedNode(Settings settings) {
        String node = settings.getProperty("es.internal.pinned.node");
        Assert.hasText(node, "Task has not been pinned to a node...");
        return node;
    }

    public static void addDiscoveredNodes(Settings settings, List<String> discoveredNodes) {
        LinkedHashSet<String> nodes = new LinkedHashSet<String>();
        nodes.addAll(SettingsUtils.declaredNodes(settings));
        nodes.addAll(discoveredNodes);
        SettingsUtils.setDiscoveredNodes(settings, nodes);
    }

    public static void setDiscoveredNodes(Settings settings, Collection<String> nodes) {
        settings.setProperty("es.internal.discovered.nodes", StringUtils.concatenate(nodes, ","));
    }

    public static List<String> declaredNodes(Settings settings) {
        return SettingsUtils.qualifyNodes(settings.getNodes(), settings.getPort());
    }

    public static List<String> discoveredOrDeclaredNodes(Settings settings) {
        String discoveredNodes = settings.getProperty("es.internal.discovered.nodes");
        return StringUtils.hasText(discoveredNodes) ? StringUtils.tokenize(discoveredNodes) : SettingsUtils.declaredNodes(settings);
    }

    public static Map<String, String> aliases(String definition, boolean caseInsensitive) {
        List<String> aliases = StringUtils.tokenize(definition);
        LinkedHashMap<String, String> aliasMap = new LinkedHashMap<String, String>();
        if (aliases != null) {
            for (String string : aliases) {
                int index = (string = string.trim()).indexOf(":");
                if (index <= 0) continue;
                String key = string.substring(0, index);
                aliasMap.put(key, string.substring(index + 1));
                aliasMap.put(caseInsensitive ? key.toLowerCase(Locale.ROOT) : key, string.substring(index + 1));
            }
        }
        return aliasMap;
    }

    public static void setFilters(Settings settings, String ... filters) {
        settings.setProperty("es.internal.query.filters", "");
        if (ObjectUtils.isEmpty(filters)) {
            return;
        }
        settings.setProperty("es.internal.query.filters", IOUtils.serializeToBase64((Serializable)filters));
    }

    public static String[] getFilters(Settings settings) {
        return (String[])IOUtils.deserializeFromBase64(settings.getProperty("es.internal.query.filters"));
    }

    public static boolean isEs20(Settings settings) {
        String version = settings.getProperty("es.internal.es.version");
        if (!StringUtils.hasText(version)) {
            return true;
        }
        return version.startsWith("2.");
    }
}

