/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.delegation;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PasswordFinder;
import org.glite.security.delegation.DelegationException;
import org.glite.security.delegation.GrDProxyDlgorOptions;
import org.glite.security.util.DNHandler;
import org.glite.security.util.FileCertReader;
import org.glite.security.util.Password;
import org.glite.security.util.PrivateKeyReader;
import org.glite.security.util.proxy.ProxyCertificateGenerator;

public class DelegationHandler {
    private static final Logger LOGGER = Logger.getLogger(DelegationHandler.class);
    private X509Certificate[] m_certs = null;
    private String strX509CertChain = null;

    public DelegationHandler(String certReq, String delegationID, String propFile) throws Exception {
        this.requestHandler(certReq, delegationID, propFile);
    }

    private void requestHandler(String certReq, String delegationID, String propFile) throws Exception {
        GrDProxyDlgorOptions dlgorOpt = null;
        try {
            dlgorOpt = new GrDProxyDlgorOptions(propFile);
        }
        catch (IOException e2) {
            LOGGER.error((Object)("failed to read delegation options from: " + propFile + " nor from default location. Error was: " + e2.getMessage()));
            return;
        }
        try {
            PKCS10CertificationRequest req;
            LOGGER.debug((Object)("User Cert/Proxy File" + dlgorOpt.getDlgorCertFile()));
            LOGGER.debug((Object)("User Key/Proxy File" + dlgorOpt.getDlgorKeyFile()));
            LOGGER.debug((Object)("User Password" + dlgorOpt.getDlgorPass()));
            LOGGER.debug((Object)("Certificate Request" + certReq));
            FileCertReader certReader = new FileCertReader();
            X509Certificate[] certs = certReader.readCerts(dlgorOpt.getDlgorCertFile()).toArray(new X509Certificate[0]);
            for (int n = 0; n < certs.length; ++n) {
                LOGGER.debug((Object)("cert [" + n + "] is from " + DNHandler.getSubject((X509Certificate)certs[n]).getRFCDN()));
            }
            PEMReader pemReader = new PEMReader((Reader)new StringReader(certReq));
            try {
                req = (PKCS10CertificationRequest)pemReader.readObject();
            }
            catch (IOException e1) {
                LOGGER.error((Object)"Could not load the original certificate request from cache.");
                throw new DelegationException("Could not load the original certificate request from cache: " + e1.getMessage());
            }
            ProxyCertificateGenerator genGen = new ProxyCertificateGenerator(certs, req);
            Password pass = null;
            if (dlgorOpt.getDlgorPass() != null) {
                pass = new Password(dlgorOpt.getDlgorPass().toCharArray());
            }
            PrivateKey key = PrivateKeyReader.read((BufferedReader)new BufferedReader(new FileReader(dlgorOpt.getDlgorKeyFile())), (PasswordFinder)pass);
            genGen.generate(key);
            certs = genGen.getCertChain();
            this.strX509CertChain = genGen.getCertChainAsPEM();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Proxy generation failed: " + e));
            throw e;
        }
    }

    public X509Certificate[] getProxyCertificate() throws Exception {
        return this.m_certs;
    }

    public String getPEMProxyCertificate() {
        return this.strX509CertChain;
    }
}

