/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.delegation;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.jce.provider.JDKKeyPairGenerator;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.glite.security.SecurityContext;
import org.glite.security.delegation.GrDPConstants;
import org.glite.security.delegation.storage.GrDPStorageFactory;
import org.glite.security.util.PrivateKeyReader;
import org.glite.voms.VOMSValidator;

public class GrDPX509Util {
    private static final Logger LOGGER = Logger.getLogger(GrDPX509Util.class);
    public static final String CERT_CHAIN_CONTENT_TYPE = "application/x-x509-user-cert-chain";
    public static final String CERT_REQ_CONTENT_TYPE = "application/x-x509-cert-request";
    private static MessageDigest s_digester = null;

    public static String writePEM(byte[] bytes, String hdr, String ftr) {
        StringBuffer buff = new StringBuffer();
        byte[] pemBytes = Base64.encode((byte[])bytes);
        buff.append(hdr);
        for (int n = 0; n < pemBytes.length; n += 64) {
            if (pemBytes.length - n < 64) {
                buff.append(new String(pemBytes, n, pemBytes.length - n));
            } else {
                buff.append(new String(pemBytes, n, 64));
            }
            buff.append("\n");
        }
        buff.append(ftr);
        return buff.toString();
    }

    public static byte[] readPEM(InputStream is, String hdr, String ftr) throws IOException {
        String line;
        InputStreamReader irr = new InputStreamReader(is);
        BufferedReader r = new BufferedReader(irr);
        StringBuffer buff = new StringBuffer();
        boolean read = false;
        while ((line = r.readLine()) != null) {
            if (line.equals(hdr)) {
                read = true;
                continue;
            }
            if (line.equals(ftr)) {
                read = false;
            }
            if (!read) continue;
            buff.append(line);
        }
        return Base64.decode((byte[])buff.toString().getBytes());
    }

    public static byte[] readPEM(String in, String hdr, String ftr) {
        int hdrIndex = in.indexOf(hdr);
        int ftrIndex = in.indexOf(ftr, hdrIndex += hdr.length());
        return Base64.decode((byte[])in.substring(hdrIndex, ftrIndex).getBytes());
    }

    public static X509Name makeGridCertDN(String organization, String orgUnit, String commonName, String country, String email) {
        Hashtable<DERObjectIdentifier, String> attrs = new Hashtable<DERObjectIdentifier, String>();
        attrs.put(X509Name.O, organization);
        attrs.put(X509Name.OU, orgUnit);
        attrs.put(X509Name.C, country);
        attrs.put(X509Name.EmailAddress, email);
        attrs.put(X509Name.CN, commonName);
        X509Name x509Name = new X509Name(attrs);
        LOGGER.debug((Object)("GrDPX509Util : " + x509Name.toString()));
        return x509Name;
    }

    public static X509Name makeGridCertDN(String DN2) {
        X509Name x509Name = new X509Name(DN2);
        LOGGER.debug((Object)("GrDPX509Util : " + x509Name.toString()));
        return x509Name;
    }

    public static void saveCertReqToFile(String certReq, String fileLocation) throws IOException {
        FileOutputStream os = new FileOutputStream(fileLocation);
        os.write(certReq.getBytes());
        os.close();
    }

    public static void saveCertProxyTofile(X509Certificate certProxy, String fileLocation) {
        try {
            FileOutputStream os = new FileOutputStream(fileLocation);
            if (!GrDPX509Util.changeFileMode(fileLocation, 600)) {
                LOGGER.error((Object)"Warning: Please check file permissions for your proxy file.");
            }
            String s = GrDPX509Util.writePEM(certProxy.getEncoded(), GrDPConstants.CH + GrDPConstants.NEWLINE, GrDPConstants.CF + GrDPConstants.NEWLINE);
            ((OutputStream)os).write(s.getBytes());
            ((OutputStream)os).close();
        }
        catch (IOException ie) {
            LOGGER.error((Object)("Error saving certt to file" + ie.getMessage()));
        }
        catch (CertificateEncodingException e) {
            LOGGER.error((Object)("Error writePEM " + e.getMessage()));
        }
    }

    public static void saveCertProxyTofile(String inCertProxy, String fileLocation, String delegationID, String userDN, boolean append) {
        String crt = null;
        String certProxyChain = null;
        String ENDCERT = GrDPConstants.CF;
        String certProxy = inCertProxy;
        try {
            RandomAccessFile f = new RandomAccessFile(fileLocation, "rw");
            byte[] privateKeyByte = new byte[(int)f.length()];
            f.read(privateKeyByte);
            f.seek(0L);
            certProxy = delegationID + "\n" + userDN.replaceAll("CN=proxy,", "") + "\n" + certProxy;
            crt = certProxy.substring(0, certProxy.indexOf(ENDCERT) + ENDCERT.length() + 1);
            certProxyChain = certProxy.substring(certProxy.indexOf(ENDCERT) + ENDCERT.length(), certProxy.length());
            f.writeBytes(crt);
            f.write(privateKeyByte);
            f.writeBytes(certProxyChain);
            f.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!GrDPX509Util.changeFileMode(fileLocation, 600)) {
            LOGGER.error((Object)"Warning: Please check file permissions for your proxy file.");
        }
    }

    public static void savePrivateKey(PrivateKey pk, String fileLocation, String delegationID, String userDN) throws FileNotFoundException, IOException {
        String prvkey = null;
        prvkey = GrDPX509Util.writePEM(PrivateKeyReader.getEncoded((PrivateKey)pk), GrDPConstants.PRVH + GrDPConstants.NEWLINE, GrDPConstants.PRVF + GrDPConstants.NEWLINE);
        prvkey = delegationID + "\n" + userDN.replaceAll(",CN=proxy", "\u0000") + "\n" + prvkey;
        FileOutputStream os = new FileOutputStream(fileLocation);
        os.write(prvkey.getBytes());
        os.close();
    }

    public static String findProxyInCache(String strDirCache, String delegationID, String userDN) {
        File dir = new File(strDirCache);
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir1, String name) {
                return !name.startsWith(".");
            }
        };
        String[] proxyfilesList = dir.list(filter);
        if (proxyfilesList == null) {
            LOGGER.error((Object)"Error : No file in proxy cache");
        } else {
            for (int i = 0; i < proxyfilesList.length; ++i) {
                String filename = proxyfilesList[i];
                try {
                    BufferedReader in = new BufferedReader(new FileReader(dir.getPath() + "/" + filename));
                    if (in.readLine().equals(delegationID) && in.readLine().equals(userDN)) {
                        in.close();
                        return filename;
                    }
                    in.close();
                    continue;
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Error in reading proxy file");
                }
            }
        }
        return null;
    }

    public static String findPrivateKeyInCache(String strDirCache, String delegationID, String userDN) {
        File dir = new File(strDirCache);
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir1, String name) {
                return name.startsWith(".");
            }
        };
        String[] proxyfilesList = dir.list(filter);
        if (proxyfilesList == null) {
            LOGGER.error((Object)"Error : No private key file in proxy cache");
        } else {
            for (int i = 0; i < proxyfilesList.length; ++i) {
                String filename = proxyfilesList[i];
                try {
                    BufferedReader in = new BufferedReader(new FileReader(dir.getPath() + "/" + filename));
                    if (in.readLine().equals(delegationID) && in.readLine().equals(userDN)) {
                        in.close();
                        return filename;
                    }
                    in.close();
                    continue;
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Error in reading private key file");
                }
            }
        }
        return null;
    }

    public static X509Certificate loadCertificate(InputStream cert) throws NoSuchProviderException {
        X509Certificate certificate = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            certificate = (X509Certificate)cf.generateCertificate(cert);
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        return certificate;
    }

    public static X509Certificate[] loadCertificateChain(byte[] bCerts) throws IOException, CertificateException, NoSuchProviderException {
        return GrDPX509Util.loadCertificateChain(new BufferedInputStream(new ByteArrayInputStream(bCerts)));
    }

    public static X509Certificate[] loadCertificateChain(BufferedInputStream bisCerts) throws IOException, CertificateException, NoSuchProviderException {
        Vector<Certificate> certVector = new Vector<Certificate>();
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
        while (bisCerts.available() > 0) {
            certVector.add(cf.generateCertificate(bisCerts));
        }
        Object[] certificate = new X509Certificate[certVector.size()];
        certVector.copyInto(certificate);
        return certificate;
    }

    public static PKCS10CertificationRequest loadCertificateRequest(String request) {
        return new PKCS10CertificationRequest(GrDPX509Util.readPEM(request, GrDPConstants.CRH + GrDPConstants.NEWLINE, GrDPConstants.CRF + GrDPConstants.NEWLINE));
    }

    public static byte[] getFilesBytes(File file) throws IOException {
        int offset;
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            LOGGER.error((Object)"getFilesBytes :: File is too long to read !");
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Uncomplete file reading  " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    public static byte[] certChainToByte(X509Certificate[] x509Cert) throws CertificateEncodingException {
        String strX509CertChain = "";
        for (int index = 0; index < x509Cert.length; ++index) {
            strX509CertChain = strX509CertChain + GrDPX509Util.writePEM(x509Cert[index].getEncoded(), GrDPConstants.CH + GrDPConstants.NEWLINE, GrDPConstants.CF + GrDPConstants.NEWLINE);
            LOGGER.debug((Object)("CertRequestHandler : Generated proxyCertificate" + strX509CertChain));
        }
        return strX509CertChain.getBytes();
    }

    public static synchronized byte[] digest(byte[] input) {
        return s_digester.digest(input);
    }

    public static boolean changeFileMode(String file, int mode) {
        Runtime runtime = Runtime.getRuntime();
        String[] cmd = new String[]{"chmod", String.valueOf(mode), file};
        try {
            Process process = runtime.exec(cmd, null);
            return process.waitFor() == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getDefaultCertFile() {
        String location = null;
        location = System.getProperty("X509_USER_CERT");
        return location;
    }

    public static String getDefaultKeyFile() {
        String location = null;
        location = System.getProperty("X509_USER_KEY");
        return location;
    }

    public static String getDefaultCertLocation() {
        String location = null;
        location = System.getProperty("X509_CERT_DIR");
        return location;
    }

    public static String getDefaultProxyFile() {
        String location = System.getProperty("X509_USER_PROXY");
        return location;
    }

    public static String digestFileName(String delegationid_in, String DN_in) {
        byte[] dgstDlgID = null;
        byte[] dgstDN = null;
        String filenameP1 = null;
        String filenameP2 = "-";
        String filenameP3 = null;
        dgstDlgID = GrDPX509Util.digest(delegationid_in.getBytes());
        dgstDlgID = GrDPX509Util.get8MostSignificant(dgstDlgID);
        filenameP1 = new String(Hex.encode((byte[])dgstDlgID));
        LOGGER.debug((Object)("DN TO DIGEST : " + DN_in.replaceAll("CN=proxy,", "")));
        dgstDN = GrDPX509Util.digest(DN_in.replaceAll("CN=proxy,", "").getBytes());
        dgstDN = GrDPX509Util.get8MostSignificant(dgstDN);
        filenameP3 = new String(Hex.encode((byte[])dgstDN));
        LOGGER.debug((Object)("Digest of file name : " + filenameP1 + filenameP2 + filenameP3));
        return filenameP1 + filenameP2 + filenameP3;
    }

    private static byte[] get8MostSignificant(byte[] input) {
        byte[] result = new byte[8];
        for (int i = 0; i <= 7; ++i) {
            result[i] = input[i];
        }
        return result;
    }

    private static byte[] getMostSignificant(byte[] input, int n) {
        byte[] result = new byte[n];
        for (int i = 0; i <= n - 1; ++i) {
            result[i] = input[i];
        }
        return result;
    }

    public static String certReqResponse(String certReq) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("HTTP/1.1 200 ok\r\n");
        buffer.append("Content-type: application/x-x509-cert-request\r\n\r\n");
        buffer.append(certReq);
        return buffer.toString();
    }

    public static String certProxyResponse(String proxyCert) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("HTTP/1.1 200 ok\r\n");
        buffer.append("Content-type: application/x-x509-user-cert-chain\r\n\r\n");
        buffer.append(proxyCert);
        return buffer.toString();
    }

    public static String errorResponse(String errorMsg) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("HTTP/1.1 " + errorMsg + "\r\n");
        buffer.append("\r\n");
        return buffer.toString();
    }

    public static String getDlgeePropertyFile() {
        String dlgeePropertyFile = null;
        dlgeePropertyFile = System.getProperty("GLITE_DLGEE_PROPERTY", "dlgee.properties");
        LOGGER.debug((Object)("GLITE_DLGEE_PROPERTY : " + dlgeePropertyFile));
        return dlgeePropertyFile;
    }

    public static String getDlgorPropertyFile() {
        String dlgorPropertyFile = null;
        dlgorPropertyFile = System.getProperty("GLITE_DLGOR_PROPERTY", "dlgor.properties");
        return dlgorPropertyFile;
    }

    public static GrDPStorageFactory getGrDPStorageFactory(String factoryClass) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        LOGGER.debug((Object)"Entered getGrDStorage.");
        Class<?> storageClass = Class.forName(factoryClass);
        LOGGER.debug((Object)("Successfully loaded class '" + factoryClass + "'"));
        return (GrDPStorageFactory)storageClass.newInstance();
    }

    public static String createCertificateRequest(X509Name subjectDN, String sigAlgName, KeyPair keyPair) throws GeneralSecurityException {
        PKCS10CertificationRequest certRequest = new PKCS10CertificationRequest(sigAlgName, subjectDN, keyPair.getPublic(), null, keyPair.getPrivate());
        StringWriter stringWriter = new StringWriter();
        PEMWriter pemWriter = new PEMWriter((Writer)stringWriter);
        try {
            pemWriter.writeObject((Object)certRequest);
            pemWriter.flush();
        }
        catch (IOException e) {
            throw new GeneralSecurityException("Certificate output as string failed: " + e.getMessage());
        }
        return stringWriter.toString();
    }

    public static String createCertificateRequest(X509Certificate subjectCert, String sigAlgName, KeyPair keyPair) throws GeneralSecurityException {
        PKCS10CertificationRequest certRequest = new PKCS10CertificationRequest(sigAlgName, subjectCert.getSubjectX500Principal(), keyPair.getPublic(), null, keyPair.getPrivate());
        StringWriter stringWriter = new StringWriter();
        PEMWriter pemWriter = new PEMWriter((Writer)stringWriter);
        try {
            pemWriter.writeObject((Object)certRequest);
            pemWriter.flush();
        }
        catch (IOException e) {
            throw new GeneralSecurityException("Certificate output as string failed: " + e.getMessage());
        }
        return stringWriter.toString();
    }

    public static KeyPair getKeyPair(int size) {
        SecureRandom rand = new SecureRandom();
        JDKKeyPairGenerator.RSA keyPairGen = new JDKKeyPairGenerator.RSA();
        keyPairGen.initialize(size, rand);
        return keyPairGen.generateKeyPair();
    }

    public static String generateSessionID(PublicKey pk) throws NoSuchAlgorithmException {
        return new String(Hex.encode((byte[])GrDPX509Util.getMostSignificant(GrDPX509Util.digest(pk.getEncoded()), 20)));
    }

    public static String genDlgID(String dn, String[] vomsAttributes) {
        String originalString = dn;
        if (vomsAttributes != null) {
            for (int i = 0; i < vomsAttributes.length; ++i) {
                originalString = originalString + vomsAttributes[i];
            }
        } else {
            LOGGER.debug((Object)"No VOMS attributes in client certificate. Generating DLG ID usingonly the client DN.");
        }
        String digestString = new String(Hex.encode((byte[])GrDPX509Util.getMostSignificant(GrDPX509Util.digest(originalString.getBytes()), 20)));
        LOGGER.debug((Object)("Digest VOMS Attributes: " + digestString));
        return digestString;
    }

    public static String[] getVOMSAttributes(SecurityContext sc) {
        VOMSValidator validator = new VOMSValidator(sc.getClientCertChain());
        String[] attributes = validator.validate().getAllFullyQualifiedAttributes();
        validator.cleanup();
        return attributes;
    }

    public static String toStringVOMSAttrs(String[] vomsAttributes) {
        if (vomsAttributes == null) {
            return "";
        }
        String vomsAttrsStr = "";
        for (int i = 0; i < vomsAttributes.length; ++i) {
            vomsAttrsStr = vomsAttrsStr + "\t" + vomsAttributes[i];
        }
        return vomsAttrsStr;
    }

    public static String[] fromStringVOMSAttrs(String vomsAttributesStr) {
        if (vomsAttributesStr == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer("\t");
        ArrayList<String> vomsAttributes = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            vomsAttributes.add(st.nextToken());
        }
        return vomsAttributes.toArray(new String[0]);
    }

    static {
        LOGGER.info((Object)"initalizing ACValidator");
        try {
            s_digester = MessageDigest.getInstance("SHA-1");
        }
        catch (Exception e) {
            LOGGER.fatal((Object)("Message digester implementation not found: " + e.getMessage()), (Throwable)e);
            throw new RuntimeException("Delegation utilities code initialization failed: " + e.getMessage(), e);
        }
    }
}

