/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.delegation;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.jce.X509V3CertificateGenerator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.glite.security.delegation.GrDPConstants;
import org.glite.security.delegation.GrDPX509Util;
import org.glite.security.util.FileCertReader;
import org.glite.security.util.PrivateKeyReader;

public class GrDProxyGenerator {
    static Logger logger = Logger.getLogger(GrDProxyGenerator.class);
    private PrivateKey userPrivateKey = null;
    private String pwd = null;
    private int proxyType;
    private int pathLen = -1;
    private boolean limited = true;
    private String proxyFile = GrDPX509Util.getDefaultProxyFile();
    private String keyFile = null;
    private String certFile = null;
    private X509Certificate certificate;
    private int bits = 512;
    private int lifetime = 43200;
    private boolean quiet = false;
    private boolean debug = false;
    private X509Certificate certProxy = null;

    public GrDProxyGenerator() {
        if (Security.getProvider("BC") == null) {
            Security.insertProviderAt((Provider)new BouncyCastleProvider(), 6);
        }
    }

    public byte[] x509MakeProxyCert(byte[] inCertReq, byte[] inUserCert, byte[] inUserKey, String pwd1) throws CertificateException, GeneralSecurityException, Exception {
        X509Certificate[] userCert = null;
        PrivateKey pvk = null;
        ByteArrayInputStream inTCertReq = null;
        inTCertReq = new ByteArrayInputStream(GrDPX509Util.readPEM(new ByteArrayInputStream(inCertReq), GrDPConstants.CRH, GrDPConstants.CRF));
        if (inUserCert != null && inUserKey != null) {
            userCert = GrDPX509Util.loadCertificateChain(new BufferedInputStream(new ByteArrayInputStream(inUserCert)));
            if (userCert.length <= 0) {
                logger.error((Object)("Invalid user certificate. Number of certificates in chain : " + userCert.length));
                throw new GeneralSecurityException("Invalid user certificate.");
            }
        } else {
            logger.error((Object)"Error, CreateProxyFromCertReq :: UserCertificate and UserKey can not be null.");
            throw new CertificateException("Error, CreateProxyFromCertReq :: UserCertificate and UserKey can not be null.");
        }
        pvk = PrivateKeyReader.read((BufferedInputStream)new BufferedInputStream(new ByteArrayInputStream(inUserKey)), (String)pwd1);
        X509Certificate[] cp = new X509Certificate[userCert.length + 1];
        DERInputStream derin = new DERInputStream((InputStream)inTCertReq);
        DERObject reqInfo = derin.readObject();
        PKCS10CertificationRequest certReq = new PKCS10CertificationRequest((ASN1Sequence)((DERConstructedSequence)reqInfo));
        logger.debug((Object)("Number of Certificates in chain : " + Integer.toString(userCert.length)));
        if (!certReq.verify()) {
            throw new GeneralSecurityException("Certificate request verification failed!");
        }
        cp[0] = this.createProxyCertificate(userCert[0], pvk, certReq.getPublicKey(), this.lifetime, this.proxyType, "proxy");
        for (int index = 1; index <= userCert.length; ++index) {
            cp[index] = userCert[index - 1];
        }
        this.certProxy = cp[0];
        return GrDPX509Util.certChainToByte(cp);
    }

    public byte[] x509MakeProxyCert(byte[] inCertReq, byte[] inProxy, String password) throws IOException, GeneralSecurityException {
        return this.x509MakeProxyCert(inCertReq, inProxy);
    }

    public byte[] x509MakeProxyCert(byte[] inCertReq, byte[] inProxy) throws IOException, GeneralSecurityException {
        X509Certificate[] proxyCertChain = null;
        PrivateKey proxyPrivKey = null;
        X509Certificate[] finalCertChain = null;
        proxyCertChain = GrDPX509Util.loadCertificateChain(new BufferedInputStream(new ByteArrayInputStream(inProxy)));
        if (inCertReq == null || inProxy == null) {
            throw new GeneralSecurityException("Either the cert request or proxy cert were passed as null arguments. Cannot continue.");
        }
        if (proxyCertChain.length <= 0) {
            throw new GeneralSecurityException("Invalid number of certificates in proxy chain: " + proxyCertChain.length);
        }
        logger.debug((Object)("Number of certificates in proxy chain: " + proxyCertChain.length));
        FileCertReader fileReader = new FileCertReader();
        KeyStore store = fileReader.readProxy(new BufferedInputStream(new ByteArrayInputStream(inProxy)), "keypair");
        proxyPrivKey = (PrivateKey)store.getKey("host", "keypair".toCharArray());
        ByteArrayInputStream inTCertReq = new ByteArrayInputStream(GrDPX509Util.readPEM(new ByteArrayInputStream(inCertReq), GrDPConstants.CRH, GrDPConstants.CRF));
        DERInputStream derin = new DERInputStream((InputStream)inTCertReq);
        DERObject reqInfo = derin.readObject();
        PKCS10CertificationRequest certReq = new PKCS10CertificationRequest((ASN1Sequence)((DERConstructedSequence)reqInfo));
        if (!certReq.verify()) {
            throw new GeneralSecurityException("Certificate request verification failed!");
        }
        finalCertChain = new X509Certificate[proxyCertChain.length + 1];
        finalCertChain[0] = this.createProxyCertificate(proxyCertChain[0], proxyPrivKey, certReq.getPublicKey(), this.lifetime, this.proxyType, "proxy");
        for (int i = 0; i < proxyCertChain.length; ++i) {
            finalCertChain[i + 1] = proxyCertChain[i];
        }
        this.certProxy = finalCertChain[0];
        return GrDPX509Util.certChainToByte(finalCertChain);
    }

    public X509Certificate[] createProxyFromCertReq(InputStream inCertReq, BufferedInputStream inUserCert, InputStream inUserKey, String pwd1) throws GeneralSecurityException, IOException, Exception {
        X509Certificate[] userCert = null;
        PrivateKey userPrivKey = null;
        PKCS10CertificationRequest certRequest = null;
        X509Certificate[] proxyCert = null;
        userCert = GrDPX509Util.loadCertificateChain(inUserCert);
        logger.debug((Object)("User Certificate - number of certificates in chain: " + userCert.length));
        userPrivKey = PrivateKeyReader.read((BufferedInputStream)new BufferedInputStream(inUserKey), (String)pwd1);
        DERInputStream derin = new DERInputStream((InputStream)new ByteArrayInputStream(GrDPX509Util.readPEM(inCertReq, GrDPConstants.CRH, GrDPConstants.CRF)));
        DERObject reqInfo = derin.readObject();
        certRequest = new PKCS10CertificationRequest((ASN1Sequence)((DERConstructedSequence)reqInfo));
        proxyCert = new X509Certificate[userCert.length + 1];
        if (!certRequest.verify()) {
            throw new GeneralSecurityException("Certificate request verification failed.");
        }
        proxyCert[0] = this.createProxyCertificate(userCert[0], userPrivKey, certRequest.getPublicKey(), this.lifetime, this.proxyType, "proxy");
        for (int index = 1; index <= userCert.length; ++index) {
            proxyCert[index] = userCert[index - 1];
        }
        this.certProxy = proxyCert[0];
        return proxyCert;
    }

    public X509Certificate createProxyFromCert(InputStream inCert, InputStream inCACert, InputStream inCAKey, String caPwd) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, GeneralSecurityException {
        X509Certificate result;
        X509Certificate issuerCert = GrDPX509Util.loadCertificate(inCACert);
        X509Certificate rqCert = GrDPX509Util.loadCertificate(inCert);
        PublicKey publicKey = rqCert.getPublicKey();
        PrivateKey issuerKey = null;
        try {
            issuerKey = PrivateKeyReader.read((BufferedInputStream)new BufferedInputStream(inCAKey), (String)caPwd);
        }
        catch (Exception e) {
            logger.error((Object)"Error : createProxyFromCert , unable to load private key");
        }
        this.certProxy = result = this.createProxyCertificate(issuerCert, issuerKey, publicKey, this.lifetime, this.proxyType, null);
        return result;
    }

    public X509Certificate getCertProxy() {
        return this.certProxy;
    }

    public void saveCertProxyTofile() throws IOException, CertificateEncodingException {
        FileOutputStream os = new FileOutputStream(this.proxyFile);
        if (!GrDPX509Util.changeFileMode(this.proxyFile, 600)) {
            System.err.println("Warning: Please check file permissions for your proxy file.");
        }
        String s = GrDPX509Util.writePEM(this.certProxy.getEncoded(), GrDPConstants.CH + GrDPConstants.NEWLINE, GrDPConstants.CF + GrDPConstants.NEWLINE);
        os.write(s.getBytes());
        os.close();
    }

    public void saveCertProxyTofile(String delegationID, String userDN) throws IOException, CertificateEncodingException {
        FileOutputStream os = new FileOutputStream(this.proxyFile);
        if (!GrDPX509Util.changeFileMode(this.proxyFile, 600)) {
            System.err.println("Warning: Please check file permissions for your proxy file.");
        }
        String s = GrDPX509Util.writePEM(this.certProxy.getEncoded(), GrDPConstants.CH + GrDPConstants.NEWLINE, GrDPConstants.CF + GrDPConstants.NEWLINE);
        s = delegationID + "\n" + userDN + "\n" + s;
        os.write(s.getBytes());
        os.close();
    }

    public void setBits(int bits) {
        this.bits = bits;
    }

    public void setLifetime(int hours) {
        this.lifetime = hours * 3600;
    }

    public void setProxyType(int proxyType) {
        this.proxyType = proxyType;
    }

    public void setProxyAslimited() {
        this.limited = true;
    }

    public void setPathLength(int pathLength) {
        this.pathLen = pathLength;
    }

    public void setProxyFile(String proxyFile) {
        this.proxyFile = proxyFile;
    }

    public void setKeyFile(String keyFile) {
        this.keyFile = keyFile;
    }

    public void setCertFile(String certFile) {
        this.certFile = certFile;
    }

    public X509Certificate createProxyCertificate(X509Certificate issuerCert, PrivateKey issuerKey, PublicKey publicKey, int lifetime1, int proxyType1, String cnValue) throws GeneralSecurityException {
        X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
        BigInteger serialNum = null;
        serialNum = issuerCert.getSerialNumber();
        X509Name issuer = (X509Name)issuerCert.getSubjectDN();
        ASN1Sequence seqSubject = (ASN1Sequence)issuer.getDERObject();
        logger.debug((Object)("SubjectDN of IssuerCert" + issuer));
        DEREncodableVector v = new DEREncodableVector();
        v.add((DEREncodable)X509Name.CN);
        v.add((DEREncodable)new DERPrintableString(cnValue));
        Enumeration subjectParts = seqSubject.getObjects();
        DEREncodableVector subjectVector = new DEREncodableVector();
        while (subjectParts.hasMoreElements()) {
            DERObject part = (DERObject)subjectParts.nextElement();
            subjectVector.add((DEREncodable)part);
        }
        subjectVector.add((DEREncodable)new DERSet((DEREncodable)new DERSequence(v)));
        DERSequence subjDerSeq = new DERSequence(subjectVector);
        X509Name subjectX = new X509Name((ASN1Sequence)subjDerSeq);
        logger.debug((Object)("SubjectDN :" + subjectX));
        certGen.setSubjectDN(subjectX);
        certGen.setIssuerDN(issuer);
        certGen.setSerialNumber(serialNum);
        certGen.setPublicKey(publicKey);
        certGen.setSignatureAlgorithm(issuerCert.getSigAlgName());
        certGen.addExtension(X509Extensions.KeyUsage, false, (DEREncodable)new KeyUsage(144));
        GregorianCalendar date = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        date.add(12, -5);
        certGen.setNotBefore(date.getTime());
        if (lifetime1 <= 0) {
            certGen.setNotAfter(issuerCert.getNotAfter());
        } else {
            date.add(12, 5);
            date.add(13, lifetime1);
            certGen.setNotAfter(date.getTime());
        }
        return certGen.generateX509Certificate(issuerKey);
    }
}

