/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.delegation.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PEMWriter;
import org.glite.security.SecurityContext;
import org.glite.security.delegation.DelegationException;
import org.glite.security.delegation.GrDPX509Util;
import org.glite.security.delegation.GrDProxyDlgeeOptions;
import org.glite.security.delegation.NewProxyReq;
import org.glite.security.delegation.storage.GrDPStorage;
import org.glite.security.delegation.storage.GrDPStorageCacheElement;
import org.glite.security.delegation.storage.GrDPStorageElement;
import org.glite.security.delegation.storage.GrDPStorageException;
import org.glite.security.delegation.storage.GrDPStorageFactory;
import org.glite.security.util.CertUtil;
import org.glite.security.util.DN;
import org.glite.security.util.DNHandler;
import org.glite.security.util.FileCertReader;
import org.glite.security.util.PrivateKeyReader;
import org.glite.security.util.axis.InitSecurityContext;

public class GliteDelegation {
    private static Logger logger = Logger.getLogger(GliteDelegation.class);
    private int DEFAULT_KEY_SIZE = 1024;
    private boolean m_bad_config = false;
    private GrDPStorage m_storage = null;
    private int m_keySize;
    private static FileCertReader s_reader = null;

    public GliteDelegation() throws IOException {
        this(new GrDProxyDlgeeOptions(GrDPX509Util.getDlgeePropertyFile()));
    }

    public GliteDelegation(GrDProxyDlgeeOptions dlgeeOpt) {
        try {
            s_reader = new FileCertReader();
        }
        catch (CertificateException e3) {
            logger.error((Object)("Failed to initialize certificate reader: " + e3.getMessage()));
            throw new RuntimeException("Failed to initialize certificate reader: " + e3.getMessage());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using DLGEE properties: DN: " + dlgeeOpt.getDlgeeDN() + ". Pass: <hidden>. proxyFile: " + dlgeeOpt.getDlgeeProxyFile() + ". " + "delegationStorageFactory: " + dlgeeOpt.getDlgeeStorageFactory()));
        }
        try {
            GrDPStorageFactory stgFactory = GrDPX509Util.getGrDPStorageFactory(dlgeeOpt.getDlgeeStorageFactory());
            this.m_storage = stgFactory.createGrDPStorage(dlgeeOpt);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get a GrDPStorage instance. Delegation is not active.", (Throwable)e);
            this.m_bad_config = true;
            return;
        }
        this.m_keySize = dlgeeOpt.getDlgeeKeySize();
        if (this.m_keySize == -1 || this.m_keySize < this.DEFAULT_KEY_SIZE) {
            this.m_keySize = this.DEFAULT_KEY_SIZE;
        }
    }

    public String getProxyReq(String inDelegationID) throws DelegationException {
        logger.debug((Object)"Processing getProxyReq.");
        String delegationID = inDelegationID;
        GrDPStorageElement elem = null;
        InitSecurityContext.init();
        SecurityContext sc = SecurityContext.getCurrentContext();
        if (sc == null) {
            logger.debug((Object)"Failed to get SecurityContext.");
            throw new DelegationException("Failed to get client security information.");
        }
        if (this.m_bad_config) {
            logger.error((Object)"Service is misconfigured. Stopping execution.");
            throw new DelegationException("Service is misconfigured.");
        }
        DN clientDN = sc.getClientDN();
        if (clientDN == null) {
            logger.error((Object)"Failed to get client DN.");
            throw new DelegationException("Failed to get client DN.");
        }
        logger.debug((Object)("Got proxy delegation request from client '" + clientDN.getRFCDN() + "', getting VOMS attributes."));
        String[] vomsAttributes = GrDPX509Util.getVOMSAttributes(sc);
        logger.debug((Object)"Got VOMS attributes.");
        if (delegationID == null || delegationID.length() == 0) {
            delegationID = GrDPX509Util.genDlgID(clientDN.getRFCDN(), vomsAttributes);
        }
        logger.debug((Object)("Delegation id is: " + delegationID));
        try {
            elem = this.m_storage.findGrDPStorageElement(delegationID, clientDN.getRFCDN());
        }
        catch (GrDPStorageException e) {
            logger.error((Object)"Failure on storage interaction.", (Throwable)e);
            throw new DelegationException("Internal failure.");
        }
        if (elem != null) {
            String vomsAttrsStr = GrDPX509Util.toStringVOMSAttrs(vomsAttributes);
            logger.debug((Object)("Delegation ID '" + delegationID + "' already exists" + " for client (DN='" + clientDN.getRFCDN() + "; VOMS ATTRS='" + vomsAttrsStr + "'). Call renewProxyReq."));
            throw new DelegationException("Delegation ID '" + delegationID + "' already exists" + " for client (DN='" + clientDN.getRFCDN() + "; VOMS ATTRS='" + vomsAttrsStr + "'). Call renewProxyReq.");
        }
        return this.createAndStoreCertificateRequest(sc.getClientCert(), delegationID, clientDN, vomsAttributes);
    }

    public NewProxyReq getNewProxyReq(String inDelegationID) throws DelegationException {
        logger.debug((Object)"Processing getNewProxyReq.");
        String delegationID = inDelegationID;
        GrDPStorageElement elem = null;
        InitSecurityContext.init();
        SecurityContext sc = SecurityContext.getCurrentContext();
        if (sc == null) {
            logger.debug((Object)"Failed to get SecurityContext.");
            throw new DelegationException("Failed to get client security information.");
        }
        if (this.m_bad_config) {
            logger.error((Object)"Service is misconfigured. Stopping execution.");
            throw new DelegationException("Service is misconfigured.");
        }
        DN clientDN = sc.getClientDN();
        if (clientDN == null) {
            logger.error((Object)"Failed to get client DN.");
            throw new DelegationException("Failed to get client DN.");
        }
        logger.debug((Object)("Got proxy delegation request from client '" + clientDN + "'"));
        String[] vomsAttributes = GrDPX509Util.getVOMSAttributes(sc);
        if (delegationID == null || delegationID.length() == 0) {
            delegationID = GrDPX509Util.genDlgID(clientDN.getRFCDN(), vomsAttributes);
        }
        try {
            elem = this.m_storage.findGrDPStorageElement(delegationID, clientDN.getRFCDN());
        }
        catch (GrDPStorageException e) {
            logger.error((Object)"Failure on storage interaction.", (Throwable)e);
            throw new DelegationException("Internal failure.");
        }
        if (elem != null) {
            String vomsAttrsStr = GrDPX509Util.toStringVOMSAttrs(vomsAttributes);
            String errorMsg = "Delegation ID '" + delegationID + "' already exists" + " for client (DN='" + clientDN + "; VOMS ATTRS='" + vomsAttrsStr + "'). Call renewProxyReq.";
            logger.debug((Object)errorMsg);
            throw new DelegationException(errorMsg);
        }
        String certRequest = this.createAndStoreCertificateRequest(sc.getClientCert(), delegationID, clientDN, vomsAttributes);
        NewProxyReq newProxyReq = new NewProxyReq();
        newProxyReq.setDelegationID(delegationID);
        newProxyReq.setProxyRequest(certRequest);
        return newProxyReq;
    }

    public String renewProxyReq(String inDelegationID) throws DelegationException {
        logger.debug((Object)"Processing renewProxyReq.");
        String delegationID = inDelegationID;
        GrDPStorageElement elem = null;
        InitSecurityContext.init();
        SecurityContext sc = SecurityContext.getCurrentContext();
        if (sc == null) {
            logger.debug((Object)"Failed to get SecurityContext.");
            throw new DelegationException("Failed to get client security information.");
        }
        if (this.m_bad_config) {
            logger.error((Object)"Service is misconfigured. Stopping execution.");
            throw new DelegationException("Service is misconfigured.");
        }
        DN clientDN = sc.getClientDN();
        if (clientDN == null) {
            logger.error((Object)"Failed to get client DN.");
            throw new DelegationException("Failed to get client DN.");
        }
        logger.debug((Object)("Got proxy delegation request from client '" + clientDN + "'"));
        String[] vomsAttributes = GrDPX509Util.getVOMSAttributes(sc);
        if (delegationID == null || delegationID.length() == 0) {
            delegationID = GrDPX509Util.genDlgID(clientDN.getRFCDN(), vomsAttributes);
        }
        try {
            elem = this.m_storage.findGrDPStorageElement(delegationID, clientDN.getRFCDN());
        }
        catch (GrDPStorageException e) {
            logger.error((Object)"Failure on storage interaction.", (Throwable)e);
            throw new DelegationException("Internal failure.");
        }
        if (elem == null) {
            logger.debug((Object)("Failed to renew credential as there was no delegation with ID '" + delegationID + "' for client '" + clientDN + "'"));
        }
        return this.createAndStoreCertificateRequest(sc.getClientCert(), delegationID, clientDN, vomsAttributes);
    }

    public void putProxy(String inDelegationID, String proxy) throws DelegationException {
        PKCS10CertificationRequest req;
        X509Certificate[] proxyCertChain;
        logger.info((Object)"Processing putProxy.");
        String delegationID = inDelegationID;
        InitSecurityContext.init();
        SecurityContext sc = SecurityContext.getCurrentContext();
        if (sc == null) {
            logger.debug((Object)"Failed to get SecurityContext.");
            throw new DelegationException("Failed to get client security information.");
        }
        if (this.m_bad_config) {
            logger.error((Object)"Service is misconfigured. Stopping execution.");
            throw new DelegationException("Service is misconfigured.");
        }
        if (proxy == null) {
            logger.error((Object)"Failed to putProxy as proxy was null.");
            throw new DelegationException("No proxy was given.");
        }
        try {
            proxyCertChain = s_reader.readCertChain(new BufferedInputStream(new StringBufferInputStream(proxy))).toArray(new X509Certificate[0]);
        }
        catch (IOException e2) {
            logger.error((Object)("Failed to load proxy certificate chain: " + e2.getMessage()));
            throw new DelegationException("Failed to load proxy certificate chain: " + e2.getMessage());
        }
        if (proxyCertChain == null || proxyCertChain.length == 0) {
            logger.error((Object)"Failed to load proxy certificate chain - chain was null or size 0.");
            throw new DelegationException("Failed to load proxy certificate chain.");
        }
        logger.debug((Object)"Given proxy certificate loaded successfully.");
        for (int i = 0; i < proxyCertChain.length; ++i) {
            try {
                proxyCertChain[i].checkValidity();
                continue;
            }
            catch (CertificateExpiredException e) {
                throw new DelegationException("Failed proxy validation - it expired on: " + proxyCertChain[0].getNotAfter());
            }
            catch (CertificateNotYetValidException e) {
                throw new DelegationException("Failed proxy validation - it will be valid from: " + proxyCertChain[0].getNotBefore());
            }
        }
        String proxySubjectDN = DNHandler.getSubject((X509Certificate)proxyCertChain[0]).getRFCDN();
        String proxyIssuerDN = DNHandler.getIssuer((X509Certificate)proxyCertChain[0]).getRFCDN();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Proxy Subject DN: " + proxySubjectDN));
            logger.debug((Object)("Proxy Issuer DN: " + proxyIssuerDN));
            logger.debug((Object)("Proxy Public key:" + proxyCertChain[0].getPublicKey()));
            logger.debug((Object)("chain length is: " + proxyCertChain.length));
            logger.debug((Object)("last cert is:" + proxyCertChain[proxyCertChain.length - 1]));
            for (int n = 0; n < proxyCertChain.length; ++n) {
                logger.debug((Object)("cert [" + n + "] is from " + DNHandler.getSubject((X509Certificate)proxyCertChain[n]).getRFCDN()));
            }
        }
        if (proxySubjectDN == null || proxyIssuerDN == null) {
            logger.error((Object)"Failed to get DN (subject or issuer) out of proxy. It came null");
            throw new DelegationException("Failed to get DN (subject or issuer) out of proxy.");
        }
        String clientDN = null;
        try {
            clientDN = CertUtil.getUserDN((X509Certificate[])proxyCertChain).getRFCDN();
        }
        catch (IOException e) {
            throw new DelegationException("No user certificate found in the proxy chain: " + e.getMessage());
        }
        if (clientDN == null) {
            logger.error((Object)"Failed to get client DN. It came null");
            throw new DelegationException("Failed to get client DN.");
        }
        String[] clientVOMSAttributes = GrDPX509Util.getVOMSAttributes(sc);
        if (delegationID == null || delegationID.length() == 0) {
            delegationID = GrDPX509Util.genDlgID(clientDN, clientVOMSAttributes);
        }
        logger.debug((Object)("Delegation ID is '" + delegationID + "'"));
        if (!proxyIssuerDN.endsWith(clientDN)) {
            String message = "Client '" + clientDN + "' is not issuer of proxy '" + proxyIssuerDN + "'.";
            logger.error((Object)message);
            throw new DelegationException(message);
        }
        String cacheID = delegationID;
        try {
            cacheID = delegationID + '+' + GrDPX509Util.generateSessionID(proxyCertChain[0].getPublicKey());
        }
        catch (GeneralSecurityException e) {
            logger.error((Object)("Error while generating the session ID." + e));
            throw new DelegationException("Failed to generate the session ID.");
        }
        logger.debug((Object)("Cache ID (delegation ID + session ID): " + cacheID));
        GrDPStorageCacheElement cacheElem = null;
        try {
            cacheElem = this.m_storage.findGrDPStorageCacheElement(cacheID, clientDN);
        }
        catch (GrDPStorageException e) {
            logger.error((Object)"Failed to get certificate request information from storage.", (Throwable)e);
            throw new DelegationException("Internal failure.");
        }
        if (cacheElem == null) {
            logger.info((Object)("Could not find cache ID '" + cacheID + "' for DN '" + clientDN + "' in cache."));
            throw new DelegationException("Could not find a proper delegation request");
        }
        logger.debug((Object)("Got from cache element for cache ID '" + cacheID + "' and DN '" + clientDN + "'"));
        PEMReader pemReader = new PEMReader((Reader)new StringReader(cacheElem.getCertificateRequest()));
        try {
            req = (PKCS10CertificationRequest)pemReader.readObject();
        }
        catch (IOException e1) {
            logger.error((Object)"Could not load the original certificate request from cache.");
            throw new DelegationException("Could not load the original certificate request from cache: " + e1.getMessage());
        }
        if (req == null) {
            logger.error((Object)"Could not load the original certificate request from cache.");
            throw new DelegationException("Could not load the original certificate request from cache.");
        }
        try {
            if (!req.getPublicKey().equals(proxyCertChain[0].getPublicKey())) {
                logger.error((Object)"The proxy and the original request's public key do not match.");
                logger.error((Object)("Proxy public key: " + proxyCertChain[0].getPublicKey()));
                logger.error((Object)("Request public key: " + req.getPublicKey()));
                throw new DelegationException("The proxy and the original request's public key do not match.");
            }
        }
        catch (GeneralSecurityException ge) {
            logger.error((Object)("Error while decoding the certificate request: " + ge));
            throw new DelegationException("Error while decoding the certificate request.");
        }
        String completeProxy = this.getProxyWithPrivateKey(proxyCertChain, cacheElem.getPrivateKey());
        if (completeProxy == null) {
            logger.error((Object)"Failed to add private key to the proxy certificate chain.");
            throw new DelegationException("Could not properly process given proxy.");
        }
        try {
            GrDPStorageElement elem = this.m_storage.findGrDPStorageElement(delegationID, clientDN);
            if (elem != null) {
                elem.setCertificate(completeProxy);
                elem.setTerminationTime(proxyCertChain[0].getNotAfter());
                this.m_storage.updateGrDPStorageElement(elem);
            } else {
                elem = new GrDPStorageElement();
                elem.setDelegationID(delegationID);
                elem.setDN(clientDN);
                elem.setVomsAttributes(clientVOMSAttributes);
                elem.setCertificate(completeProxy);
                elem.setTerminationTime(proxyCertChain[0].getNotAfter());
                this.m_storage.insertGrDPStorageElement(elem);
            }
        }
        catch (GrDPStorageException e) {
            logger.error((Object)"Failed to put certificate request in storage.", (Throwable)e);
            throw new DelegationException("Internal failure: " + e.getMessage());
        }
        logger.debug((Object)"Delegation finished successfully.");
        try {
            this.m_storage.deleteGrDPStorageCacheElement(cacheID, clientDN);
        }
        catch (GrDPStorageException e) {
            logger.warn((Object)"Failed to remove credential from storage cache.");
        }
    }

    public void destroy(String inDelegationID) throws DelegationException {
        logger.debug((Object)"Processing destroy.");
        String delegationID = inDelegationID;
        GrDPStorageElement elem = null;
        if (this.m_bad_config) {
            logger.error((Object)"Service is misconfigured. Stopping execution.");
            throw new DelegationException("Service is misconfigured.");
        }
        InitSecurityContext.init();
        SecurityContext sc = SecurityContext.getCurrentContext();
        if (sc == null) {
            logger.debug((Object)"Failed to get SecurityContext.");
            throw new DelegationException("Failed to get client security information.");
        }
        String clientDN = null;
        try {
            clientDN = CertUtil.getUserDN((X509Certificate[])sc.getClientCertChain()).getRFCDN();
        }
        catch (IOException e) {
            throw new DelegationException("No user certificate found in the proxy chain: " + e.getMessage());
        }
        if (clientDN == null) {
            logger.error((Object)"Failed to get client DN. It came null");
            throw new DelegationException("Failed to get client DN.");
        }
        logger.debug((Object)("Got destroy request for delegation id '" + delegationID + "' from client '" + clientDN + "'"));
        String[] vomsAttributes = GrDPX509Util.getVOMSAttributes(sc);
        if (delegationID == null || delegationID.length() == 0) {
            delegationID = GrDPX509Util.genDlgID(clientDN, vomsAttributes);
        }
        try {
            elem = this.m_storage.findGrDPStorageElement(delegationID, clientDN);
        }
        catch (GrDPStorageException e) {
            logger.error((Object)"Failure on storage interaction. Exception: ", (Throwable)e);
            throw new DelegationException("Internal failure.");
        }
        if (elem == null) {
            logger.debug((Object)("Failed to find delegation ID '" + delegationID + "' for client '" + clientDN + "' in storage."));
            throw new DelegationException("Failed to find delegation ID '" + delegationID + "' in storage.");
        }
        try {
            this.m_storage.deleteGrDPStorageElement(delegationID, clientDN);
        }
        catch (GrDPStorageException e) {
            logger.error((Object)("Inconsistency needs manual intervention. Delegation ID '" + delegationID + " of client '" + clientDN + "' was found, " + "but could not be removed from storage."));
            throw new DelegationException("Failed to destroy delegated credential.");
        }
        logger.debug((Object)"Delegated credential destroyed.");
    }

    public Calendar getTerminationTime(String inDelegationID) throws DelegationException {
        logger.debug((Object)"Processing getTerminationTime.");
        String delegationID = inDelegationID;
        GrDPStorageElement elem = null;
        if (this.m_bad_config) {
            logger.error((Object)"Service is misconfigured. Stopping execution.");
            throw new DelegationException("Service is misconfigured.");
        }
        InitSecurityContext.init();
        SecurityContext sc = SecurityContext.getCurrentContext();
        if (sc == null) {
            logger.debug((Object)"Failed to get SecurityContext.");
            throw new DelegationException("Failed to get client security information.");
        }
        String clientDN = null;
        try {
            clientDN = CertUtil.getUserDN((X509Certificate[])sc.getClientCertChain()).getRFCDN();
        }
        catch (IOException e) {
            throw new DelegationException("No user certificate found in the proxy chain: " + e.getMessage());
        }
        if (clientDN == null) {
            logger.error((Object)"Failed to get client DN. It came null");
            throw new DelegationException("Failed to get client DN.");
        }
        logger.debug((Object)("Got getTerminationTime request for delegation id '" + delegationID + "' from client '" + clientDN + "'"));
        String[] vomsAttributes = GrDPX509Util.getVOMSAttributes(sc);
        if (delegationID == null || delegationID.length() == 0) {
            delegationID = GrDPX509Util.genDlgID(clientDN, vomsAttributes);
        }
        try {
            elem = this.m_storage.findGrDPStorageElement(delegationID, clientDN);
        }
        catch (GrDPStorageException e) {
            logger.error((Object)"Failure on storage interaction. Exception: ", (Throwable)e);
            throw new DelegationException("Internal failure.");
        }
        if (elem == null) {
            logger.debug((Object)("Failed to find delegation ID '" + delegationID + "' for client '" + clientDN + "' in storage."));
            throw new DelegationException("Failed to find delegation ID '" + delegationID + "' in storage.");
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(elem.getTerminationTime());
        return cal;
    }

    private String createAndStoreCertificateRequest(X509Certificate parentCert, String dlgID, DN clientDN, String[] vomsAttributes) throws DelegationException {
        KeyPair keyPair = GrDPX509Util.getKeyPair(this.m_keySize);
        String privateKey = PrivateKeyReader.getPEM((PrivateKey)keyPair.getPrivate());
        logger.debug((Object)"KeyPair generation was successfull.");
        logger.debug((Object)("Public key is: " + keyPair.getPublic()));
        String certRequest = null;
        try {
            certRequest = GrDPX509Util.createCertificateRequest(parentCert, "sha1WithRSAEncryption", keyPair);
        }
        catch (GeneralSecurityException e) {
            logger.error((Object)("Error while generating the certificate request." + e));
            throw new DelegationException("Failed to generate a certificate request.");
        }
        logger.debug((Object)"Certificate request generation was successfull.");
        String cacheID = null;
        try {
            cacheID = dlgID + '+' + GrDPX509Util.generateSessionID(keyPair.getPublic());
        }
        catch (GeneralSecurityException e) {
            logger.error((Object)("Error while generating the session ID." + e));
            throw new DelegationException("Failed to generate the session ID.");
        }
        logger.debug((Object)("Cache ID (delegation ID + session ID): " + cacheID));
        try {
            GrDPStorageCacheElement cacheElem = this.m_storage.findGrDPStorageCacheElement(cacheID, clientDN.getRFCDN());
            if (cacheElem != null) {
                cacheElem.setCertificateRequest(certRequest);
                cacheElem.setPrivateKey(privateKey);
                cacheElem.setVomsAttributes(vomsAttributes);
                this.m_storage.updateGrDPStorageCacheElement(cacheElem);
            } else {
                cacheElem = new GrDPStorageCacheElement();
                cacheElem.setDelegationID(cacheID);
                cacheElem.setDN(clientDN.getRFCDN());
                cacheElem.setVomsAttributes(vomsAttributes);
                cacheElem.setCertificateRequest(certRequest);
                cacheElem.setPrivateKey(privateKey);
                this.m_storage.insertGrDPStorageCacheElement(cacheElem);
            }
        }
        catch (GrDPStorageException e) {
            logger.error((Object)"Failed to put certificate request in storage.", (Throwable)e);
            throw new DelegationException("Internal failure.");
        }
        logger.debug((Object)"New certificate request successfully stored in cache.");
        return certRequest;
    }

    private String getProxyWithPrivateKey(X509Certificate[] proxyChain, String privateKey) {
        StringWriter writer = new StringWriter();
        PEMWriter pemWriter = new PEMWriter((Writer)writer);
        try {
            pemWriter.writeObject((Object)proxyChain[0]);
            pemWriter.flush();
            writer.write(privateKey);
            writer.flush();
            for (int i = 1; i < proxyChain.length; ++i) {
                pemWriter.writeObject((Object)proxyChain[i]);
            }
            pemWriter.flush();
        }
        catch (IOException e) {
            logger.error((Object)("Failed to encode certificate in proxy chain: " + e.getMessage()));
            return null;
        }
        return writer.toString();
    }
}

