/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.delegation.storage;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.glite.security.delegation.GrDPX509Util;
import org.glite.security.delegation.GrDProxyDlgeeOptions;
import org.glite.security.delegation.storage.GrDPStorage;
import org.glite.security.delegation.storage.GrDPStorageCacheElement;
import org.glite.security.delegation.storage.GrDPStorageElement;
import org.glite.security.delegation.storage.GrDPStorageException;
import org.glite.security.util.DNHandler;

public class GrDPStorageDatabase
implements GrDPStorage {
    private static Logger logger = Logger.getLogger(GrDPStorageDatabase.class);
    private final String m_default_db_pool = "jdbc/dlg";
    private final DataSource m_dataSource;

    public GrDPStorageDatabase(GrDProxyDlgeeOptions dlgeeOpt) throws GrDPStorageException {
        String dbPoolName = dlgeeOpt.getDlgeeStorageDbPool();
        if (dbPoolName == null) {
            dbPoolName = "jdbc/dlg";
        }
        try {
            InitialContext initCtx = new InitialContext();
            logger.debug((Object)"Fetched initial context");
            Context envCtx = (Context)initCtx.lookup("java:comp/env");
            logger.debug((Object)"Fetched environment context");
            logger.debug((Object)("Looking up JNDI datasource: " + dbPoolName));
            this.m_dataSource = (DataSource)envCtx.lookup(dbPoolName);
        }
        catch (NamingException ne) {
            logger.debug((Object)"Failed to load DB data source.", (Throwable)ne);
            throw new GrDPStorageException("Failed to load DB data source.");
        }
        this.checkSchemaVersion(1, 2, 0);
    }

    protected void checkSchemaVersion(int major, int minor, int patch) throws GrDPStorageException {
        logger.debug((Object)("Entered checkSchemaVersion " + major + "." + minor + "." + patch));
        String sql = "SELECT major, minor, patch FROM t_credential_vers";
        Connection conn = null;
        PreparedStatement p_stat = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            p_stat = conn.prepareStatement(sql);
            rs = p_stat.executeQuery();
            if (rs.next()) {
                if (major == rs.getInt(1) && minor == rs.getInt(2) && patch == rs.getInt(3)) {
                    logger.debug((Object)"Schema version is acceptable for the service.");
                    return;
                }
                throw new GrDPStorageException("DB schema version does not match the service.");
            }
        }
        catch (SQLException e) {
            logger.error((Object)"Failure on db interaction.", (Throwable)e);
            this.rollback(conn);
            throw new GrDPStorageException("Internal failure: " + e.getMessage());
        }
        finally {
            this.cleanup(conn);
            this.cleanup(p_stat);
            this.cleanup(rs);
        }
    }

    public void insertGrDPStorageCacheElement(GrDPStorageCacheElement elem) throws GrDPStorageException {
        logger.debug((Object)"Entered GrDPStorageDatabase insertGrDPStorageCacheElement.");
        String sql = "INSERT INTO t_credential_cache (dlg_id, dn, cert_request, priv_key, voms_attrs) VALUES (?, ?, ?, ?, ?)";
        Connection conn = null;
        PreparedStatement p_stat = null;
        try {
            conn = this.getConnection();
            p_stat = conn.prepareStatement(sql);
            p_stat.setString(1, elem.getDelegationID());
            p_stat.setString(2, elem.getDNasX500());
            p_stat.setString(3, elem.getCertificateRequest());
            p_stat.setString(4, elem.getPrivateKey());
            p_stat.setString(5, GrDPX509Util.toStringVOMSAttrs(elem.getVomsAttributes()));
            p_stat.executeUpdate();
            this.commit(conn);
        }
        catch (SQLException e) {
            logger.error((Object)"Failure on db interaction.", (Throwable)e);
            this.rollback(conn);
            throw new GrDPStorageException("Internal failure: " + e.getMessage());
        }
        finally {
            this.cleanup(conn);
            this.cleanup(p_stat);
        }
    }

    public void updateGrDPStorageCacheElement(GrDPStorageCacheElement elem) throws GrDPStorageException {
        logger.debug((Object)"Entered GrDPStorageDatabase updateGrDPStorageCacheElement.");
        String sql = "UPDATE t_credential_cache C SET cert_request = ?, priv_key = ?, voms_attrs = ? WHERE dlg_id = ? AND dn = ?";
        Connection conn = null;
        PreparedStatement p_stat = null;
        try {
            conn = this.getConnection();
            p_stat = conn.prepareStatement(sql);
            p_stat.setString(1, elem.getCertificateRequest());
            p_stat.setString(2, elem.getPrivateKey());
            p_stat.setString(3, GrDPX509Util.toStringVOMSAttrs(elem.getVomsAttributes()));
            p_stat.setString(4, elem.getDelegationID());
            p_stat.setString(5, elem.getDNasX500());
            p_stat.executeUpdate();
            this.commit(conn);
        }
        catch (SQLException e) {
            logger.error((Object)"Failure on db interaction.", (Throwable)e);
            this.rollback(conn);
            throw new GrDPStorageException("Internal failure: " + e.getMessage());
        }
        finally {
            this.cleanup(conn);
            this.cleanup(p_stat);
        }
    }

    public GrDPStorageCacheElement findGrDPStorageCacheElement(String delegationID, String dn) throws GrDPStorageException {
        logger.debug((Object)"Entered GrDPStorageDatabase findGrDPStorageCacheElement.");
        logger.debug((Object)("Looking for dlg id '" + delegationID + "' and dn '" + dn + "' in cache"));
        GrDPStorageCacheElement elem = null;
        String sql = "SELECT dlg_id, dn, voms_attrs, cert_request, priv_key FROM t_credential_cache WHERE dlg_id = ? AND dn = ?";
        Connection conn = null;
        PreparedStatement p_stat = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            p_stat = conn.prepareStatement(sql);
            p_stat.setString(1, delegationID);
            p_stat.setString(2, DNHandler.getDNRFC2253((String)dn).getX500());
            rs = p_stat.executeQuery();
            if (rs.next()) {
                elem = new GrDPStorageCacheElement();
                elem.setDelegationID(rs.getString("dlg_id"));
                elem.setDNasX500(rs.getString("dn"));
                elem.setCertificateRequest(rs.getString("cert_request"));
                elem.setVomsAttributes(GrDPX509Util.fromStringVOMSAttrs(rs.getString("voms_attrs")));
                elem.setPrivateKey(rs.getString("priv_key"));
            }
            this.cleanup(conn);
            this.cleanup(p_stat);
            this.cleanup(rs);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"Failure on db interaction.", (Throwable)e);
                this.rollback(conn);
                throw new GrDPStorageException("Internal failure: " + e.getMessage());
            }
            catch (Throwable throwable) {
                this.cleanup(conn);
                this.cleanup(p_stat);
                this.cleanup(rs);
                throw throwable;
            }
        }
        return elem;
    }

    public void deleteGrDPStorageCacheElement(String delegationID, String dn) throws GrDPStorageException {
        logger.debug((Object)"Entered GrDPStorageDatabase deleteGrDPStorageCacheElement.");
        String sql = "DELETE FROM t_credential_cache WHERE dlg_id = ? AND dn = ?";
        Connection conn = null;
        PreparedStatement p_stat = null;
        try {
            conn = this.getConnection();
            p_stat = conn.prepareStatement(sql);
            p_stat.setString(1, delegationID);
            p_stat.setString(2, DNHandler.getDNRFC2253((String)dn).getX500());
            p_stat.executeUpdate();
            this.commit(conn);
        }
        catch (SQLException e) {
            logger.error((Object)"Failure on db interaction.", (Throwable)e);
            this.rollback(conn);
            throw new GrDPStorageException("Internal failure: " + e.getMessage());
        }
        finally {
            this.cleanup(conn);
            this.cleanup(p_stat);
        }
    }

    public void insertGrDPStorageElement(GrDPStorageElement elem) throws GrDPStorageException {
        logger.debug((Object)"Entered GrDPStorageDatabase insertGrDPStorageElement.");
        String sql = "INSERT INTO t_credential (dlg_id, dn, proxy, voms_attrs, termination_time) VALUES (?, ?, ?, ?, ?)";
        Connection conn = null;
        PreparedStatement p_stat = null;
        try {
            conn = this.getConnection();
            p_stat = conn.prepareStatement(sql);
            p_stat.setString(1, elem.getDelegationID());
            p_stat.setString(2, elem.getDNasX500());
            p_stat.setString(3, elem.getCertificate());
            p_stat.setString(4, GrDPX509Util.toStringVOMSAttrs(elem.getVomsAttributes()));
            p_stat.setTimestamp(5, new Timestamp(elem.getTerminationTime().getTime()));
            p_stat.executeUpdate();
            this.commit(conn);
        }
        catch (SQLException e) {
            logger.error((Object)"Failure on db interaction.", (Throwable)e);
            this.rollback(conn);
            throw new GrDPStorageException("Internal failure: " + e.getMessage());
        }
        finally {
            this.cleanup(conn);
            this.cleanup(p_stat);
        }
    }

    public void updateGrDPStorageElement(GrDPStorageElement elem) throws GrDPStorageException {
        logger.debug((Object)"Entered GrDPStorageDatabase updateGrDPStorageElement.");
        String sql = "UPDATE t_credential C SET proxy = ?, voms_attrs = ?, termination_time = ? WHERE dlg_id = ? AND dn = ?";
        Connection conn = null;
        PreparedStatement p_stat = null;
        try {
            conn = this.getConnection();
            p_stat = conn.prepareStatement(sql);
            p_stat.setString(1, elem.getCertificate());
            p_stat.setString(2, GrDPX509Util.toStringVOMSAttrs(elem.getVomsAttributes()));
            p_stat.setTimestamp(3, new Timestamp(elem.getTerminationTime().getTime()));
            p_stat.setString(4, elem.getDelegationID());
            p_stat.setString(5, elem.getDNasX500());
            p_stat.executeUpdate();
            this.commit(conn);
        }
        catch (SQLException e) {
            logger.error((Object)"Failure on db interaction.", (Throwable)e);
            this.rollback(conn);
            throw new GrDPStorageException("Internal failure: " + e.getMessage());
        }
        finally {
            this.cleanup(conn);
            this.cleanup(p_stat);
        }
    }

    public GrDPStorageElement findGrDPStorageElement(String delegationID, String dn) throws GrDPStorageException {
        logger.debug((Object)"Entered GrDPStorageDatabase findGrDPStorageElement.");
        logger.debug((Object)("Looking for dlg id '" + delegationID + "' and dn '" + dn + "' in storage"));
        GrDPStorageElement elem = null;
        String sql = "SELECT dlg_id, dn, voms_attrs, proxy, termination_time FROM t_credential WHERE dlg_id = ? AND dn = ?";
        Connection conn = null;
        PreparedStatement p_stat = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            p_stat = conn.prepareStatement(sql);
            p_stat.setString(1, delegationID);
            p_stat.setString(2, DNHandler.getDNRFC2253((String)dn).getX500());
            rs = p_stat.executeQuery();
            if (rs.next()) {
                elem = new GrDPStorageElement();
                elem.setDelegationID(rs.getString("dlg_id"));
                elem.setDNasX500(rs.getString("dn"));
                elem.setCertificate(rs.getString("proxy"));
                elem.setVomsAttributes(GrDPX509Util.fromStringVOMSAttrs(rs.getString("voms_attrs")));
                elem.setTerminationTime(rs.getTimestamp("termination_time"));
            }
            this.cleanup(conn);
            this.cleanup(p_stat);
            this.cleanup(rs);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"Failure on db interaction.", (Throwable)e);
                this.rollback(conn);
                throw new GrDPStorageException("Internal failure: " + e.getMessage());
            }
            catch (Throwable throwable) {
                this.cleanup(conn);
                this.cleanup(p_stat);
                this.cleanup(rs);
                throw throwable;
            }
        }
        return elem;
    }

    public void deleteGrDPStorageElement(String delegationID, String dn) throws GrDPStorageException {
        logger.debug((Object)"Entered GrDPStorageDatabase deleteGrDPStorageElement.");
        String sql = "DELETE FROM t_credential WHERE dlg_id = ? AND dn = ?";
        Connection conn = null;
        PreparedStatement p_stat = null;
        try {
            conn = this.getConnection();
            p_stat = conn.prepareStatement(sql);
            p_stat.setString(1, delegationID);
            p_stat.setString(2, DNHandler.getDNRFC2253((String)dn).getX500());
            p_stat.executeUpdate();
            this.commit(conn);
        }
        catch (SQLException e) {
            logger.error((Object)"Failure on db interaction.", (Throwable)e);
            this.rollback(conn);
            throw new GrDPStorageException("Internal failure: " + e.getMessage());
        }
        finally {
            this.cleanup(conn);
            this.cleanup(p_stat);
        }
    }

    private Connection getConnection() throws SQLException {
        Connection conn = this.m_dataSource.getConnection();
        conn.setAutoCommit(false);
        return conn;
    }

    private void commit(Connection conn) throws SQLException {
        conn.commit();
    }

    private void rollback(Connection conn) {
        try {
            conn.rollback();
        }
        catch (SQLException e) {
            logger.error((Object)("Failed to rollback database transaction: " + e.getMessage()));
        }
    }

    private void cleanup(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Failed to close connection: " + e.getMessage()));
        }
    }

    private void cleanup(PreparedStatement stat) {
        try {
            if (stat != null) {
                stat.close();
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Failed to close statement: " + e.getMessage()));
        }
    }

    private void cleanup(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Failed to close result set: " + e.getMessage()));
        }
    }
}

