/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.GZipContentEncoding;
import org.glassfish.grizzly.http.HttpCodecFilter;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpPacketParsing;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.LZMAContentEncoding;
import org.glassfish.grizzly.http.ProcessingState;
import org.glassfish.grizzly.http.util.Ascii;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpCodecUtils;
import org.glassfish.grizzly.memory.MemoryManager;

public class HttpClientFilter
extends HttpCodecFilter {
    private final Attribute<Queue<HttpRequestPacket>> httpRequestQueueAttr;
    private final Attribute<ClientHttpResponseImpl> httpResponseInProcessAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("HttpClientFilter.httpResponse");

    public HttpClientFilter() {
        this(8192);
    }

    public HttpClientFilter(int maxHeadersSize) {
        super(true, maxHeadersSize);
        this.httpRequestQueueAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("HttpClientFilter.httpRequest");
        this.contentEncodings.add((Object)new GZipContentEncoding());
        this.contentEncodings.add((Object)new LZMAContentEncoding());
    }

    @Override
    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        HttpHeader header;
        Connection c = ctx.getConnection();
        Queue<HttpRequestPacket> requestQueue = this.getRequestQueue(c);
        Object message = ctx.getMessage();
        if ((requestQueue.isEmpty() || !requestQueue.contains(message)) && HttpHeader.isHttp(message) && (header = message instanceof HttpHeader ? (HttpHeader)message : ((HttpContent)message).getHttpHeader()).isRequest()) {
            requestQueue.offer((HttpRequestPacket)header);
        }
        return super.handleWrite(ctx);
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Buffer input = (Buffer)ctx.getMessage();
        Connection connection = ctx.getConnection();
        ClientHttpResponseImpl httpResponse = (ClientHttpResponseImpl)this.httpResponseInProcessAttr.get((AttributeStorage)connection);
        if (httpResponse == null) {
            httpResponse = ClientHttpResponseImpl.create();
            Queue<HttpRequestPacket> requestQueue = this.getRequestQueue(connection);
            httpResponse.setRequest(requestQueue.poll());
            httpResponse.initialize(this, input.position(), this.maxHeadersSize, -1);
            httpResponse.setSecure(HttpClientFilter.isSecure(connection));
            this.httpResponseInProcessAttr.set((AttributeStorage)connection, (Object)httpResponse);
        }
        return this.handleRead(ctx, httpResponse);
    }

    @Override
    protected boolean onHttpPacketParsed(HttpHeader httpHeader, FilterChainContext ctx) {
        Connection connection = ctx.getConnection();
        this.clearResponse(connection);
        return false;
    }

    @Override
    protected boolean onHttpHeaderParsed(HttpHeader httpHeader, Buffer buffer, FilterChainContext ctx) {
        ClientHttpResponseImpl response = (ClientHttpResponseImpl)httpHeader;
        HttpRequestPacket request = response.getRequest();
        int statusCode = response.getStatus();
        if (statusCode == 204 || statusCode == 205 || statusCode == 304 || request != null && request.isHeadRequest()) {
            response.setExpectContent(false);
        }
        return false;
    }

    @Override
    protected void onHttpHeaderError(HttpHeader httpHeader, FilterChainContext ctx, Throwable t) throws IOException {
        throw new IllegalStateException(t);
    }

    @Override
    protected void onHttpContentError(HttpHeader httpHeader, FilterChainContext ctx, Throwable t) throws IOException {
        httpHeader.setContentBroken(true);
        throw new IllegalStateException(t);
    }

    @Override
    protected void onInitialLineParsed(HttpHeader httpHeader, FilterChainContext ctx) {
    }

    @Override
    protected void onInitialLineEncoded(HttpHeader header, FilterChainContext ctx) {
    }

    @Override
    protected void onHttpHeadersParsed(HttpHeader httpHeader, FilterChainContext ctx) {
    }

    @Override
    protected void onHttpHeadersEncoded(HttpHeader httpHeader, FilterChainContext ctx) {
    }

    @Override
    protected void onHttpContentParsed(HttpContent content, FilterChainContext ctx) {
    }

    @Override
    protected void onHttpContentEncoded(HttpContent content, FilterChainContext ctx) {
    }

    protected final void clearResponse(Connection connection) {
        this.httpResponseInProcessAttr.remove((AttributeStorage)connection);
    }

    @Override
    protected Buffer encodeHttpPacket(FilterChainContext ctx, HttpPacket input) {
        HttpContent content;
        HttpHeader header;
        boolean isHeaderPacket = input.isHeader();
        if (isHeaderPacket) {
            header = (HttpHeader)input;
            content = null;
        } else {
            content = (HttpContent)input;
            header = content.getHttpHeader();
        }
        HttpRequestPacket request = (HttpRequestPacket)header;
        if (!request.isCommitted()) {
            this.prepareRequest(request);
        }
        return super.encodeHttpPacket(ctx, header, content, false);
    }

    @Override
    final boolean decodeInitialLineFromBytes(FilterChainContext ctx, HttpPacketParsing httpPacket, HttpCodecFilter.HeaderParsingState parsingState, byte[] input, int end) {
        HttpResponsePacket httpResponse = (HttpResponsePacket)((Object)httpPacket);
        int arrayOffs = parsingState.arrayOffset;
        int packetLimit = arrayOffs + parsingState.packetLimit;
        int subState = parsingState.subState++;
        switch (subState) {
            case 0: {
                int spaceIdx = HttpCodecUtils.findSpace(input, arrayOffs + parsingState.offset, end, packetLimit);
                if (spaceIdx == -1) {
                    parsingState.offset = end - arrayOffs;
                    return false;
                }
                httpResponse.getProtocolDC().setBytes(input, arrayOffs + parsingState.start, spaceIdx);
                parsingState.start = -1;
                parsingState.offset = spaceIdx - arrayOffs;
            }
            case 1: {
                int nonSpaceIdx = HttpCodecUtils.skipSpaces(input, arrayOffs + parsingState.offset, end, packetLimit) - arrayOffs;
                if (nonSpaceIdx < 0) {
                    parsingState.offset = end - arrayOffs;
                    return false;
                }
                parsingState.start = nonSpaceIdx;
                parsingState.offset = nonSpaceIdx + 1;
                ++parsingState.subState;
            }
            case 2: {
                if (parsingState.offset + 3 > end - arrayOffs) {
                    return false;
                }
                httpResponse.setStatus(Ascii.parseInt(input, arrayOffs + parsingState.start, 3));
                parsingState.start = -1;
                parsingState.offset += 3;
                ++parsingState.subState;
            }
            case 3: {
                int nonSpaceIdx = HttpCodecUtils.skipSpaces(input, arrayOffs + parsingState.offset, end, packetLimit) - arrayOffs;
                if (nonSpaceIdx < 0) {
                    parsingState.offset = end - arrayOffs;
                    return false;
                }
                parsingState.start = nonSpaceIdx;
                parsingState.offset = nonSpaceIdx;
                ++parsingState.subState;
            }
            case 4: {
                if (!HttpCodecUtils.findEOL(parsingState, input, end)) {
                    parsingState.offset = end - arrayOffs;
                    return false;
                }
                httpResponse.getReasonPhraseRawDC().setBytes(input, arrayOffs + parsingState.start, arrayOffs + parsingState.checkpoint);
                parsingState.subState = 0;
                parsingState.start = -1;
                parsingState.checkpoint = -1;
                this.onInitialLineParsed(httpResponse, ctx);
                if (httpResponse.getStatus() == 100) {
                    parsingState.offset += 2;
                    parsingState.start = parsingState.offset;
                    return false;
                }
                return true;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    final boolean decodeInitialLineFromBuffer(FilterChainContext ctx, HttpPacketParsing httpPacket, HttpCodecFilter.HeaderParsingState parsingState, Buffer input) {
        HttpResponsePacket httpResponse = (HttpResponsePacket)((Object)httpPacket);
        int packetLimit = parsingState.packetLimit;
        int subState = parsingState.subState++;
        switch (subState) {
            case 0: {
                int spaceIdx = HttpCodecUtils.findSpace(input, parsingState.offset, packetLimit);
                if (spaceIdx == -1) {
                    parsingState.offset = input.limit();
                    return false;
                }
                httpResponse.getProtocolDC().setBuffer(input, parsingState.start, spaceIdx);
                parsingState.start = -1;
                parsingState.offset = spaceIdx;
            }
            case 1: {
                int nonSpaceIdx = HttpCodecUtils.skipSpaces(input, parsingState.offset, packetLimit);
                if (nonSpaceIdx == -1) {
                    parsingState.offset = input.limit();
                    return false;
                }
                parsingState.start = nonSpaceIdx;
                parsingState.offset = nonSpaceIdx + 1;
                ++parsingState.subState;
            }
            case 2: {
                if (parsingState.offset + 3 > input.limit()) {
                    return false;
                }
                httpResponse.setStatus(Ascii.parseInt(input, parsingState.start, 3));
                parsingState.start = -1;
                parsingState.offset += 3;
                ++parsingState.subState;
            }
            case 3: {
                int nonSpaceIdx = HttpCodecUtils.skipSpaces(input, parsingState.offset, packetLimit);
                if (nonSpaceIdx == -1) {
                    parsingState.offset = input.limit();
                    return false;
                }
                parsingState.start = nonSpaceIdx;
                parsingState.offset = nonSpaceIdx;
                ++parsingState.subState;
            }
            case 4: {
                if (!HttpCodecUtils.findEOL(parsingState, input)) {
                    parsingState.offset = input.limit();
                    return false;
                }
                httpResponse.getReasonPhraseRawDC().setBuffer(input, parsingState.start, parsingState.checkpoint);
                parsingState.subState = 0;
                parsingState.start = -1;
                parsingState.checkpoint = -1;
                this.onInitialLineParsed(httpResponse, ctx);
                if (httpResponse.getStatus() == 100) {
                    parsingState.offset += 2;
                    parsingState.start = 0;
                    input.position(parsingState.offset);
                    input.shrink();
                    parsingState.offset = 0;
                    return false;
                }
                return true;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    Buffer encodeInitialLine(HttpPacket httpPacket, Buffer output, MemoryManager memoryManager) {
        HttpRequestPacket httpRequest = (HttpRequestPacket)httpPacket;
        byte[] tempEncodingBuffer = httpRequest.getTempHeaderEncodingBuffer();
        output = HttpCodecUtils.put(memoryManager, output, tempEncodingBuffer, httpRequest.getMethodDC());
        output = HttpCodecUtils.put(memoryManager, output, (byte)32);
        output = HttpCodecUtils.put(memoryManager, output, tempEncodingBuffer, httpRequest.getRequestURIRef().getRequestURIBC());
        if (!httpRequest.getQueryStringDC().isNull()) {
            output = HttpCodecUtils.put(memoryManager, output, (byte)63);
            output = HttpCodecUtils.put(memoryManager, output, tempEncodingBuffer, httpRequest.getQueryStringDC());
        }
        output = HttpCodecUtils.put(memoryManager, output, (byte)32);
        output = HttpCodecUtils.put(memoryManager, output, tempEncodingBuffer, httpRequest.getProtocolString());
        return output;
    }

    private void prepareRequest(HttpRequestPacket request) {
        String contentType = request.getContentType();
        if (contentType != null) {
            request.getHeaders().setValue(Header.ContentType).setString(contentType);
        }
    }

    private Queue<HttpRequestPacket> getRequestQueue(Connection c) {
        ConcurrentLinkedQueue q = (ConcurrentLinkedQueue)this.httpRequestQueueAttr.get((AttributeStorage)c);
        if (q == null) {
            q = new ConcurrentLinkedQueue();
            this.httpRequestQueueAttr.set((AttributeStorage)c, q);
        }
        return q;
    }

    private static final class ClientHttpResponseImpl
    extends HttpResponsePacket
    implements HttpPacketParsing {
        private static final ThreadCache.CachedTypeIndex<ClientHttpResponseImpl> CACHE_IDX = ThreadCache.obtainIndex(ClientHttpResponseImpl.class, (int)16);
        private boolean charEncodingParsed = false;
        private boolean contentTypeParsed;
        private boolean isHeaderParsed;
        private final HttpCodecFilter.HeaderParsingState headerParsingState = new HttpCodecFilter.HeaderParsingState();
        private final HttpCodecFilter.ContentParsingState contentParsingState = new HttpCodecFilter.ContentParsingState();

        public static ClientHttpResponseImpl create() {
            ClientHttpResponseImpl httpResponseImpl = (ClientHttpResponseImpl)ThreadCache.takeFromCache(CACHE_IDX);
            if (httpResponseImpl != null) {
                return httpResponseImpl;
            }
            return new ClientHttpResponseImpl();
        }

        private ClientHttpResponseImpl() {
        }

        public void initialize(HttpCodecFilter filter, int initialOffset, int maxHeaderSize, int maxNumberOfHeaders) {
            this.headerParsingState.initialize(filter, initialOffset, maxHeaderSize);
            this.headers.setMaxNumHeaders(maxNumberOfHeaders);
            this.contentParsingState.trailerHeaders.setMaxNumHeaders(maxNumberOfHeaders);
        }

        @Override
        public String getCharacterEncoding() {
            if (this.characterEncoding != null || this.charEncodingParsed) {
                return this.characterEncoding;
            }
            this.getContentType();
            this.charEncodingParsed = true;
            return this.characterEncoding;
        }

        @Override
        public String getContentType() {
            if (!this.contentTypeParsed) {
                DataChunk dc;
                this.contentTypeParsed = true;
                if (this.contentType == null && (dc = this.headers.getValue(Header.ContentType)) != null && !dc.isNull()) {
                    this.setContentType(dc.toString());
                }
            }
            return super.getContentType();
        }

        @Override
        public HttpCodecFilter.HeaderParsingState getHeaderParsingState() {
            return this.headerParsingState;
        }

        @Override
        public HttpCodecFilter.ContentParsingState getContentParsingState() {
            return this.contentParsingState;
        }

        @Override
        public ProcessingState getProcessingState() {
            return this.getRequest().getProcessingState();
        }

        @Override
        public boolean isHeaderParsed() {
            return this.isHeaderParsed;
        }

        @Override
        public void setHeaderParsed(boolean isHeaderParsed) {
            this.isHeaderParsed = isHeaderParsed;
        }

        @Override
        protected void reset() {
            this.charEncodingParsed = false;
            this.contentTypeParsed = false;
            this.isHeaderParsed = false;
            this.headerParsingState.recycle();
            this.contentParsingState.recycle();
            super.reset();
        }

        @Override
        public void recycle() {
            if (this.getRequest().isExpectContent()) {
                return;
            }
            this.reset();
            ThreadCache.putToCache(CACHE_IDX, (Object)this);
        }
    }
}

