/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.SelectorFilter;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.handlers.RefCompare;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class QBrowseHandler
extends PacketHandler {
    private Logger logger = Globals.getLogger();
    private static boolean DEBUG = false;
    private DestinationList DL = Globals.getDestinationList();

    public ArrayList getQBrowseList(Destination d, String selectorstr) throws BrokerException, SelectorFormatException {
        Collection msgs = null;
        if (selectorstr == null) {
            msgs = d.getAll(null).values();
        } else {
            SelectorFilter f = new SelectorFilter(selectorstr);
            Map m = d.getAll(f);
            msgs = m.values();
        }
        ArrayList sorted = new ArrayList(msgs);
        Collections.sort(sorted, new RefCompare());
        TransactionList[] tls = DestinationList.getTransactionList(d.getPartitionedStore());
        TransactionList tlist = tls[0];
        Iterator itr = sorted.iterator();
        while (itr.hasNext()) {
            TransactionState ts;
            PacketReference p = (PacketReference)itr.next();
            if (p.isExpired()) {
                itr.remove();
            }
            if (!p.isDeliveryDue()) {
                itr.remove();
            }
            if (p.getTransactionID() != null && (ts = tlist.retrieveState(p.getTransactionID())) != null && ts.getState() != 6) {
                itr.remove();
            }
            if (p.checkLock(false) != null) continue;
            itr.remove();
        }
        ArrayList<SysMessageID> returnmsgs = new ArrayList<SysMessageID>();
        for (PacketReference p : sorted) {
            if (p == null) continue;
            returnmsgs.add(p.getSysMessageID());
        }
        return returnmsgs;
    }

    @Override
    public boolean handle(IMQConnection con, Packet msg) throws BrokerException {
        int type;
        byte[] body;
        Hashtable<String, Object> hash;
        Packet pkt;
        int status;
        block24: {
            block23: {
                String reason;
                block22: {
                    status = 200;
                    reason = null;
                    pkt = new Packet(con.useDirectBuffers());
                    pkt.setConsumerID(msg.getConsumerID());
                    pkt.setPacketType(27);
                    hash = new Hashtable<String, Object>();
                    ConsumerUID uid = new ConsumerUID();
                    hash.put("JMQConsumerID", uid.longValue());
                    Hashtable props = null;
                    body = null;
                    String destination = null;
                    String selectorstr = null;
                    type = 0;
                    try {
                        props = msg.getProperties();
                        destination = (String)props.get("JMQDestination");
                        type = 1;
                        selectorstr = (String)props.get("JMQSelector");
                        if (selectorstr != null && selectorstr.trim().length() == 0) {
                            selectorstr = null;
                        }
                        if (DEBUG) {
                            this.logger.log(4, "QBrowse request: destination =  " + destination + "  selector = " + selectorstr);
                        }
                        Destination[] ds = DestinationList.getDestination(con.getPartitionedStore(), destination, DestType.isQueue(type));
                        Destination d = ds[0];
                        Boolean getMetrics = (Boolean)props.get("JMQMetrics");
                        if (d == null) {
                            status = 404;
                            reason = "Destination " + destination + " not found";
                            this.logger.log(16, "B2080", destination == null ? "unknown" : destination);
                            break block22;
                        }
                        if (getMetrics != null && getMetrics.equals(Boolean.TRUE)) {
                            this.logger.log(8, "Getting destination metrics on " + d);
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            try {
                                ObjectOutputStream oos = new ObjectOutputStream(bos);
                                oos.writeObject(d.getMetrics());
                                oos.close();
                                body = bos.toByteArray();
                            }
                            catch (Exception e) {
                                this.logger.log(32, "B3100", this.getClass().getName() + " : Got exception writing metrics to browse reply message:\n" + e);
                            }
                            hash.put("JMQMetrics", getMetrics);
                            break block22;
                        }
                        this.logger.log(4, "QueueBrowser created: destination =  " + destination + "  selector = " + selectorstr);
                        ArrayList returnmsgs = this.getQBrowseList(d, selectorstr);
                        if (DEBUG) {
                            this.logger.log(4, "QBrowse request: current queue size is " + returnmsgs.size());
                        }
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        for (int i = 0; i < returnmsgs.size(); ++i) {
                            SysMessageID id = (SysMessageID)returnmsgs.get(i);
                            if (DEBUG) {
                                this.logger.log(4, "\t[" + i + "] id = " + id);
                            }
                            id.writeID(new DataOutputStream(bos));
                        }
                        bos.flush();
                        body = bos.toByteArray();
                        bos.close();
                    }
                    catch (IOException ex) {
                        this.logger.logStack(32, "B3100", "Unable to verify destination - no properties", (Throwable)ex);
                        reason = ex.getMessage();
                        status = 500;
                    }
                    catch (ClassNotFoundException ex) {
                        this.logger.logStack(32, "B3100", "Unable to verify destination -bad class", (Throwable)ex);
                        reason = ex.getMessage();
                        status = 500;
                    }
                    catch (SelectorFormatException ex) {
                        reason = ex.getMessage();
                        status = 400;
                        this.logger.log(16, "B2016", selectorstr, (Throwable)ex);
                    }
                    catch (BrokerException ex) {
                        reason = ex.getMessage();
                        status = ex.getStatusCode();
                        this.logger.logStack(16, "B2015", destination == null ? "unknown" : destination, (Throwable)ex);
                    }
                    catch (SecurityException ex) {
                        reason = ex.getMessage();
                        status = 403;
                        this.logger.logStack(4, "B3100", " access to destination " + destination + " is forbidden ", (Throwable)ex);
                        reason = ex.getMessage();
                    }
                }
                hash.put("JMQStatus", status);
                if (reason != null) {
                    hash.put("JMQReason", reason);
                }
                IMQBasicConnection cfr_ignored_0 = (IMQBasicConnection)con;
                if (IMQBasicConnection.getDumpPacket()) break block23;
                IMQBasicConnection cfr_ignored_1 = (IMQBasicConnection)con;
                if (!IMQBasicConnection.getDumpOutPacket()) break block24;
            }
            hash.put("JMQReqID", msg.getSysMessageID().toString());
        }
        if (status == 404) {
            hash.put("JMQCanCreate", DestinationList.canAutoCreate(DestType.isQueue(type)));
        }
        pkt.setProperties(hash);
        if (body != null) {
            pkt.setMessageBody(body);
        }
        con.sendControlMessage(pkt);
        return true;
    }
}

