/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.AccessController;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.net.Protocol;
import com.sun.messaging.jmq.jmsserver.net.ProtocolCallback;
import com.sun.messaging.jmq.jmsserver.net.ProtocolStreams;
import com.sun.messaging.jmq.jmsserver.pool.RunnableFactory;
import com.sun.messaging.jmq.jmsserver.pool.ThreadPool;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQIPConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.MQThread;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;

public abstract class IMQIPService
extends IMQService
implements Runnable,
ProtocolCallback {
    private static boolean DEBUG = false;
    private static boolean WORKAROUND_4244135 = false;
    private boolean WORKAROUND_HTTP = false;
    private ConnectionManager connectionList = Globals.getConnectionManager();
    protected PacketRouter router = null;
    protected ThreadPool pool = null;
    protected RunnableFactory runfac = null;
    protected Protocol protocol = null;
    protected Thread listenThread = null;

    public IMQIPService(String name, Protocol protocol, int type, PacketRouter router, int min, int max) {
        super(name, type);
        this.protocol = protocol;
        this.router = router;
        this.runfac = this.getRunnableFactory();
        if (!protocol.canPause()) {
            this.WORKAROUND_HTTP = true;
        }
        if (max == 0) {
            throw new RuntimeException(Globals.getBrokerResources().getKString("B4136", name, String.valueOf(max)));
        }
        this.pool = new ThreadPool(name, min, max, this.runfac);
        if (protocol.getHostName() != null && !protocol.getHostName().equals("*")) {
            this.addServiceProp("hostname", protocol.getHostName());
        }
        protocol.registerProtocolCallback(this, null);
    }

    @Override
    public Hashtable getPoolDebugState() {
        return this.pool.getDebugState();
    }

    public void dumpPool() {
        this.pool.debug();
    }

    protected abstract RunnableFactory getRunnableFactory();

    @Override
    public Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public synchronized int getMinThreadpool() {
        if (this.pool == null) {
            return 0;
        }
        return this.pool.getMinimum();
    }

    @Override
    public synchronized int getMaxThreadpool() {
        if (this.pool == null) {
            return 0;
        }
        return this.pool.getMaximum();
    }

    @Override
    public synchronized int getActiveThreadpool() {
        if (this.pool == null) {
            return 0;
        }
        return this.pool.getThreadNum();
    }

    @Override
    public void setPriority(int priority) {
        this.pool.setPriority(priority);
    }

    @Override
    public synchronized int[] setMinMaxThreadpool(int min, int max) {
        if (this.pool == null) {
            return null;
        }
        return this.pool.setMinMax(min, max);
    }

    @Override
    public synchronized void startService(boolean startPaused) {
        if (this.isServiceRunning() || this.listenThread != null) {
            this.logger.log(4, "B3100", "unable to start service, already started.");
            return;
        }
        this.setState(2);
        Object[] args = new String[]{this.getName(), this.protocol.toString(), String.valueOf(this.getMinThreadpool()), String.valueOf(this.getMaxThreadpool())};
        this.logger.log(8, "B1004", args);
        try {
            this.logger.log(8, "B1227", (Object)AccessController.getInstance(this.getName(), this.getServiceType()).getUserRepository(), this.getName());
        }
        catch (BrokerException e) {
            this.logger.log(16, "B2135", (Object)this.getName(), e.getMessage());
        }
        this.listenThread = new MQThread(this, this.getName() + "_ACCEPT");
        this.listenThread.start();
        this.pool.start();
        if (startPaused) {
            this.setServiceRunning(false);
            this.setState(4);
            if (!this.WORKAROUND_HTTP) {
                try {
                    this.protocol.close();
                    Globals.getPortMapper().updateServicePort(this.name, 0);
                }
                catch (Exception ex) {
                    this.logger.logStack(16, "B3100", "starting paused service " + this, (Throwable)ex);
                }
            }
        } else {
            this.setServiceRunning(true);
            this.setState(3);
        }
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopService(boolean all) {
        int i;
        Connection con;
        Object cons;
        IMQIPService iMQIPService = this;
        synchronized (iMQIPService) {
            if (this.isShuttingDown()) {
                return;
            }
            Object[] strings = new String[]{this.getName(), this.protocol.toString()};
            if (all) {
                this.logger.log(8, "B1007", strings);
            } else if (!this.isShuttingDown()) {
                this.logger.log(8, "B1053", strings);
            }
            this.setShuttingDown(true);
        }
        try {
            this.protocol.close();
        }
        catch (Exception ex) {
            this.logger.log(4, "Exception shutting down  protocol, ignoring since we are exiting", ex);
        }
        if (this.getServiceType() == 0) {
            cons = this.connectionList.getConnectionList(this);
            con = null;
            for (i = cons.size() - 1; i >= 0; --i) {
                con = (Connection)cons.get(i);
                con.stopConnection();
            }
        }
        cons = this;
        synchronized (cons) {
            this.setState(5);
            this.notifyAll();
        }
        if (!all) {
            return;
        }
        if (this.getServiceType() == 0) {
            cons = this.connectionList.getConnectionList(this);
            con = null;
            for (i = cons.size() - 1; i >= 0; --i) {
                con = (Connection)cons.get(i);
                con.destroyConnection(true, 1, Globals.getBrokerResources().getKString("B0060"));
            }
        }
        iMQIPService = this;
        synchronized (iMQIPService) {
            this.setState(6);
            this.notifyAll();
        }
        if (this.pool.isValid()) {
            this.pool.waitOnDestroy(this.getDestroyWaitTime());
        }
        if (DEBUG) {
            this.logger.log(4, "Destroying Service {0} with protocol {1} ", (Object)this.getName(), this.protocol.toString());
        }
    }

    @Override
    public void stopNewConnections() throws IOException, IllegalStateException {
        if (this.getState() != 3) {
            throw new IllegalStateException(Globals.getBrokerResources().getKString("B4254"));
        }
        this.setState(8);
        if (!WORKAROUND_4244135 && !this.WORKAROUND_HTTP) {
            if (this.protocol != null && this.protocol.isOpen()) {
                this.protocol.close();
            }
            Globals.getPortMapper().updateServicePort(this.name, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startNewConnections() throws IOException {
        if (this.getState() != 8 && this.getState() != 4) {
            throw new IllegalStateException(Globals.getBrokerResources().getKString("B4255"));
        }
        if (!WORKAROUND_4244135 && !this.WORKAROUND_HTTP) {
            try {
                this.protocol.open();
            }
            catch (Exception ex) {
                this.logger.logStack(16, "B3100", "starting connections" + this, (Throwable)ex);
            }
        }
        IMQIPService iMQIPService = this;
        synchronized (iMQIPService) {
            this.setState(3);
            this.notifyAll();
        }
    }

    @Override
    public void pauseService(boolean all) {
        if (!this.isServiceRunning()) {
            this.logger.log(4, "B3100", "unable to pause service " + this.name + ", already paused.");
            return;
        }
        Object[] strings = new String[]{this.getName(), this.protocol.toString()};
        this.logger.log(4, "B1005", strings);
        try {
            this.stopNewConnections();
        }
        catch (Exception ex) {
            this.logger.logStack(16, "B3100", "pausing service " + this, (Throwable)ex);
        }
        this.setState(4);
        if (all) {
            this.pool.suspend();
        }
        this.setServiceRunning(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeService() {
        if (this.isServiceRunning()) {
            this.logger.log(4, "B3100", "unable to resume service " + this.name + ", already running.");
            return;
        }
        Object[] strings = new String[]{this.getName(), this.protocol.toString()};
        this.logger.log(4, "B1006", strings);
        try {
            this.startNewConnections();
        }
        catch (Exception ex) {
            this.logger.logStack(16, "B3100", "pausing service " + this, (Throwable)ex);
        }
        this.pool.resume();
        this.setServiceRunning(true);
        IMQIPService iMQIPService = this;
        synchronized (iMQIPService) {
            this.setState(3);
            this.notifyAll();
        }
    }

    @Override
    public void updateService(int port, int min, int max) throws IOException, PropertyUpdateException, BrokerException {
        String name = this.getName();
        String protoname = Globals.getConfig().getProperty("imq." + name + ".protocoltype");
        Protocol p = this.getProtocol();
        Object[] args = new String[]{name, String.valueOf(port), String.valueOf(min), String.valueOf(max)};
        this.logger.log(8, "B1090", args);
        if (port > -1) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("port", String.valueOf(port));
            p.checkParameters(params);
            if (!WORKAROUND_4244135) {
                p.setParameters(params);
                Globals.getPortMapper().removeService(name);
                Globals.getPortMapper().addService(name, protoname, Globals.getConfig().getProperty("imq." + name + ".servicetype"), p.getLocalPort(), this.getServiceProperties());
            }
            Globals.getConfig().updateProperty("imq." + name + "." + protoname + ".port", String.valueOf(port));
        }
        if (min > -1 || max > -1) {
            try {
                if (max == 0) {
                    throw new BrokerException(Globals.getBrokerResources().getKString("B4136", name, String.valueOf(max)));
                }
                int[] rets = this.setMinMaxThreadpool(min, max);
                if (rets != null) {
                    if (rets[0] > -1) {
                        Globals.getConfig().updateProperty("imq." + name + ".min_threads", String.valueOf(rets[0]));
                    }
                    if (rets[1] > -1) {
                        Globals.getConfig().updateProperty("imq." + name + ".max_threads", String.valueOf(rets[1]));
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4115", String.valueOf(min), String.valueOf(max)), e);
            }
        }
        if (port > -1 && WORKAROUND_4244135) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B3109"));
        }
    }

    @Override
    public synchronized void socketUpdated(Object data, int port, String hostname) {
        if (port == -1) {
            port = this.protocol.getLocalPort();
        }
        Object[] args = new String[]{this.name, String.valueOf(port), hostname == null ? "*" : hostname};
        this.logger.log(4, "B1091", args);
        Globals.getPortMapper().updateServicePort(this.name, port);
        if (hostname != null) {
            this.addServiceProp("hostname", hostname);
            Globals.getPortMapper().updateServiceProperties(this.name, this.getServiceProperties());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (DEBUG) {
            this.logger.log(2, "Starting thread to listen for connections on {0} with protocol {1}", (Object)this.getName(), this.protocol.toString());
        }
        while (true) {
            ProtocolStreams ps = null;
            if (!this.isShuttingDown() && !this.isServiceRunning()) {
                IMQIPService iMQIPService = this;
                synchronized (iMQIPService) {
                    while (!(this.isShuttingDown() || this.isServiceRunning() || WORKAROUND_4244135 && this.getState() == 4 || this.WORKAROUND_HTTP && this.getState() == 4)) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ex2) {}
                    }
                }
            }
            if (this.isShuttingDown()) break;
            try {
                IMQIPConnection con;
                try {
                    ps = this.protocol.accept();
                }
                catch (Exception ex) {
                    if (this.getState() == 4 || this.getState() == 8) {
                        IMQIPService ex2 = this;
                        synchronized (ex2) {
                            if (this.getState() == 4 || this.getState() == 8) {
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException ex1) {
                                    // empty catch block
                                }
                            }
                            continue;
                        }
                    }
                    if (this.isShuttingDown()) break;
                    this.logger.log(4, "Exception accepting connection " + this.protocol + " expected", ex);
                    ps = this.protocol.accept();
                }
                if ((WORKAROUND_4244135 || this.WORKAROUND_HTTP) && this.getState() == 4) {
                    IMQIPService ex = this;
                    synchronized (ex) {
                        if (this.getState() == 4) {
                            try {
                                ps.close();
                            }
                            catch (IOException e) {
                                this.logger.log(4, "Exception closing down " + this.protocol, e);
                            }
                            continue;
                        }
                    }
                }
                if (DEBUG) {
                    Object[] strings = new String[]{this.getName(), this.protocol.toString(), ps.toString()};
                    this.logger.log(1, "Accepted new connection for Service( {0},{1}, {2})", strings);
                }
                if ((con = this.createConnection(ps)) == null) {
                    this.logger.log(16, "B3100", "null connection " + ps);
                    continue;
                }
                try {
                    IMQIPService e = this;
                    synchronized (e) {
                        if (this.isShuttingDown()) {
                            if (DEBUG) {
                                Object[] strings = new String[]{this.getName(), this.protocol.toString(), ps.toString()};
                                this.logger.log(1, "Remove new connection for Service( {0},{1}, {2}) is in shutting down", strings);
                            }
                            con.setConnectionState(-1);
                            ps.close();
                            this.setServiceRunning(false);
                            return;
                        }
                        this.connectionList.addConnection(con);
                    }
                }
                catch (BrokerException ex) {
                    con.setConnectionState(-1);
                    this.logger.log(16, ex.getMessage());
                }
                try {
                    this.acceptConnection(con);
                }
                catch (Throwable ex) {
                    this.connectionList.removeConnection(con.getConnectionUID(), true, 4, ex.toString());
                    if (!this.isShuttingDown()) {
                        int level = 32;
                        if (ex instanceof BrokerException && ((BrokerException)ex).getStatusCode() == 405) {
                            level = 4;
                        }
                        this.logger.logStack(level, "B3100", "Unable to allocate connection" + con.toString() + " on service " + this.name + ", closing", ex);
                    }
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Exception ex1) {
                            // empty catch block
                        }
                    }
                    this.logger.log(4, "Exception closing " + this.protocol, ex);
                }
            }
            catch (IOException ex) {
                if (!this.isShuttingDown() && this.getState() != 8) {
                    this.logger.logStack(32, "B3018", this.name, (Throwable)ex);
                }
                this.logger.log(4, "Exception closing " + this.protocol, ex);
                break;
            }
            catch (Throwable ex) {
                if (!this.isShuttingDown()) {
                    this.logger.logStack(32, "B3018", this.name, ex);
                }
                this.logger.log(4, "Exception closing " + this.protocol, ex);
                if (ps == null) break;
                try {
                    ps.close();
                }
                catch (Exception exception) {}
                break;
            }
        }
        this.setServiceRunning(false);
    }

    public IMQIPConnection createConnection(ProtocolStreams streams) throws IOException, BrokerException {
        IMQIPConnection con = new IMQIPConnection(this, streams, this.router);
        return con;
    }

    protected abstract void acceptConnection(IMQIPConnection var1) throws IOException, BrokerException;

    static {
        Properties cfg = System.getProperties();
        BrokerConfig cprops = Globals.getConfig();
        try {
            WORKAROUND_4244135 = cprops.getProperty("imq.workaround_4244135") != null ? cprops.getBooleanProperty("imq.workaround_4244135") : cfg.getProperty("os.name").startsWith("Linux") && cfg.getProperty("java.vm.name").indexOf("HotSpot") > -1 && cfg.getProperty("java.version").startsWith("1.3");
        }
        catch (Throwable thr) {
            Globals.getLogger().log(32, thr.toString(), thr);
        }
        finally {
            if (WORKAROUND_4244135) {
                Globals.getLogger().log(4, "Using workaround for bug 4244135");
            }
        }
    }
}

