/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.portunif;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.service.portunif.PortMapperServiceFilter;
import com.sun.messaging.portunif.PUService;
import com.sun.messaging.portunif.PUServiceCallback;
import com.sun.messaging.portunif.PortMapperProtocolFinder;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Properties;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.portunif.PUProtocol;
import org.glassfish.grizzly.portunif.ProtocolFinder;

public class PortMapperMessageFilter
extends BaseFilter {
    protected static boolean DEBUG = false;

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Buffer input = (Buffer)ctx.getMessage();
        String data = input.toStringContent(Charset.forName("UTF-8"));
        if (DEBUG) {
            Globals.getLogger().log(8, "PortMapperMessageFilter.handleRead called with data=" + data + " from connection " + ctx.getConnection());
        }
        input.tryDispose();
        return ctx.getInvokeAction();
    }

    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        Buffer output = (Buffer)ctx.getMessage();
        output.flip();
        if (DEBUG) {
            Globals.getLogger().log(8, "PortMapperMessageFilter.handleWrite called with data size " + output.remaining() + " for connection " + ctx.getConnection());
        }
        ctx.setMessage((Object)output);
        return ctx.getInvokeAction();
    }

    public static PUProtocol configurePortMapperProtocol(PUService pu, PUServiceCallback cb) throws IOException {
        FilterChain pmProtocolFilterChain = pu.getPUFilterChainBuilder().add((Filter)new PortMapperMessageFilter()).add((Filter)new PortMapperServiceFilter(false)).build();
        return new PUProtocol((ProtocolFinder)new PortMapperProtocolFinder(cb, false), pmProtocolFilterChain);
    }

    public static PUProtocol configurePortMapperSSLProtocol(PUService pu, PUServiceCallback cb, Properties sslprops, boolean clientAuthRequired) throws IOException {
        if (!pu.initializeSSL(sslprops, clientAuthRequired, cb, Globals.getPoodleFixEnabled(), Globals.getKnownSSLEnabledProtocols("PortMapper"))) {
            throw new IOException("Unexpected: Someone initialized SSL PUService before PortMapper service");
        }
        FilterChain pmSSLProtocolFilterChain = pu.getSSLPUFilterChainBuilder().add((Filter)new PortMapperMessageFilter()).add((Filter)new PortMapperServiceFilter(true)).build();
        return new PUProtocol((ProtocolFinder)new PortMapperProtocolFinder(cb, true), pmSSLProtocolFilterChain);
    }
}

