/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.objstore.ObjStoreAttrs;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.admin.util.UserProperties;
import com.sun.messaging.jmq.admin.util.UserPropertiesException;
import java.util.Enumeration;

public class ObjStoreListProperties
extends UserProperties {
    public static final String FIRST_VERSION = "2.0";
    public static final String VERSION = "2.0";
    private static final String PROP_NAME_VERSION = "version";
    private static final String PROP_NAME_OBJSTORE_BASENAME = "objstore";
    private static final String PROP_NAME_OBJSTORE_COUNT = "objstore.count";
    private static final String PROP_NAME_OBJSTORE_ID_PREFIX = "id";
    private static final String PROP_NAME_OBJSTORE_DESC_PREFIX = "desc";
    private static final String PROP_NAME_OBJSTORE_ATTR_PREFIX = "attrs";
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();

    public ObjStoreListProperties() {
        this.setProperty(PROP_NAME_VERSION, "2.0");
    }

    public String getVersion() {
        String val = this.getProperty(PROP_NAME_VERSION);
        return val;
    }

    public int getObjStoreCount() {
        int ret;
        String val = this.getProperty(PROP_NAME_OBJSTORE_COUNT);
        if (val == null || val.equals("")) {
            return 0;
        }
        try {
            ret = Integer.parseInt(val);
        }
        catch (Exception e) {
            ret = 0;
        }
        return ret;
    }

    public ObjStoreAttrs[] getObjStoreAttrs() {
        int count = this.getObjStoreCount();
        if (count <= 0) {
            return null;
        }
        ObjStoreAttrs[] objStoreArray = new ObjStoreAttrs[count];
        for (int i = 0; i < count; ++i) {
            objStoreArray[i] = this.getObjStoreAttrs(i);
        }
        return objStoreArray;
    }

    public ObjStoreAttrs getObjStoreAttrs(int index) {
        String basePropName = PROP_NAME_OBJSTORE_BASENAME + Integer.toString(index) + ".";
        String idPropName = basePropName + PROP_NAME_OBJSTORE_ID_PREFIX;
        String id = this.getProperty(idPropName, "");
        String descPropName = basePropName + PROP_NAME_OBJSTORE_DESC_PREFIX;
        String desc = this.getProperty(descPropName, "");
        ObjStoreAttrs osa = new ObjStoreAttrs(id, desc);
        String objstoreAttrsStr = PROP_NAME_OBJSTORE_BASENAME + Integer.toString(index) + "." + PROP_NAME_OBJSTORE_ATTR_PREFIX + ".";
        int objstoreAttrsStrLen = objstoreAttrsStr.length();
        Enumeration<?> e = this.propertyNames();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            if (!propName.startsWith(objstoreAttrsStr)) continue;
            String newPropName = propName.substring(objstoreAttrsStrLen);
            String value = this.getProperty(propName);
            osa.put(newPropName, value);
        }
        return osa;
    }

    public void addObjStoreAttrs(ObjStoreAttrs osa) {
        int index = this.getObjStoreCount();
        String basePropName = PROP_NAME_OBJSTORE_BASENAME + Integer.toString(index) + ".";
        String idPropName = basePropName + PROP_NAME_OBJSTORE_ID_PREFIX;
        String id = osa.getID();
        this.setProperty(idPropName, id);
        String descPropName = basePropName + PROP_NAME_OBJSTORE_DESC_PREFIX;
        String desc = osa.getDescription();
        this.setProperty(descPropName, desc);
        String objstoreAttrsStr = basePropName + PROP_NAME_OBJSTORE_ATTR_PREFIX + ".";
        Enumeration e = osa.keys();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            String newValue = (String)osa.get(propName);
            String newPropName = objstoreAttrsStr + propName;
            this.setProperty(newPropName, newValue);
        }
        this.setProperty(PROP_NAME_OBJSTORE_COUNT, Integer.toString(++index));
    }

    @Override
    public void load() throws UserPropertiesException, SecurityException {
        super.load();
        String v = this.getVersion();
        if (v == null) {
            return;
        }
        this.checkVersion(v, "2.0", "2.0");
    }

    private void checkVersion(String fileVersionStr, String expectedVersionStr, String firstVersionStr) throws UserPropertiesException {
        double fileVersion2;
        double firstVersion2;
        double expectedVersion;
        try {
            expectedVersion = Double.parseDouble(expectedVersionStr);
        }
        catch (NumberFormatException nfe) {
            double expectedVersion2 = 0.0;
            UserPropertiesException upe = new UserPropertiesException(acr.getString("A3082", expectedVersionStr));
            throw upe;
        }
        try {
            firstVersion2 = Double.parseDouble(firstVersionStr);
        }
        catch (NumberFormatException nfe) {
            double firstVersion2 = 0.0;
            UserPropertiesException upe = new UserPropertiesException(acr.getString("A3082", firstVersionStr));
            throw upe;
        }
        try {
            fileVersion2 = Double.parseDouble(fileVersionStr);
        }
        catch (NumberFormatException nfe) {
            Object[] args = new Object[4];
            double fileVersion2 = 0.0;
            args[0] = this.getAbsoluteFileName();
            args[1] = PROP_NAME_VERSION;
            args[2] = fileVersionStr;
            args[3] = expectedVersionStr;
            String s = acr.getString("A3083", args);
            UserPropertiesException upe = new UserPropertiesException(s);
            throw upe;
        }
        if (fileVersion2 < firstVersion2) {
            Object[] args = new Object[]{this.getAbsoluteFileName(), PROP_NAME_VERSION, fileVersionStr, expectedVersionStr};
            String s = acr.getString("A3083", args);
            UserPropertiesException upe = new UserPropertiesException(s);
            throw upe;
        }
        if (fileVersion2 > expectedVersion) {
            Object[] args = new Object[]{this.getAbsoluteFileName(), PROP_NAME_VERSION, fileVersionStr, expectedVersionStr};
            String s = acr.getString("A3083", args);
            UserPropertiesException upe = new UserPropertiesException(s);
            throw upe;
        }
    }
}

