/*
 * Copyright (c) Members of the EGEE Collaboration. 2006-2010.
 * See http://www.eu-egee.org/partners/ for details on the copyright holders.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id$
 */
package org.glite.authz.pep.profile;

import org.glite.authz.pep.PEPException;

/**
 * Exception for profile processing
 */
public class ProfileException extends PEPException {

    /** Serial version */
    private static final long serialVersionUID= 6696042569341460539L;

    /**
     * Default constructor.
     */
    public ProfileException() {
        super();
    }

    /**
     * Constructor.
     * 
     * @param message
     *            the error message
     */
    public ProfileException(String message) {
        super(message);
    }

    /**
     * Constructor.
     * 
     * @param cause
     *            the exception cause
     */
    public ProfileException(Exception cause) {
        super(cause);
    }

    /**
     * Constructor.
     * 
     * @param message
     *            the exception message
     * @param cause
     *            the exception cause
     */
    public ProfileException(String message, Exception cause) {
        super(message, cause);
    }

}
