/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.common.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.X509CertificateObject;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PasswordFinder;
import org.glite.authz.common.model.util.Strings;

public class PEMFileReader {
    private Log log = LogFactory.getLog(PEMFileReader.class);

    public PrivateKey readPrivateKey(String filename, String password) throws FileNotFoundException, IOException {
        File file = new File(filename);
        return this.readPrivateKey(file, password);
    }

    public PrivateKey readPrivateKey(File file, String password) throws FileNotFoundException, IOException {
        this.log.debug((Object)("file: " + file));
        FileInputStream is = new FileInputStream(file);
        try {
            return this.readPrivateKey(is, password);
        }
        catch (IOException ioe) {
            String error = "Invalid file " + file + ": " + ioe.getMessage();
            this.log.error((Object)error);
            throw new IOException(error, ioe);
        }
    }

    protected PrivateKey readPrivateKey(InputStream is, String password) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(is);
        PEMReader reader = new PEMReader((Reader)inputStreamReader, (PasswordFinder)new PEMPassword(password));
        Object object = null;
        do {
            if ((object = reader.readObject()) != null) continue;
            String error = "No KeyPair or PrivateKey object found";
            this.log.error((Object)error);
            throw new IOException(error);
        } while (!(object instanceof KeyPair) && !(object instanceof PrivateKey));
        this.log.debug((Object)("Object type: " + object.getClass().getCanonicalName()));
        try {
            reader.close();
        }
        catch (Exception error) {
            // empty catch block
        }
        if (object instanceof KeyPair) {
            KeyPair keyPair = (KeyPair)object;
            return keyPair.getPrivate();
        }
        if (object instanceof PrivateKey) {
            return (PrivateKey)object;
        }
        String error = "Unknown object type: " + object.getClass().getName();
        this.log.error((Object)error);
        throw new IOException(error);
    }

    public X509Certificate[] readCertificates(String filename) throws FileNotFoundException, IOException {
        File file = new File(filename);
        return this.readCertificates(file);
    }

    public X509Certificate[] readCertificates(File file) throws FileNotFoundException, IOException {
        FileReader fileReader = new FileReader(file);
        PEMReader reader = new PEMReader((Reader)fileReader, (PasswordFinder)new PEMPassword());
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        Object object = null;
        do {
            try {
                object = reader.readObject();
                if (!(object instanceof X509CertificateObject)) continue;
                X509Certificate cert = (X509Certificate)object;
                certs.add(cert);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        } while (object != null);
        try {
            reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return certs.toArray(new X509Certificate[0]);
    }

    static {
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    private class PEMPassword
    implements PasswordFinder {
        private char[] password_ = null;

        public PEMPassword() {
            this.password_ = null;
        }

        public PEMPassword(String password) {
            this.password_ = (char[])(password == null ? null : (char[])(Strings.safeTrimOrNullString((String)password) == null ? null : password.toCharArray()));
        }

        public char[] getPassword() {
            return this.password_;
        }
    }
}

