/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.profile;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.glite.authz.common.model.Action;
import org.glite.authz.common.model.Attribute;
import org.glite.authz.common.model.AttributeAssignment;
import org.glite.authz.common.model.Environment;
import org.glite.authz.common.model.Obligation;
import org.glite.authz.common.model.Request;
import org.glite.authz.common.model.Resource;
import org.glite.authz.common.model.Response;
import org.glite.authz.common.model.Result;
import org.glite.authz.common.model.Subject;
import org.glite.authz.common.model.util.Strings;
import org.glite.authz.common.security.PEMUtils;
import org.glite.authz.pep.profile.AuthorizationProfile;
import org.glite.authz.pep.profile.ProfileException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAuthorizationProfile
implements AuthorizationProfile {
    private String profileId_;

    @Override
    public Request createRequest(Subject subject, Resource resource, Action action, Environment environment) {
        Request request = new Request();
        if (subject != null) {
            request.getSubjects().add(subject);
        }
        if (resource != null) {
            request.getResources().add(resource);
        }
        if (action != null) {
            request.setAction(action);
        }
        if (environment != null) {
            request.setEnvironment(environment);
        }
        return request;
    }

    @Override
    public Resource createResourceId(String resourceId) {
        Attribute attrResourceId = new Attribute();
        attrResourceId.setId(this.getResourceIdAttributeIdentifer());
        attrResourceId.setDataType(this.getResourceIdDatatype());
        attrResourceId.getValues().add(resourceId);
        Resource resource = new Resource();
        resource.getAttributes().add(attrResourceId);
        return resource;
    }

    protected String getSubjectIdAttributeIdentifier() {
        return "urn:oasis:names:tc:xacml:1.0:subject:subject-id";
    }

    protected String getSubjectIdAttributeDatatype() {
        return "urn:oasis:names:tc:xacml:1.0:data-type:x500Name";
    }

    protected String getSubjectKeyInfoAttributeIdentifer() {
        return "urn:oasis:names:tc:xacml:1.0:subject:key-info";
    }

    protected abstract String getSubjectKeyInfoAttributeDatatype();

    protected abstract String getProfileIdAttributeIdentifer();

    protected String getProfileIdDatatype() {
        return "http://www.w3.org/2001/XMLSchema#anyURI";
    }

    protected String getResourceIdAttributeIdentifer() {
        return "urn:oasis:names:tc:xacml:1.0:resource:resource-id";
    }

    protected String getResourceIdDatatype() {
        return "http://www.w3.org/2001/XMLSchema#string";
    }

    protected String getActionIdAttributeIdentifer() {
        return "urn:oasis:names:tc:xacml:1.0:action:action-id";
    }

    protected String getActionIdDatatype() {
        return "http://www.w3.org/2001/XMLSchema#string";
    }

    protected abstract String getMapUserToPOSIXEnvironmentObligationIdentifier();

    protected abstract String getUserIdAttributeAssignmentIdentifier();

    protected abstract String getGroupIdAttributeAssignmentIdentifier();

    protected abstract String getPrimaryGroupIdAttributeAssignmentIdentifier();

    @Override
    public Action createActionId(String actionId) {
        Action action = new Action();
        Attribute attrActionId = new Attribute();
        attrActionId.setId(this.getActionIdAttributeIdentifer());
        attrActionId.setDataType(this.getActionIdDatatype());
        attrActionId.getValues().add(actionId);
        action.getAttributes().add(attrActionId);
        return action;
    }

    @Override
    public Request createRequest(Subject subject, Resource resource, Action action) {
        return this.createRequest(subject, resource, action, this.createEnvironmentProfileId(this.getProfileId()));
    }

    @Override
    public Obligation getObligation(Response response, int decision, String obligationId) throws ProfileException {
        List results = response.getResults();
        Iterator iterator = results.iterator();
        if (iterator.hasNext()) {
            Result result = (Result)iterator.next();
            if (result.getDecision() == decision) {
                List obligations = result.getObligations();
                for (Obligation obligation : obligations) {
                    String id = obligation.getId();
                    if (obligation.getFulfillOn() != decision || !obligationId.equals(id)) continue;
                    return obligation;
                }
                throw new ProfileException("No obligation " + obligationId + " found");
            }
            String errorMessage = "No decision " + Result.decisionToString((int)decision) + " found: " + result.getDecisionString();
            String statusMessage = result.getStatus().getMessage();
            if (statusMessage != null) {
                errorMessage = errorMessage + ". Status: " + statusMessage;
            }
            throw new ProfileException(errorMessage);
        }
        return null;
    }

    protected AbstractAuthorizationProfile(String profileId) {
        this.profileId_ = Strings.safeTrimOrNullString((String)profileId);
    }

    @Override
    public String getProfileId() {
        return this.profileId_;
    }

    @Override
    public Environment createEnvironmentProfileId(String profileId) {
        Environment environment = new Environment();
        Attribute attrProfileId = new Attribute();
        attrProfileId.setId(this.getProfileIdAttributeIdentifer());
        attrProfileId.setDataType(this.getProfileIdDatatype());
        attrProfileId.getValues().add(profileId);
        environment.getAttributes().add(attrProfileId);
        return environment;
    }

    @Override
    public Request createRequest(X509Certificate[] certs, String resourceid, String actionid) throws ProfileException {
        Subject subject = this.createSubjectKeyInfo(certs);
        Resource resource = this.createResourceId(resourceid);
        Action action = this.createActionId(actionid);
        Request request = this.createRequest(subject, resource, action);
        return request;
    }

    @Override
    public Request createRequest(X509Certificate[] keyinfo, String resourceid, String actionid, String profileid) throws ProfileException {
        Subject subject = this.createSubjectKeyInfo(keyinfo);
        Resource resource = this.createResourceId(resourceid);
        Action action = this.createActionId(actionid);
        Environment environment = this.createEnvironmentProfileId(profileid);
        Request request = this.createRequest(subject, resource, action, environment);
        return request;
    }

    @Override
    public Subject createSubjectId(String subjectId) {
        Subject subject = new Subject();
        Attribute subjectIdAttribute = new Attribute(this.getSubjectIdAttributeIdentifier(), this.getSubjectIdAttributeDatatype());
        subjectIdAttribute.getValues().add(subjectId);
        subject.getAttributes().add(subjectIdAttribute);
        return subject;
    }

    @Override
    public Subject createSubjectKeyInfo(X509Certificate cert) throws ProfileException {
        return this.createSubjectKeyInfo(cert, null);
    }

    @Override
    public Subject createSubjectKeyInfo(X509Certificate[] certs) throws ProfileException {
        return this.createSubjectKeyInfo(null, certs);
    }

    @Override
    public Subject createSubjectKeyInfo(X509Certificate cert, X509Certificate[] chain) throws ProfileException {
        String keyInfo;
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        if (cert != null) {
            certs.add(cert);
        }
        if (chain != null) {
            for (X509Certificate chainCert : chain) {
                certs.add(chainCert);
            }
        }
        try {
            keyInfo = PEMUtils.certificatesToPEMString(certs);
        }
        catch (IOException e) {
            throw new ProfileException("Can not convert certificate to PEM format", e);
        }
        Subject subject = new Subject();
        Attribute attrKeyInfo = new Attribute();
        attrKeyInfo.setId(this.getSubjectKeyInfoAttributeIdentifer());
        attrKeyInfo.setDataType(this.getSubjectKeyInfoAttributeDatatype());
        attrKeyInfo.getValues().add(keyInfo);
        subject.getAttributes().add(attrKeyInfo);
        return subject;
    }

    @Override
    public Obligation getObligationPosixMapping(Response response) throws ProfileException {
        Obligation posixMappingObligation = this.getObligation(response, 1, this.getMapUserToPOSIXEnvironmentObligationIdentifier());
        return posixMappingObligation;
    }

    @Override
    public String getAttributeAssignmentUserId(Obligation posixMappingObligation) throws ProfileException {
        String obligationId = this.getMapUserToPOSIXEnvironmentObligationIdentifier();
        if (!obligationId.equals(posixMappingObligation.getId())) {
            throw new ProfileException("Obligation is not " + obligationId + " but " + posixMappingObligation.getId());
        }
        List attributes = posixMappingObligation.getAttributeAssignments();
        String attributeAssignmentId = this.getUserIdAttributeAssignmentIdentifier();
        for (AttributeAssignment attribute : attributes) {
            String id = attribute.getAttributeId();
            if (!attributeAssignmentId.equals(id)) continue;
            String userId = Strings.safeTrimOrNullString((String)attribute.getValue());
            if (userId == null) {
                throw new ProfileException("Attribute assignment " + attributeAssignmentId + " found in obligation, but with an empty or null value");
            }
            return userId;
        }
        throw new ProfileException("Mandatory attribute assignment " + attributeAssignmentId + " not found in obligation " + obligationId);
    }

    @Override
    public List<String> getAttributeAssignmentGroupIds(Obligation posixMappingObligation) throws ProfileException {
        String obligationId = this.getMapUserToPOSIXEnvironmentObligationIdentifier();
        if (!obligationId.equals(posixMappingObligation.getId())) {
            throw new ProfileException("Obligation is not " + obligationId);
        }
        ArrayList<String> groupIds = new ArrayList<String>();
        List attributes = posixMappingObligation.getAttributeAssignments();
        String attributeAssignmentId = this.getGroupIdAttributeAssignmentIdentifier();
        for (AttributeAssignment attribute : attributes) {
            String id = attribute.getAttributeId();
            if (!attributeAssignmentId.equals(id)) continue;
            groupIds.add(attribute.getValue());
        }
        return groupIds;
    }

    @Override
    public String getAttributeAssignmentPrimaryGroupId(Obligation posixMappingObligation) throws ProfileException {
        String obligationId = this.getMapUserToPOSIXEnvironmentObligationIdentifier();
        if (!obligationId.equals(posixMappingObligation.getId())) {
            throw new ProfileException("Obligation is not " + obligationId);
        }
        List attributes = posixMappingObligation.getAttributeAssignments();
        String attributeAssignmentId = this.getPrimaryGroupIdAttributeAssignmentIdentifier();
        for (AttributeAssignment attribute : attributes) {
            String id = attribute.getAttributeId();
            if (!attributeAssignmentId.equals(id)) continue;
            String groupId = attribute.getValue();
            return groupId;
        }
        return null;
    }
}

