/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.glite.voms.LSCFile;
import org.glite.voms.PKIUtils;
import org.glite.voms.SigningPolicy;
import org.glite.voms.ac.VOMSTrustStore;

public class PKIStore
implements VOMSTrustStore {
    private Hashtable certificates = null;
    private Hashtable crls = null;
    private Hashtable signings = null;
    private Hashtable lscfiles = null;
    private Hashtable vomscerts = null;
    private static Logger logger = Logger.getLogger((String)PKIStore.class.getName());
    public static final int TYPE_VOMSDIR = 1;
    public static final int TYPE_CADIR = 2;
    private static final int CERT = 1;
    private static final int CRL = 2;
    private static final int SIGN = 3;
    private static final int LSC = 4;
    private static final int HASHCAPACITY = 75;
    private boolean aggressive = false;
    private Timer theTimer = null;
    private String certDir = null;
    private int type = -1;
    public static final String DEFAULT_VOMSDIR = File.separator + "etc" + File.separator + "grid-security" + File.separator + "vomsdir";
    public static final String DEFAULT_CADIR = File.separator + "etc" + File.separator + "grid-security" + File.separator + "certificates";

    public Hashtable getCAs() {
        return (Hashtable)this.certificates.clone();
    }

    public Hashtable getCRLs() {
        return this.crls;
    }

    public Hashtable getSignings() {
        return this.signings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refresh() {
        PKIStore pKIStore = null;
        try {
            pKIStore = new PKIStore(this.certDir, this.type, this.aggressive, false);
        }
        catch (Exception exception) {
            logger.error((Object)("Cannot refresh store: " + exception.getMessage()));
            return;
        }
        finally {
            if (pKIStore != null) {
                pKIStore.stopRefresh();
            }
        }
        try {
            this.certificates.clear();
            this.certificates = pKIStore.certificates;
            pKIStore.certificates = null;
            this.crls.clear();
            this.crls = pKIStore.crls;
            pKIStore.crls = null;
            this.signings.clear();
            this.signings = pKIStore.signings;
            pKIStore.signings = null;
            this.lscfiles.clear();
            this.lscfiles = pKIStore.lscfiles;
            pKIStore.lscfiles = null;
            this.vomscerts.clear();
            this.vomscerts = pKIStore.vomscerts;
            pKIStore.vomscerts = null;
        }
        finally {
            pKIStore = null;
        }
    }

    PKIStore(String string, int n, boolean bl, boolean bl2) throws IOException, CertificateException, CRLException {
        File file;
        this.aggressive = bl;
        this.certificates = new Hashtable(75);
        this.crls = new Hashtable(75);
        this.signings = new Hashtable(75);
        this.lscfiles = new Hashtable(75);
        this.vomscerts = new Hashtable(75);
        logger.info((Object)("Initializing " + (n == 1 ? "VOMS" : "CA") + " certificate store from directory: " + string));
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("Unsupported value for type parameter in PKIReader constructor");
        }
        if (string == null || string.equals("")) {
            if (n == 1) {
                string = DEFAULT_VOMSDIR;
            } else if (n == 2) {
                string = DEFAULT_CADIR;
            }
        }
        if (!(file = new File(string)).exists()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Directory " + string + " doesn't exist on this machine!");
            if (n == 2) {
                stringBuffer.append(" Please specify a value for the cadir directory or set the CADIR system property.");
                throw new FileNotFoundException(stringBuffer.toString());
            }
            logger.warn((Object)"Please specify a value for the vomsdir directory or set the VOMSDIR system property.");
        }
        if (file.exists() && !file.isDirectory()) {
            throw new IllegalArgumentException((n == 1 ? "Voms certificate" : "CA certificate") + " directory passed as argument is not a directory! [" + file.getAbsolutePath() + "]");
        }
        if (file.exists() && file.list().length == 0) {
            if (n == 2) {
                throw new IllegalArgumentException("CA certificate directory passed as argument is empty! [" + file.getAbsolutePath() + "]");
            }
            logger.warn((Object)("Voms certificate directory passed as argument is empty! [" + file.getAbsolutePath() + "]"));
            logger.warn((Object)"Validation of VOMS Attribute Certificate will likely fail.");
        }
        this.certDir = string;
        this.type = n;
        if (file.exists()) {
            this.load();
        }
        if (bl2) {
            this.theTimer = new Timer(true);
            this.theTimer.scheduleAtFixedRate((TimerTask)new Refreshener(), 30000L, 30000L);
        }
    }

    public PKIStore(String string, int n, boolean bl) throws IOException, CertificateException, CRLException {
        this(string, n, bl, true);
    }

    public PKIStore(String string, int n) throws IOException, CertificateException, CRLException {
        this(string, n, true, true);
    }

    public PKIStore() {
        this.aggressive = true;
        this.certificates = new Hashtable(75);
        this.crls = new Hashtable(75);
        this.signings = new Hashtable(75);
        this.lscfiles = new Hashtable(75);
        this.vomscerts = new Hashtable(75);
    }

    public void rescheduleRefresh(int n) {
        if (this.theTimer != null) {
            this.theTimer.cancel();
        }
        this.theTimer = null;
        this.theTimer = new Timer(true);
        this.theTimer.scheduleAtFixedRate((TimerTask)new Refreshener(), n, (long)n);
    }

    public void stopRefresh() {
        if (this.theTimer != null) {
            this.theTimer.cancel();
        }
        this.theTimer = null;
    }

    public void setAggressive(boolean bl) {
        this.aggressive = bl;
    }

    public LSCFile getLSC(String string, String string2) {
        Hashtable hashtable = (Hashtable)this.lscfiles.get(string);
        if (hashtable != null) {
            return (LSCFile)hashtable.get(string2);
        }
        return null;
    }

    public X509Certificate[] getAACandidate(X500Principal x500Principal, String string) {
        Hashtable hashtable = (Hashtable)this.vomscerts.get(PKIUtils.getHash(x500Principal));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("listcerts content: " + hashtable));
        }
        if (hashtable != null) {
            HashSet hashSet = (HashSet)hashtable.get(string);
            if (hashSet == null) {
                hashSet = (HashSet)hashtable.get("");
            }
            if (hashSet != null) {
                return hashSet.toArray(new X509Certificate[0]);
            }
        }
        return null;
    }

    public void load() throws IOException, CertificateException, CRLException {
        switch (this.type) {
            case 1: {
                this.getForVOMS(new File(this.certDir), null);
                break;
            }
            case 2: {
                this.getForCA(new File(this.certDir));
                break;
            }
        }
    }

    private void load(X509Certificate x509Certificate, String string) {
        if (x509Certificate == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("CERT = " + x509Certificate + " , vo = " + string));
        }
        String string2 = PKIUtils.getHash(x509Certificate);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registered HASH: " + string2 + " for " + x509Certificate.getSubjectDN().getName() + " for vo: " + string));
            logger.debug((Object)("Class of getSubjectDN: " + x509Certificate.getSubjectDN().getClass()));
            logger.debug((Object)("KNOWN HASH ? " + this.vomscerts.containsKey(string2)));
            logger.debug((Object)("VOMSCERTS = " + this.vomscerts));
        }
        if (this.vomscerts.containsKey(string2)) {
            logger.debug((Object)"Already exixtsing HASH");
            Hashtable hashtable = (Hashtable)this.vomscerts.get(string2);
            HashSet hashSet = (HashSet)hashtable.get(string);
            if (hashSet != null) {
                hashSet.add(x509Certificate);
            } else {
                HashSet<X509Certificate> hashSet2 = new HashSet<X509Certificate>();
                hashSet2.add(x509Certificate);
                hashtable.put(string, hashSet2);
            }
        } else {
            logger.debug((Object)"Originally EMPTY table");
            Hashtable hashtable = new Hashtable(75);
            HashSet<X509Certificate> hashSet = new HashSet<X509Certificate>();
            hashSet.add(x509Certificate);
            hashtable.put(string, hashSet);
            this.vomscerts.put(string2, hashtable);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Inserted HASH: " + string2));
                logger.debug((Object)("NEW VOMSCERTS = " + this.vomscerts));
            }
        }
    }

    private void load(X509Certificate[] x509CertificateArray, String string) {
        int n = x509CertificateArray.length;
        logger.debug((Object)("LEN = " + n));
        for (int i = 0; i < n; ++i) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("PARSING: " + i + " value: " + x509CertificateArray[i]));
            }
            this.load(x509CertificateArray[i], string);
        }
    }

    private void load(X509Certificate x509Certificate) {
        String string = PKIUtils.getHash(x509Certificate);
        if (this.certificates.containsKey(string)) {
            ((Vector)this.certificates.get(string)).add(x509Certificate);
        } else {
            Vector<X509Certificate> vector = new Vector<X509Certificate>();
            vector.add(x509Certificate);
            this.certificates.put(string, vector);
        }
    }

    private void load(X509Certificate[] x509CertificateArray) {
        int n = x509CertificateArray.length;
        for (int i = 0; i < n; ++i) {
            this.load(x509CertificateArray[i]);
        }
    }

    private void load(X509CRL x509CRL) {
        String string = PKIUtils.getHash(x509CRL);
        if (this.crls.containsKey(string)) {
            ((Vector)this.crls.get(string)).add(x509CRL);
        } else {
            Vector<X509CRL> vector = new Vector<X509CRL>();
            vector.add(x509CRL);
            this.crls.put(string, vector);
        }
    }

    private void load(X509CRL[] x509CRLArray) {
        int n = x509CRLArray.length;
        for (int i = 0; i < n; ++i) {
            this.load(x509CRLArray[i]);
        }
    }

    private void load(SigningPolicy signingPolicy) {
        String string = signingPolicy.getName();
        this.signings.put(string, signingPolicy);
    }

    private void load(SigningPolicy[] signingPolicyArray) {
        int n = signingPolicyArray.length;
        for (int i = 0; i < n; ++i) {
            this.load(signingPolicyArray[i]);
        }
    }

    private void load(LSCFile lSCFile, String string) {
        String string2 = lSCFile.getName();
        Hashtable hashtable = null;
        if (!this.lscfiles.containsKey(string)) {
            hashtable = new Hashtable();
            this.lscfiles.put(string, hashtable);
        }
        if (hashtable == null) {
            hashtable = (Hashtable)this.lscfiles.get(string);
        }
        hashtable.put(string2, lSCFile);
    }

    private void load(LSCFile[] lSCFileArray, String string) {
        int n = lSCFileArray.length;
        for (int i = 0; i < n; ++i) {
            this.load(lSCFileArray[i], string);
        }
    }

    private void getForCA(File file) throws IOException, CertificateException, CRLException {
        File[] fileArray = file.listFiles();
        for (File file2 : Arrays.asList(fileArray)) {
            logger.debug((Object)("filename: " + file2.getName()));
            try {
                Couple couple = this.getObject(file2);
                if (couple == null) continue;
                int n = (Integer)couple.second;
                logger.debug((Object)("TYPE: " + n));
                if (n == 2) {
                    this.load((X509CRL)couple.first);
                    continue;
                }
                if (n == 1) {
                    X509Certificate[] x509CertificateArray = new X509Certificate[]{};
                    this.load(((List)couple.first).toArray(x509CertificateArray));
                    continue;
                }
                if (n != 3) continue;
                this.load((SigningPolicy)couple.first);
            }
            catch (IOException iOException) {
                logger.error((Object)iOException.getMessage(), (Throwable)iOException);
                file2 = null;
                if (this.aggressive) continue;
                throw iOException;
            }
            catch (CRLException cRLException) {
                logger.error((Object)cRLException.getMessage(), (Throwable)cRLException);
                file2 = null;
                if (this.aggressive) continue;
                throw cRLException;
            }
            catch (CertificateException certificateException) {
                logger.error((Object)certificateException.getMessage(), (Throwable)certificateException);
                file2 = null;
                if (this.aggressive) continue;
                throw certificateException;
            }
        }
    }

    private void getForVOMS(File file, String string) throws IOException, CertificateException, CRLException {
        File[] fileArray = file.listFiles();
        Iterator<File> iterator = Arrays.asList(fileArray).iterator();
        if (string == null) {
            string = "";
        }
        logger.debug((Object)("For VO: " + string));
        while (iterator.hasNext()) {
            File file2 = iterator.next();
            try {
                logger.debug((Object)("NAME: " + file2.getName()));
                if (!file2.isDirectory()) {
                    Couple couple = this.getObject(file2);
                    if (couple != null) {
                        Object object;
                        int n = (Integer)couple.second;
                        logger.debug((Object)("TYPE: " + n));
                        if (n == 1) {
                            object = new X509Certificate[]{};
                            this.load(((List)couple.first).toArray((T[])object), string);
                        } else if (n == 4) {
                            this.load((LSCFile)couple.first, string);
                            if (logger.isDebugEnabled()) {
                                object = ((LSCFile)couple.first).getDNLists();
                                ListIterator listIterator = ((Vector)object).listIterator();
                                int n2 = 0;
                                while (listIterator.hasNext()) {
                                    logger.debug((Object)("Sequence: " + n2));
                                    Vector vector = (Vector)listIterator.next();
                                    ListIterator listIterator2 = vector.listIterator();
                                    while (listIterator2.hasNext()) {
                                        logger.debug((Object)("DN: " + (String)listIterator2.next()));
                                    }
                                }
                            }
                        }
                    }
                } else if (string == "") {
                    this.getForVOMS(file2, file2.getName());
                }
                file2 = null;
            }
            catch (CertificateException certificateException) {
                logger.error((Object)certificateException.getMessage(), (Throwable)certificateException);
                file2 = null;
                if (this.aggressive) continue;
                throw certificateException;
            }
            catch (CRLException cRLException) {
                logger.error((Object)cRLException.getMessage(), (Throwable)cRLException);
                file2 = null;
                if (this.aggressive) continue;
                throw cRLException;
            }
            catch (IOException iOException) {
                logger.error((Object)iOException.getMessage(), (Throwable)iOException);
                file2 = null;
                if (this.aggressive) continue;
                throw iOException;
            }
        }
    }

    private Couple getObject(File file) throws IOException, CertificateException, CRLException {
        if (file.getName().matches(".*\\.lsc")) {
            return new Couple(new LSCFile(file), new Integer(4));
        }
        if (file.getName().matches(".*\\.signing_policy")) {
            return new Couple(new SigningPolicy(file), new Integer(3));
        }
        Object object = null;
        try {
            object = PKIUtils.readObject(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.error((Object)("Problem reading file " + file.getName() + ": " + fileNotFoundException.getMessage()));
            return null;
        }
        if (object instanceof X509CRL) {
            return new Couple(object, new Integer(2));
        }
        if (object instanceof List) {
            return new Couple(object, new Integer(1));
        }
        return null;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    private class Couple {
        Object first;
        Object second;

        Couple(Object object, Object object2) {
            this.first = object;
            this.second = object2;
        }
    }

    private class Refreshener
    extends TimerTask {
        private Refreshener() {
        }

        public void run() {
            PKIStore.this.refresh();
        }
    }
}

