/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glite.voms.PKIUtils;

public class SigningPolicy {
    private static final int ACCESS_ID_CA = 1;
    private static final int POS_RIGHTS = 2;
    private static final int COND_SUBJECTS = 3;
    private static final Pattern access_id_ca_pattern = Pattern.compile("access_id_CA\\s+x509\\s+(.*)", 2);
    private static final Pattern pos_rights_pattern = Pattern.compile("pos_rights\\s+globus\\s+(.*)", 2);
    private static final Pattern cond_subjects_pattern = Pattern.compile("cond_subjects\\s+globus\\s+(['\"])(.*?)\\1\\s*", 2);
    private static final Pattern remove_single_quotes = Pattern.compile("'(.*)'");
    private static final Pattern remove_double_quotes = Pattern.compile("\"(.*)\"");
    private static final Pattern get_subject_pattern = Pattern.compile("(['\"]?)(.*?)\\1\\s*?");
    private String access_id_ca = null;
    private String pos_rights = null;
    private Vector subjects = null;
    private String gname = null;
    private Vector access_id_ca_list = new Vector();
    private Vector pos_rights_list = new Vector();
    private Vector subjects_list = new Vector();
    private int current = -1;
    private int mode = 1;

    public SigningPolicy(File file) throws IOException {
        this.parse(file);
    }

    public String getName() {
        return this.gname;
    }

    public int findIssuer(String string) {
        return this.findIssuer(string, -1);
    }

    public int findIssuer(String string, int n) {
        if (n < -1) {
            return -1;
        }
        return this.access_id_ca_list.indexOf(string, n + 1);
    }

    public void setCurrent(int n) {
        if (n > this.access_id_ca_list.size() || n < 0) {
            throw new IllegalArgumentException("Index out of bounds for SigningPolicy " + this.gname);
        }
        this.current = n;
    }

    public String getAccessIDCA() {
        if (this.current != -1) {
            return (String)this.access_id_ca_list.elementAt(this.current);
        }
        throw new IllegalArgumentException("Current record must be set in Signing Policy object " + this.gname);
    }

    public String getPosRights() {
        if (this.current != -1) {
            return (String)this.pos_rights_list.elementAt(this.current);
        }
        throw new IllegalArgumentException("Current record must be set in Signing Policy object " + this.gname);
    }

    public Vector getCondSubjects() {
        if (this.current != -1) {
            return (Vector)this.subjects_list.elementAt(this.current);
        }
        throw new IllegalArgumentException("Current record must be set in Signing Policy object " + this.gname);
    }

    private String parseAccessIDCA(String string) {
        String string2 = null;
        Matcher matcher = access_id_ca_pattern.matcher(string);
        if (matcher.matches()) {
            String string3 = matcher.group(1);
            Matcher matcher2 = null;
            switch (string3.charAt(0)) {
                case '\'': {
                    matcher2 = remove_single_quotes.matcher(string3);
                    if (!matcher2.matches()) break;
                    string2 = matcher2.group(1);
                    break;
                }
                case '\"': {
                    matcher2 = remove_double_quotes.matcher(string3);
                    if (!matcher2.matches()) break;
                    string2 = matcher2.group(1);
                    break;
                }
                default: {
                    string2 = string3;
                }
            }
        }
        return string2;
    }

    private String parsePosRights(String string) {
        String string2 = null;
        Matcher matcher = pos_rights_pattern.matcher(string);
        if (matcher.matches()) {
            string2 = matcher.group(1);
        }
        return string2;
    }

    private Vector parseCondSubjects(String string) {
        Matcher matcher = cond_subjects_pattern.matcher(string);
        Vector<String> vector = new Vector<String>();
        while (matcher.find()) {
            String string2 = matcher.group(2);
            Matcher matcher2 = get_subject_pattern.matcher(string2);
            while (matcher2.find()) {
                String string3 = matcher2.group(2);
                if (string3.length() == 0) continue;
                vector.add(string3);
            }
            if (string2.length() == 0 || vector.size() != 0) continue;
            vector.add(string2);
        }
        return vector;
    }

    private SigningPolicy parse(File file) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = null;
        boolean bl = true;
        this.gname = PKIUtils.getBaseName(file);
        this.access_id_ca = null;
        this.pos_rights = null;
        this.subjects = null;
        boolean bl2 = false;
        string = bufferedReader.readLine();
        while (string != null) {
            if ((string = string.trim()).length() != 0 && !string.startsWith("#")) {
                switch (this.mode) {
                    case 1: {
                        if (!bl) {
                            if (this.access_id_ca != null && this.pos_rights != null && this.subjects != null) {
                                this.access_id_ca_list.add(this.access_id_ca);
                                this.pos_rights_list.add(this.pos_rights);
                                this.subjects_list.add(this.subjects);
                            }
                            this.access_id_ca = null;
                            this.pos_rights = null;
                            this.subjects = null;
                        }
                        this.access_id_ca = this.parseAccessIDCA(string);
                        if (this.access_id_ca == null) {
                            bl2 = true;
                        }
                        this.mode = 2;
                        break;
                    }
                    case 2: {
                        this.pos_rights = this.parsePosRights(string);
                        if (this.pos_rights == null) {
                            bl2 = true;
                        }
                        this.mode = 3;
                        break;
                    }
                    case 3: {
                        this.subjects = this.parseCondSubjects(string);
                        if (this.subjects.size() == 0) {
                            bl2 = true;
                        }
                        this.mode = 1;
                        bl = false;
                    }
                }
                if (bl2) break;
            }
            string = bufferedReader.readLine();
        }
        if (this.access_id_ca != null && this.pos_rights != null && this.subjects != null && !bl2) {
            this.access_id_ca_list.add(this.access_id_ca);
            this.pos_rights_list.add(this.pos_rights);
            this.subjects_list.add(this.subjects);
        }
        bufferedReader.close();
        if (bl2) {
            throw new IOException("Error in reading format of file: " + file.getName());
        }
        return this;
    }
}

