/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.glite.voms.BasicVOMSTrustStore;
import org.glite.voms.CertUtil;
import org.glite.voms.FQAN;
import org.glite.voms.PKIStore;
import org.glite.voms.VOMSAttribute;
import org.glite.voms.ac.ACTrustStore;
import org.glite.voms.ac.ACValidator;
import org.glite.voms.ac.AttributeCertificate;
import org.glite.voms.ac.VOMSTrustStore;

public class VOMSValidator {
    static Logger log = Logger.getLogger(VOMSValidator.class);
    public static final String VOMS_EXT_OID = "1.3.6.1.4.1.8005.100.100.5";
    protected static ACTrustStore theTrustStore;
    protected ACValidator myValidator;
    protected X509Certificate[] myValidatedChain;
    protected Vector myVomsAttributes;
    protected boolean isParsed;
    protected boolean isValidated;
    protected FQANTree myFQANTree;
    protected static VOMSTrustStore vomsStore;

    public VOMSValidator(X509Certificate x509Certificate) {
        this(new X509Certificate[]{x509Certificate});
    }

    public VOMSValidator(X509Certificate[] x509CertificateArray) {
        this(x509CertificateArray, null);
    }

    public VOMSValidator(X509Certificate[] x509CertificateArray, ACValidator aCValidator) {
        block17: {
            this.myVomsAttributes = new Vector();
            this.isParsed = false;
            this.isValidated = false;
            this.myFQANTree = null;
            this.myValidatedChain = x509CertificateArray;
            if (aCValidator == null) {
                if (theTrustStore == null) {
                    if (vomsStore == null) {
                        try {
                            String string = System.getProperty("VOMSDIR");
                            if (string == null) {
                                vomsStore = new PKIStore(PKIStore.DEFAULT_VOMSDIR, 1, true);
                                break block17;
                            }
                            vomsStore = new PKIStore(string, 1, true);
                        }
                        catch (IOException iOException) {
                        }
                        catch (CertificateException certificateException) {
                        }
                        catch (CRLException cRLException) {}
                    }
                } else if (theTrustStore instanceof BasicVOMSTrustStore) {
                    BasicVOMSTrustStore basicVOMSTrustStore = (BasicVOMSTrustStore)theTrustStore;
                    basicVOMSTrustStore.stopRefresh();
                    if (vomsStore == null) {
                        String string = basicVOMSTrustStore.getDirList();
                        try {
                            vomsStore = new PKIStore(string, 1, true);
                        }
                        catch (IOException iOException) {
                        }
                        catch (CertificateException certificateException) {
                        }
                        catch (CRLException cRLException) {}
                    }
                } else if (vomsStore == null) {
                    log.error((Object)"Cannot replace passed truststore.  Validation may not be complete.");
                }
            }
        }
        this.myValidator = vomsStore != null ? (aCValidator == null ? new ACValidator(vomsStore) : aCValidator) : (aCValidator == null ? new ACValidator(theTrustStore) : aCValidator);
    }

    public static void setTrustStore(ACTrustStore aCTrustStore) {
        if (aCTrustStore instanceof BasicVOMSTrustStore) {
            BasicVOMSTrustStore basicVOMSTrustStore = (BasicVOMSTrustStore)aCTrustStore;
            String string = basicVOMSTrustStore.getDirList();
            try {
                VOMSValidator.setTrustStore(new PKIStore(string, 1, true));
                basicVOMSTrustStore.stopRefresh();
            }
            catch (Exception exception) {
                log.error((Object)"Cannot set upgraded truststore!");
                theTrustStore = aCTrustStore;
            }
        } else {
            log.error((Object)"Cannot set upgraded truststore!");
            theTrustStore = aCTrustStore;
        }
    }

    public static void setTrustStore(VOMSTrustStore vOMSTrustStore) {
        vomsStore = vOMSTrustStore;
    }

    public void cleanup() {
        this.myValidatedChain = null;
        if (this.myVomsAttributes != null) {
            this.myVomsAttributes.clear();
            this.myVomsAttributes = null;
        }
        this.myFQANTree = null;
        if (this.myValidator != null) {
            this.myValidator.cleanup();
            this.myValidator = null;
        }
        if (vomsStore != null) {
            vomsStore.stopRefresh();
            vomsStore = null;
        }
        if (theTrustStore != null) {
            if (theTrustStore instanceof BasicVOMSTrustStore) {
                ((BasicVOMSTrustStore)theTrustStore).stopRefresh();
            }
            theTrustStore = null;
        }
    }

    public VOMSValidator setClientChain(X509Certificate[] x509CertificateArray) {
        this.myValidatedChain = x509CertificateArray;
        this.myVomsAttributes = new Vector();
        this.myFQANTree = null;
        this.isParsed = false;
        this.isValidated = false;
        return this;
    }

    public static Vector parse(X509Certificate[] x509CertificateArray) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"VOMSValidator : parsing cert chain");
        }
        int n = -1;
        int n2 = CertUtil.findClientCert(x509CertificateArray);
        if (n2 < 0) {
            log.error((Object)"VOMSValidator : no client cert found in cert chain");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parsing VOMS attributes for subject " + x509CertificateArray[n2].getSubjectX500Principal().getName()));
        }
        Vector<VOMSAttribute> vector = new Vector<VOMSAttribute>();
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            byte[] byArray = x509CertificateArray[i].getExtensionValue(VOMS_EXT_OID);
            if (byArray == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("No VOMS extension in certificate issued to " + x509CertificateArray[i].getSubjectX500Principal().getName()));
                continue;
            }
            try {
                byArray = ((DEROctetString)new DERInputStream((InputStream)new ByteArrayInputStream(byArray)).readObject()).getOctets();
                ASN1Sequence aSN1Sequence = (ASN1Sequence)new DERInputStream((InputStream)new ByteArrayInputStream(byArray)).readObject();
                Enumeration enumeration = aSN1Sequence.getObjects();
                while (enumeration.hasMoreElements()) {
                    ASN1Sequence aSN1Sequence2 = (ASN1Sequence)enumeration.nextElement();
                    Enumeration enumeration2 = aSN1Sequence2.getObjects();
                    while (enumeration2.hasMoreElements()) {
                        AttributeCertificate attributeCertificate = new AttributeCertificate((ASN1Sequence)enumeration2.nextElement());
                        ++n;
                        for (int j = n2; j < x509CertificateArray.length; ++j) {
                            if (attributeCertificate.getHolder().isHolder(x509CertificateArray[j])) {
                                VOMSAttribute vOMSAttribute = new VOMSAttribute(attributeCertificate);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Found VOMS attribute from " + vOMSAttribute.getHostPort() + " in certificate issued to " + x509CertificateArray[j].getSubjectX500Principal().getName()));
                                }
                                vector.add(vOMSAttribute);
                                continue;
                            }
                            log.debug((Object)"VOMS attribute cert found, but holder checking failed!");
                        }
                    }
                }
                break;
            }
            catch (Exception exception) {
                log.info((Object)("Error parsing VOMS extension in certificate issued to " + x509CertificateArray[i].getSubjectX500Principal().getName()), (Throwable)exception);
                throw new IllegalArgumentException("Error parsing VOMS extension in certificate issued to " + x509CertificateArray[i].getSubjectX500Principal().getName() + "error was:" + exception.getMessage());
            }
        }
        return vector;
    }

    public VOMSValidator parse() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"VOMSValidator : parsing cert chain");
        }
        if (this.isParsed) {
            return this;
        }
        int n = CertUtil.findClientCert(this.myValidatedChain);
        if (n < 0) {
            log.error((Object)"VOMSValidator : no client cert found in cert chain");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parsing VOMS attributes for subject " + this.myValidatedChain[n].getSubjectX500Principal().getName()));
        }
        this.myVomsAttributes.clear();
        for (int i = 0; i < this.myValidatedChain.length; ++i) {
            byte[] byArray = this.myValidatedChain[i].getExtensionValue(VOMS_EXT_OID);
            if (byArray == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("No VOMS extension in certificate issued to " + this.myValidatedChain[i].getSubjectX500Principal().getName()));
                continue;
            }
            try {
                byArray = ((DEROctetString)new DERInputStream((InputStream)new ByteArrayInputStream(byArray)).readObject()).getOctets();
                ASN1Sequence aSN1Sequence = (ASN1Sequence)new DERInputStream((InputStream)new ByteArrayInputStream(byArray)).readObject();
                Enumeration enumeration = aSN1Sequence.getObjects();
                while (enumeration.hasMoreElements()) {
                    ASN1Sequence aSN1Sequence2 = (ASN1Sequence)enumeration.nextElement();
                    Enumeration enumeration2 = aSN1Sequence2.getObjects();
                    while (enumeration2.hasMoreElements()) {
                        AttributeCertificate attributeCertificate = new AttributeCertificate((ASN1Sequence)enumeration2.nextElement());
                        for (int j = n; j < this.myValidatedChain.length; ++j) {
                            if (attributeCertificate.getHolder().isHolder(this.myValidatedChain[j])) {
                                VOMSAttribute vOMSAttribute = new VOMSAttribute(attributeCertificate);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Found VOMS attribute from " + vOMSAttribute.getHostPort() + " in certificate issued to " + this.myValidatedChain[j].getSubjectX500Principal().getName()));
                                }
                                this.myVomsAttributes.add(vOMSAttribute);
                                continue;
                            }
                            log.debug((Object)"VOMS attribute cert found, but holder checking failed!");
                        }
                    }
                }
                break;
            }
            catch (Exception exception) {
                log.info((Object)("Error parsing VOMS extension in certificate issued to " + this.myValidatedChain[i].getSubjectX500Principal().getName()), (Throwable)exception);
                throw new IllegalArgumentException("Error parsing VOMS extension in certificate issued to " + this.myValidatedChain[i].getSubjectX500Principal().getName() + "error was:" + exception.getMessage());
            }
        }
        this.isParsed = true;
        return this;
    }

    public VOMSValidator validate() {
        if (this.isValidated) {
            return this;
        }
        if (!this.isParsed) {
            this.parse();
            this.isParsed = true;
        }
        ListIterator listIterator = this.myVomsAttributes.listIterator();
        while (listIterator.hasNext()) {
            AttributeCertificate attributeCertificate = ((VOMSAttribute)listIterator.next()).privateGetAC();
            if (this.myValidator.validate(attributeCertificate)) continue;
            listIterator.remove();
        }
        this.isValidated = true;
        return this;
    }

    private void populate() {
        if (!this.isParsed && !this.isValidated) {
            throw new IllegalStateException("VOMSValidator: trying to populate FQAN tree before call to parse() or validate()");
        }
        this.myFQANTree = new FQANTree();
        ListIterator listIterator = this.myVomsAttributes.listIterator();
        while (listIterator.hasNext()) {
            this.myFQANTree.add(((VOMSAttribute)listIterator.next()).getListOfFQAN());
        }
    }

    public String[] getAllFullyQualifiedAttributes() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.myVomsAttributes.size(); ++i) {
            List list = ((VOMSAttribute)this.myVomsAttributes.get(i)).getFullyQualifiedAttributes();
            arrayList.addAll(list);
        }
        return arrayList.toArray(new String[0]);
    }

    public List getVOMSAttributes() {
        return this.myVomsAttributes;
    }

    public List getRoles(String string) {
        if (!this.isParsed && !this.isValidated) {
            throw new IllegalStateException("Must call parse() or validate() first");
        }
        if (this.myFQANTree == null) {
            this.populate();
        }
        return this.myFQANTree.getRoles(string);
    }

    public List getCapabilities(String string) {
        if (!this.isParsed && !this.isValidated) {
            throw new IllegalStateException("Must call parse() or validate() first");
        }
        if (this.myFQANTree == null) {
            this.populate();
        }
        return this.myFQANTree.getCapabilities(string);
    }

    public boolean isValidated() {
        return this.isValidated;
    }

    public boolean isValid() {
        return true;
    }

    public String toString() {
        return "isParsed : " + this.isParsed + "\nhas been validated : " + this.isValidated + "\nVOMS attrs:" + this.myVomsAttributes;
    }

    static {
        vomsStore = null;
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public class FQANTree {
        Hashtable myTree = new Hashtable();
        Hashtable myResults = new Hashtable();

        public void add(List list) {
            if (list == null) {
                return;
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.add((FQAN)iterator.next());
            }
        }

        public void add(FQAN fQAN) {
            String string = fQAN.getGroup();
            Vector<FQAN> vector = (Vector<FQAN>)this.myTree.get(string);
            if (vector == null) {
                vector = new Vector<FQAN>();
                this.myTree.put(string, vector);
            }
            if (!vector.contains(fQAN)) {
                vector.add(fQAN);
            }
        }

        protected RoleCaps traverse(String string) {
            RoleCaps roleCaps = (RoleCaps)this.myResults.get(string);
            if (roleCaps != null) {
                return roleCaps;
            }
            roleCaps = new RoleCaps();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/", true);
            StringBuffer stringBuffer = new StringBuffer();
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(stringTokenizer.nextToken());
                roleCaps.add((Vector)this.myTree.get(stringBuffer.toString()));
            }
            this.myResults.put(string, roleCaps);
            return roleCaps;
        }

        public List getRoles(String string) {
            return this.traverse(string).getRoles();
        }

        public List getCapabilities(String string) {
            return this.traverse(string).getCapabilities();
        }
    }

    class RoleCaps {
        List roles;
        List caps;

        RoleCaps() {
        }

        void add(List list, String string) {
            if (string == null) {
                return;
            }
            if (!list.contains(string)) {
                list.add(string);
            }
        }

        public void add(Vector vector) {
            if (vector == null) {
                return;
            }
            if (this.roles == null) {
                this.roles = new Vector();
                this.caps = new Vector();
            }
            for (FQAN fQAN : vector) {
                this.add(this.roles, fQAN.getRole());
                this.add(this.caps, fQAN.getCapability());
            }
        }

        public List getRoles() {
            return this.roles;
        }

        public List getCapabilities() {
            return this.caps;
        }
    }
}

