/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.ac;

import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.glite.voms.ac.NameConverter;

public class ACTarget
implements DEREncodable {
    private GeneralName name;
    private GeneralName group;
    private IssuerSerial cert;

    public ACTarget() {
        this.name = null;
        this.group = null;
        this.cert = null;
    }

    public String toString() {
        if (this.name != null) {
            return this.getName();
        }
        if (this.group != null) {
            return this.getGroup();
        }
        if (this.cert != null) {
            return this.getIssuerSerialString();
        }
        return null;
    }

    public String getName() {
        return new String(NameConverter.getInstance(this.name).getAsString());
    }

    public String getGroup() {
        return new String(NameConverter.getInstance(this.group).getAsString());
    }

    public IssuerSerial getIssuerSerial() {
        return this.cert;
    }

    public String getIssuerSerialString() {
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)this.cert.getIssuer().getDERObject());
        GeneralName generalName = GeneralName.getInstance((Object)aSN1Sequence.getObjectAt(0));
        return new String(NameConverter.getInstance(generalName).getAsString() + ":" + this.cert.getSerial().toString());
    }

    public void setName(GeneralName generalName) {
        this.name = generalName;
    }

    public void setName(String string) {
        this.name = new GeneralName((DERObject)new DERIA5String(string), 6);
    }

    public void setGroup(GeneralName generalName) {
        this.group = generalName;
    }

    public void setGroup(String string) {
        this.group = new GeneralName((DERObject)new DERIA5String(string), 6);
    }

    public void setIssuerSerial(IssuerSerial issuerSerial) {
        this.cert = issuerSerial;
    }

    public void setIssuerSerial(String string) {
        int n = string.lastIndexOf(58);
        if (n == -1) {
            throw new IllegalArgumentException("cannot identify issuer and serial");
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        GeneralName generalName = new GeneralName((DERObject)new DERIA5String(string2), 6);
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)this.name.getDERObject());
        DEREncodableVector dEREncodableVector = new DEREncodableVector();
        dEREncodableVector.add((DEREncodable)generalName);
        dEREncodableVector.add((DEREncodable)aSN1Sequence);
        this.cert = new IssuerSerial((ASN1Sequence)new DERSequence(dEREncodableVector));
    }

    public static ACTarget getInstance(ASN1Sequence aSN1Sequence) {
        return new ACTarget(aSN1Sequence);
    }

    public ACTarget(ASN1Sequence aSN1Sequence) {
        this.group = null;
        this.name = null;
        this.cert = null;
        for (int i = 0; i <= aSN1Sequence.size(); ++i) {
            if (aSN1Sequence.getObjectAt(i) instanceof ASN1TaggedObject) {
                ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Sequence.getObjectAt(i);
                switch (aSN1TaggedObject.getTagNo()) {
                    case 0: {
                        this.group = null;
                        this.cert = null;
                        this.name = GeneralName.getInstance((ASN1TaggedObject)aSN1TaggedObject, (boolean)true);
                        break;
                    }
                    case 1: {
                        this.cert = null;
                        this.group = GeneralName.getInstance((ASN1TaggedObject)aSN1TaggedObject, (boolean)true);
                        this.name = null;
                        break;
                    }
                    case 2: {
                        this.group = null;
                        this.name = null;
                        this.cert = new IssuerSerial((ASN1Sequence)aSN1TaggedObject.getObject());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Bad tag in encoding ACTarget");
                    }
                }
                continue;
            }
            throw new IllegalArgumentException("Bad value type encoding ACTarget");
        }
    }

    public DERObject getDERObject() {
        DEREncodableVector dEREncodableVector = new DEREncodableVector();
        if (this.name != null) {
            dEREncodableVector.add((DEREncodable)new DERTaggedObject(0, (DEREncodable)this.name));
        }
        if (this.group != null) {
            dEREncodableVector.add((DEREncodable)new DERTaggedObject(1, (DEREncodable)this.group));
        }
        if (this.cert != null) {
            dEREncodableVector.add((DEREncodable)new DERTaggedObject(2, (DEREncodable)this.cert));
        }
        return new DERSequence(dEREncodableVector);
    }
}

