/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.ac;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.SimpleTimeZone;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AttCertValidityPeriod;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.X509Principal;
import org.glite.voms.PKIUtils;
import org.glite.voms.ac.ACCerts;
import org.glite.voms.ac.ACTargets;
import org.glite.voms.ac.AttributeCertificateInfo;
import org.glite.voms.ac.FullAttributes;
import org.glite.voms.ac.Holder;
import org.glite.voms.ac.Util;

public class AttributeCertificate
implements DEREncodable {
    protected static Logger logger = Logger.getLogger(AttributeCertificate.class);
    AttributeCertificateInfo acInfo;
    AlgorithmIdentifier signatureAlgorithm;
    DERBitString signatureValue;
    DERObject signedObj = null;

    public AttributeCertificate(ASN1Sequence aSN1Sequence) throws IOException {
        this.signedObj = ((ASN1Sequence)aSN1Sequence.getObjectAt(0)).getDERObject();
        this.acInfo = new AttributeCertificateInfo((ASN1Sequence)aSN1Sequence.getObjectAt(0));
        this.signatureAlgorithm = AlgorithmIdentifier.getInstance((Object)aSN1Sequence.getObjectAt(1));
        this.signatureValue = (DERBitString)aSN1Sequence.getObjectAt(2);
    }

    public static AttributeCertificate getInstance(InputStream inputStream) throws IOException {
        DERInputStream dERInputStream = new DERInputStream(inputStream);
        ASN1Sequence aSN1Sequence = (ASN1Sequence)dERInputStream.readObject();
        return new AttributeCertificate(aSN1Sequence);
    }

    public AttributeCertificateInfo getAcinfo() {
        return this.acInfo;
    }

    public ASN1Sequence getAttributes() {
        if (this.acInfo == null) {
            return null;
        }
        return this.acInfo.getAttributes();
    }

    public DERInteger getSerialNumber() {
        if (this.acInfo == null) {
            return null;
        }
        return this.acInfo.getSerialNumber();
    }

    public String getVO() {
        if (this.acInfo == null) {
            return null;
        }
        return this.acInfo.getVO();
    }

    public String getHostPort() {
        if (this.acInfo == null) {
            return null;
        }
        return this.acInfo.getHostPort();
    }

    public String getHost() {
        if (this.acInfo == null) {
            return null;
        }
        return this.acInfo.getHost();
    }

    public int getPort() {
        if (this.acInfo == null) {
            return -1;
        }
        return this.acInfo.getPort();
    }

    public FullAttributes getFullAttributes() {
        if (this.acInfo == null) {
            return null;
        }
        return this.acInfo.getFullAttributes();
    }

    public ACCerts getCertList() {
        if (this.acInfo == null) {
            return null;
        }
        return this.acInfo.getCertList();
    }

    public ACTargets getTargets() {
        if (this.acInfo == null) {
            return null;
        }
        return this.acInfo.getTargets();
    }

    public List getFullyQualifiedAttributes() {
        if (this.acInfo == null) {
            return null;
        }
        return this.acInfo.getFullyQualifiedAttributes();
    }

    public List getListOfFQAN() {
        if (this.acInfo == null) {
            return null;
        }
        return this.acInfo.getListOfFQAN();
    }

    public List getAttributes(String string) {
        if (string == null) {
            return Collections.EMPTY_LIST;
        }
        ASN1Sequence aSN1Sequence = this.getAttributes();
        if (aSN1Sequence == null || aSN1Sequence.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        Vector vector = new Vector();
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)enumeration.nextElement();
            if (!string.equals(((DERObjectIdentifier)aSN1Sequence2.getObjectAt(0)).getId())) continue;
            DERConstructedSet dERConstructedSet = (DERConstructedSet)aSN1Sequence2.getObjectAt(1);
            Enumeration enumeration2 = dERConstructedSet.getObjects();
            while (enumeration2.hasMoreElements()) {
                vector.add(enumeration2.nextElement());
            }
        }
        return vector;
    }

    public X509Extensions getExtensions() {
        return this.acInfo == null ? null : this.acInfo.getExtensions();
    }

    public X509Principal getIssuerX509() {
        if (this.acInfo == null) {
            return null;
        }
        if (this.acInfo.getIssuer() == null) {
            return null;
        }
        ASN1Sequence aSN1Sequence = (ASN1Sequence)this.acInfo.getIssuer().getIssuerName().getDERObject();
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            GeneralName generalName = GeneralName.getInstance((Object)((ASN1TaggedObject)enumeration.nextElement()));
            if (generalName.getTagNo() != 4) continue;
            return Util.generalNameToX509Name(generalName);
        }
        return null;
    }

    public X500Principal getIssuer() {
        if (this.acInfo == null) {
            return null;
        }
        if (this.acInfo.getIssuer() == null) {
            return null;
        }
        ASN1Sequence aSN1Sequence = (ASN1Sequence)this.acInfo.getIssuer().getIssuerName().getDERObject();
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            GeneralName generalName = GeneralName.getInstance(e);
            if (generalName.getTagNo() != 4) continue;
            return Util.generalNameToX500Name(generalName);
        }
        return null;
    }

    public String getHolderX509() {
        if (this.acInfo == null) {
            return null;
        }
        if (this.acInfo.getHolder() == null) {
            return null;
        }
        GeneralNames generalNames = this.acInfo.getHolder().getIssuer();
        Enumeration enumeration = ((ASN1Sequence)generalNames.getDERObject()).getObjects();
        while (enumeration.hasMoreElements()) {
            GeneralName generalName = GeneralName.getInstance((Object)((ASN1TaggedObject)enumeration.nextElement()));
            if (generalName.getTagNo() != 4) continue;
            X509Principal x509Principal = Util.generalNameToX509Name(generalName);
            return PKIUtils.getOpenSSLFormatPrincipal((Principal)x509Principal);
        }
        return null;
    }

    public Holder getHolder() {
        return this.acInfo == null ? null : this.acInfo.getHolder();
    }

    private static Date getDate(DERGeneralizedTime dERGeneralizedTime) throws ParseException {
        SimpleDateFormat simpleDateFormat;
        String string = dERGeneralizedTime.getTime();
        if (string.indexOf("GMT") > 0) {
            simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssz");
        } else {
            simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
            simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        }
        return simpleDateFormat.parse(dERGeneralizedTime.getTime());
    }

    public Date getNotAfter() throws ParseException {
        return AttributeCertificate.getDate(this.acInfo.getAttrCertValidityPeriod().getNotAfterTime());
    }

    public Date getNotBefore() throws ParseException {
        return AttributeCertificate.getDate(this.acInfo.getAttrCertValidityPeriod().getNotBeforeTime());
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public DERBitString getSignatureValue() {
        return this.signatureValue;
    }

    public byte[] getSignature() {
        return this.signatureValue.getBytes();
    }

    public boolean validAt(Date date) {
        AttCertValidityPeriod attCertValidityPeriod = this.acInfo.getAttrCertValidityPeriod();
        if (date == null) {
            date = new Date();
        }
        try {
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = Calendar.getInstance();
            calendar.setTime(AttributeCertificate.getDate(attCertValidityPeriod.getNotAfterTime()));
            calendar2.setTime(AttributeCertificate.getDate(attCertValidityPeriod.getNotBeforeTime()));
            calendar.add(12, 5);
            calendar2.add(12, -5);
            return calendar.getTime().after(date) && calendar2.getTime().before(date);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Invalid validity encoding in Attribute Certificate");
        }
    }

    public boolean isValid() {
        return this.validAt(new Date());
    }

    public boolean verify(PublicKey publicKey) {
        Object var2_2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            new DEROutputStream((OutputStream)byteArrayOutputStream).writeObject((Object)this.acInfo);
            byte[] byArray = null;
            byArray = this.signatureValue.getBytes();
            Signature signature = Signature.getInstance(this.signatureAlgorithm.getObjectId().getId());
            signature.initVerify(publicKey);
            signature.update(byteArrayOutputStream.toByteArray());
            return signature.verify(this.signatureValue.getBytes());
        }
        catch (Exception exception) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Error verifying signature of AC issued by " + this.getIssuer().getName() + " : " + exception.getMessage()));
            }
            return false;
        }
    }

    public boolean verifyCert(X509Certificate x509Certificate) {
        Object var2_2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            new DEROutputStream((OutputStream)byteArrayOutputStream).writeObject((Object)this.acInfo);
            Signature signature = Signature.getInstance(this.signatureAlgorithm.getObjectId().getId());
            signature.initVerify(x509Certificate);
            signature.update(byteArrayOutputStream.toByteArray());
            return signature.verify(this.signatureValue.getBytes());
        }
        catch (Exception exception) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Error verifying signature of AC issued by " + this.getIssuer().getName() + " : " + exception.getMessage()));
            }
            return false;
        }
    }

    public DERObject getDERObject() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((DEREncodable)this.acInfo);
        aSN1EncodableVector.add((DEREncodable)this.signatureAlgorithm);
        aSN1EncodableVector.add((DEREncodable)this.signatureValue);
        return new DERSequence((DEREncodableVector)aSN1EncodableVector);
    }
}

