/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.ac;

import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.glite.voms.ac.GenericAttribute;

public class AttributeHolder
implements DEREncodable {
    private List l;
    private GeneralNames grantor;

    public AttributeHolder() {
        this.l = null;
        this.grantor = null;
    }

    public AttributeHolder(ASN1Sequence aSN1Sequence) {
        this.l = new Vector();
        this.grantor = null;
        if (aSN1Sequence.size() != 2) {
            throw new IllegalArgumentException("Encoding error in AttributeHolder");
        }
        if (aSN1Sequence.getObjectAt(0) instanceof ASN1Sequence && aSN1Sequence.getObjectAt(1) instanceof ASN1Sequence) {
            this.grantor = GeneralNames.getInstance((Object)aSN1Sequence.getObjectAt(0));
            aSN1Sequence = (ASN1Sequence)aSN1Sequence.getObjectAt(1);
            Enumeration enumeration = aSN1Sequence.getObjects();
            while (enumeration.hasMoreElements()) {
                GenericAttribute genericAttribute = new GenericAttribute((ASN1Sequence)enumeration.nextElement());
                this.l.add(genericAttribute);
            }
        } else {
            throw new IllegalArgumentException("Encoding error in AttributeHolder");
        }
    }

    public static AttributeHolder getInstance(ASN1Sequence aSN1Sequence) {
        return new AttributeHolder(aSN1Sequence);
    }

    public String getGrantor() {
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)this.grantor.getDERObject());
        GeneralName generalName = GeneralName.getInstance((Object)aSN1Sequence.getObjectAt(0));
        return DERIA5String.getInstance((Object)generalName.getName()).getString();
    }

    public List getAttributes() {
        return this.l;
    }

    public DERObject getDERObject() {
        DEREncodableVector dEREncodableVector = new DEREncodableVector();
        dEREncodableVector.add((DEREncodable)this.grantor);
        DEREncodableVector dEREncodableVector2 = new DEREncodableVector();
        DERSequence dERSequence = this.l.listIterator();
        while (dERSequence.hasNext()) {
            GenericAttribute genericAttribute = (GenericAttribute)dERSequence.next();
            dEREncodableVector2.add((DEREncodable)genericAttribute);
        }
        dERSequence = new DERSequence(dEREncodableVector2);
        dEREncodableVector.add((DEREncodable)dERSequence);
        return new DERSequence(dEREncodableVector);
    }
}

