/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.ac;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;

public class Util {
    public static GeneralNames generalNameToGeneralNames(GeneralName generalName) {
        DEREncodableVector dEREncodableVector = new DEREncodableVector();
        dEREncodableVector.add((DEREncodable)generalName);
        return GeneralNames.getInstance((Object)new DERSequence(dEREncodableVector));
    }

    public static GeneralName x500nameToGeneralName(byte[] byArray) {
        try {
            return new GeneralName((X509Name)new X509Principal(byArray));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid X500 name encoding");
        }
    }

    public static GeneralNames x500nameToGeneralNames(X500Principal x500Principal) {
        return Util.generalNameToGeneralNames(Util.x500nameToGeneralName(x500Principal.getEncoded()));
    }

    public static X500Principal generalNameToX500Name(GeneralName generalName) {
        int n = -1;
        if (generalName == null || (n = generalName.getTagNo()) != 4) {
            throw new IllegalArgumentException("GeneralName is not a DirectoryName (tag=" + n + ")");
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            new DEROutputStream((OutputStream)byteArrayOutputStream).writeObject((Object)generalName.getName());
            return new X500Principal(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Bad DN encoding of Attribute Certificate issuer");
        }
    }

    public static X509Principal generalNameToX509Name(GeneralName generalName) {
        int n = -1;
        if (generalName == null || (n = generalName.getTagNo()) != 4) {
            throw new IllegalArgumentException("GeneralName is not a DirectoryName (tag=" + n + ")");
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            new DEROutputStream((OutputStream)byteArrayOutputStream).writeObject((Object)generalName.getName());
            return new X509Principal(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Bad DN encoding of Attribute Certificate issuer");
        }
    }
}

