/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.ac;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.glite.voms.ac.ObjectDigestInfo;

public class V2Form
implements DEREncodable {
    GeneralNames issuerName;
    IssuerSerial baseCertificateID;
    ObjectDigestInfo objectDigestInfo;

    public V2Form(GeneralNames generalNames) {
        this.issuerName = generalNames;
    }

    public V2Form(ASN1Sequence aSN1Sequence) {
        int n = 0;
        if (aSN1Sequence.getObjectAt(0) instanceof ASN1Sequence) {
            this.issuerName = new GeneralNames((ASN1Sequence)aSN1Sequence.getObjectAt(0));
            ++n;
        }
        while (n < aSN1Sequence.size()) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Sequence.getObjectAt(n);
            switch (aSN1TaggedObject.getTagNo()) {
                case 0: {
                    this.baseCertificateID = new IssuerSerial((ASN1Sequence)aSN1TaggedObject.getObject());
                    break;
                }
                case 1: {
                    this.objectDigestInfo = new ObjectDigestInfo((ASN1Sequence)aSN1TaggedObject.getObject());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad tag " + aSN1TaggedObject.getTagNo() + " in V2Form");
                }
            }
            ++n;
        }
    }

    public GeneralNames getIssuerName() {
        return this.issuerName;
    }

    public IssuerSerial getBaseCertificateID() {
        return this.baseCertificateID;
    }

    public ObjectDigestInfo getObjectDigestInfo() {
        return this.objectDigestInfo;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.issuerName != null) {
            aSN1EncodableVector.add(((ASN1Sequence)this.issuerName.getDERObject()).getObjectAt(0));
        }
        if (this.baseCertificateID != null) {
            aSN1EncodableVector.add((DEREncodable)new DERTaggedObject(0, (DEREncodable)this.baseCertificateID));
        }
        if (this.objectDigestInfo != null) {
            aSN1EncodableVector.add((DEREncodable)new DERTaggedObject(1, (DEREncodable)this.objectDigestInfo));
        }
        return new DERSequence((DEREncodableVector)aSN1EncodableVector);
    }
}

