/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.contact;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.glite.voms.contact.VOMSSyntaxException;

public class PathNamingScheme {
    public static final Logger log = Logger.getLogger(PathNamingScheme.class);
    public static final String containerSyntax = "^(/[\\w.-]+)+|((/[\\w.-]+)+/)?(Role=[\\w.-]+)|(Capability=[\\w\\s.-]+)$";
    public static final String groupSyntax = "^(/[\\w.-]+)+$";
    public static final String roleSyntax = "^Role=[\\w.-]+$";
    public static final String qualifiedRoleSyntax = "^(/[\\w.-]+)+/Role=[\\w.-]+$";
    public static final String capabilitySyntax = "^Capability=[\\w\\s.-]+$";
    public static final Pattern containerPattern = Pattern.compile("^(/[\\w.-]+)+|((/[\\w.-]+)+/)?(Role=[\\w.-]+)|(Capability=[\\w\\s.-]+)$");
    public static final Pattern groupPattern = Pattern.compile("^(/[\\w.-]+)+$");
    public static final Pattern rolePattern = Pattern.compile("^Role=[\\w.-]+$");
    public static final Pattern qualifiedRolePattern = Pattern.compile("^(/[\\w.-]+)+/Role=[\\w.-]+$");
    public static final Pattern capabilityPattern = Pattern.compile("^Capability=[\\w\\s.-]+$");

    public static void checkSyntax(String string) {
        if (string.length() > 255) {
            throw new VOMSSyntaxException("containerName.length() > 255");
        }
        if (!containerPattern.matcher(string).matches()) {
            throw new VOMSSyntaxException("Syntax error in container name: " + string);
        }
    }

    public static void checkGroup(String string) {
        PathNamingScheme.checkSyntax(string);
        if (!groupPattern.matcher(string).matches()) {
            throw new VOMSSyntaxException("Syntax error in group name: " + string);
        }
    }

    public static void checkRole(String string) {
        if (string.length() > 255) {
            throw new VOMSSyntaxException("roleName.length()>255");
        }
        if (!rolePattern.matcher(string).matches()) {
            throw new VOMSSyntaxException("Syntax error in role name: " + string);
        }
    }

    public static boolean isGroup(String string) {
        PathNamingScheme.checkSyntax(string);
        return groupPattern.matcher(string).matches();
    }

    public static boolean isRole(String string) {
        PathNamingScheme.checkSyntax(string);
        return rolePattern.matcher(string).matches();
    }

    public static boolean isQualifiedRole(String string) {
        PathNamingScheme.checkSyntax(string);
        return qualifiedRolePattern.matcher(string).matches();
    }

    public static String getRoleName(String string) {
        if (!PathNamingScheme.isRole(string) && !PathNamingScheme.isQualifiedRole(string)) {
            throw new VOMSSyntaxException("No role specified in \"" + string + "\" voms syntax.");
        }
        Matcher matcher = containerPattern.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(4);
            return string2.substring(string2.indexOf("=") + 1, string2.length());
        }
        return null;
    }

    public static String getGroupName(String string) {
        PathNamingScheme.checkSyntax(string);
        if (!PathNamingScheme.isRole(string) && !PathNamingScheme.isQualifiedRole(string)) {
            return string;
        }
        Matcher matcher = containerPattern.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(2);
            if (string2.endsWith("/")) {
                return string2.substring(0, string2.length() - 1);
            }
            return string2;
        }
        return null;
    }

    public static String toOldQualifiedRoleSyntax(String string) {
        PathNamingScheme.checkSyntax(string);
        if (!PathNamingScheme.isQualifiedRole(string)) {
            throw new VOMSSyntaxException("String passed as argument is not a qualified role!");
        }
        return PathNamingScheme.getGroupName(string) + ":" + PathNamingScheme.getRoleName(string);
    }
}

