/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.contact;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.glite.voms.contact.VOMSException;
import org.glite.voms.contact.VOMSParser;
import org.glite.voms.contact.VOMSRequestFactory;
import org.glite.voms.contact.VOMSRequestOptions;
import org.glite.voms.contact.VOMSResponse;
import org.w3c.dom.Document;

public class VOMSProtocol {
    private static final Logger log = Logger.getLogger(VOMSProtocol.class);
    private VOMSRequestFactory requestFactory = VOMSRequestFactory.instance();
    private TransformerFactory transformerFactory;
    private VOMSParser parser = VOMSParser.instance();

    private VOMSProtocol() {
        this.transformerFactory = TransformerFactory.newInstance();
    }

    public static VOMSProtocol instance() {
        return new VOMSProtocol();
    }

    protected String xmlDocAsString(Document document) {
        Transformer transformer;
        try {
            transformer = this.transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            log.error((Object)("Error creating XML transformer:" + transformerConfigurationException.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)transformerConfigurationException.getMessage(), (Throwable)transformerConfigurationException);
            }
            throw new VOMSException("Error creating XML transformer:", transformerConfigurationException);
        }
        StringWriter stringWriter = new StringWriter();
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(stringWriter);
        try {
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerException transformerException) {
            log.error((Object)("Error caught serializing XML :" + transformerException.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)transformerException.getMessage(), (Throwable)transformerException);
            }
            throw new VOMSException("Error caugh serializing XML :", transformerException);
        }
        stringWriter.flush();
        return stringWriter.toString();
    }

    public void sendRequest(VOMSRequestOptions vOMSRequestOptions, OutputStream outputStream) {
        Transformer transformer;
        Document document = this.requestFactory.buildRequest(vOMSRequestOptions);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Voms request:\n" + this.xmlDocAsString(document)));
        }
        try {
            transformer = this.transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            log.error((Object)("Error creating XML transformer:" + transformerConfigurationException.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)transformerConfigurationException.getMessage(), (Throwable)transformerConfigurationException);
            }
            throw new VOMSException("Error creating XML transformer:", transformerConfigurationException);
        }
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(outputStream);
        try {
            transformer.transform(dOMSource, streamResult);
            outputStream.flush();
        }
        catch (TransformerException transformerException) {
            log.error((Object)("XML request serialization error! " + transformerException.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)transformerException.getMessage(), (Throwable)transformerException);
            }
            throw new VOMSException("XML request serialization error! " + transformerException.getMessage(), transformerException);
        }
        catch (IOException iOException) {
            log.error((Object)iOException.getMessage());
            if (log.isDebugEnabled()) {
                log.error((Object)iOException.getMessage(), (Throwable)iOException);
            }
            throw new VOMSException("XML request serialization error! " + iOException.getMessage(), iOException);
        }
    }

    public VOMSResponse getResponse(InputStream inputStream) {
        return this.parser.parseResponse(inputStream);
    }
}

