/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.contact;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509V3CertificateGenerator;
import org.glite.voms.ac.AttributeCertificate;
import org.glite.voms.contact.ExtensionData;
import org.glite.voms.contact.MyProxyCertInfo;
import org.glite.voms.contact.ProxyPolicy;
import org.glite.voms.contact.UserCredentials;
import org.glite.voms.contact.VOMSException;

public class VOMSProxyBuilder {
    private static final Logger log = Logger.getLogger(VOMSProxyBuilder.class);
    public static final int GT2_PROXY = 2;
    public static final int GT3_PROXY = 3;
    public static final int GT4_PROXY = 4;
    public static final int DEFAULT_PROXY_TYPE = 2;
    public static final int DEFAULT_DELEGATION_TYPE = 0;
    public static final int DEFAULT_PROXY_LIFETIME = 86400;
    private static final String PROXY_CERT_INFO_V3_OID = "1.3.6.1.4.1.3536.1.222";
    private static final String PROXY_CERT_INFO_V4_OID = "1.3.6.1.5.5.7.1.14";

    public static AttributeCertificate buildAC(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            AttributeCertificate attributeCertificate = AttributeCertificate.getInstance(byteArrayInputStream);
            return attributeCertificate;
        }
        catch (IOException iOException) {
            log.error((Object)("Error parsing attribute certificate:" + iOException.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)iOException.getMessage(), (Throwable)iOException);
            }
            throw new VOMSException(iOException);
        }
    }

    public static UserCredentials buildProxy(UserCredentials userCredentials, List list, int n, int n2, int n3, String string) {
        Object object;
        DERSequence dERSequence;
        if (list.isEmpty()) {
            throw new VOMSException("Please specify a non-empty list of attribute certificate to build a voms-proxy.");
        }
        Iterator iterator = list.iterator();
        DEREncodableVector dEREncodableVector = new DEREncodableVector();
        while (iterator.hasNext()) {
            dEREncodableVector.add((DEREncodable)((AttributeCertificate)iterator.next()));
        }
        HashMap<String, ExtensionData> hashMap = new HashMap<String, ExtensionData>();
        if (list.size() != 0) {
            dERSequence = new DERSequence(dEREncodableVector);
            object = new DERSequence((DEREncodable)dERSequence);
            hashMap.put("1.3.6.1.4.1.8005.100.100.5", ExtensionData.creator("1.3.6.1.4.1.8005.100.100.5", (DERObject)object));
        }
        dERSequence = new KeyUsage(176);
        hashMap.put("2.5.29.15", ExtensionData.creator("2.5.29.15", true, dERSequence.getDERObject()));
        object = VOMSProxyBuilder.myCreateCredential(userCredentials.getUserChain(), userCredentials.getUserKey(), 512, n, n3, n2, hashMap, string);
        return object;
    }

    public static UserCredentials buildProxy(UserCredentials userCredentials, int n, int n2) {
        return VOMSProxyBuilder.myCreateCredential(userCredentials.getUserChain(), userCredentials.getUserKey(), 1024, n, n2, 2, new HashMap(), "");
    }

    private static UserCredentials myCreateCredential(X509Certificate[] x509CertificateArray, PrivateKey privateKey, int n, int n2, int n3, int n4, HashMap hashMap, String string) {
        KeyPairGenerator keyPairGenerator = null;
        try {
            keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            log.error((Object)("Error activating bouncycastle: " + noSuchAlgorithmException.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
            }
            throw new VOMSException(noSuchAlgorithmException.getMessage(), noSuchAlgorithmException.getCause());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            log.error((Object)("Error activating bouncycastle: " + noSuchProviderException.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)noSuchProviderException.getMessage(), (Throwable)noSuchProviderException);
            }
            throw new VOMSException(noSuchProviderException.getMessage(), noSuchProviderException.getCause());
        }
        keyPairGenerator.initialize(n);
        KeyPair keyPair = keyPairGenerator.genKeyPair();
        X509Certificate x509Certificate = VOMSProxyBuilder.myCreateProxyCertificate(x509CertificateArray[0], privateKey, keyPair.getPublic(), n2, n3, n4, hashMap, string);
        X509Certificate[] x509CertificateArray2 = new X509Certificate[x509CertificateArray.length + 1];
        x509CertificateArray2[0] = x509Certificate;
        System.arraycopy(x509CertificateArray, 0, x509CertificateArray2, 1, x509CertificateArray.length);
        if (log.isDebugEnabled()) {
            for (int i = 0; i < x509CertificateArray2.length; ++i) {
                log.debug((Object)("CERT[" + i + "] IS: " + x509CertificateArray2[i].getSubjectDN()));
            }
        }
        return UserCredentials.instance(keyPair.getPrivate(), x509CertificateArray2);
    }

    /*
     * Unable to fully structure code
     */
    private static X509Certificate myCreateProxyCertificate(X509Certificate var0, PrivateKey var1_1, PublicKey var2_2, int var3_3, int var4_4, int var5_5, HashMap var6_6, String var7_7) {
        var8_8 = new X509V3CertificateGenerator();
        var9_9 = null;
        var10_10 = null;
        var11_11 = null;
        block2 : switch (var5_5) {
            case 2: {
                var11_11 = var0.getSerialNumber();
                switch (var4_4) {
                    case 1: {
                        var9_9 = "limited proxy";
                        break block2;
                    }
                    case 0: {
                        var9_9 = "proxy";
                        break block2;
                    }
                }
                break;
            }
            case 3: 
            case 4: {
                var12_12 = new Random();
                var13_13 = Math.abs(var12_12.nextInt());
                var9_9 = String.valueOf(var13_13);
                var11_11 = new BigInteger(String.valueOf(var13_13));
                var14_15 = (ExtensionData)var6_6.get("1.3.6.1.4.1.3536.1.222");
                if (var14_15 != null) break;
                if (var7_7 != null) ** GOTO lbl38
                switch (var4_4) {
                    case 1: 
                    case 2: 
                    case 3: {
                        var10_10 = new ProxyPolicy(ProxyPolicy.LIMITED);
                        ** GOTO lbl43
                    }
                    case 0: 
                    case 4: 
                    case 5: {
                        var10_10 = new ProxyPolicy(ProxyPolicy.IMPERSONATION);
                        ** GOTO lbl43
                    }
                    case 6: {
                        throw new IllegalArgumentException("Restricted proxy requires ProxyCertInfo");
                    }
                    case 7: {
                        var10_10 = new ProxyPolicy(ProxyPolicy.INDEPENDENT);
                        ** GOTO lbl43
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid proxyType");
                    }
                }
lbl38:
                // 1 sources

                try {
                    var10_10 = new ProxyPolicy(new DERObjectIdentifier(var7_7));
                }
                catch (IllegalArgumentException var15_16) {
                    throw new VOMSException("OID required as policyType");
                }
lbl43:
                // 4 sources

                if (var5_5 == 3) {
                    var6_6.put("1.3.6.1.4.1.3536.1.222", ExtensionData.creator("1.3.6.1.4.1.3536.1.222", new MyProxyCertInfo(var10_10, var5_5).getDERObject()));
                    break;
                }
                var6_6.put("1.3.6.1.5.5.7.1.14", ExtensionData.creator("1.3.6.1.5.5.7.1.14", true, new MyProxyCertInfo(var10_10, var5_5).getDERObject()));
            }
        }
        var12_12 = var6_6.values().toArray(new ExtensionData[0]);
        for (var13_13 = 0; var13_13 < var12_12.length; ++var13_13) {
            var8_8.addExtension(var12_12[var13_13].getOID(), var12_12[var13_13].getCritical(), (DEREncodable)var12_12[var13_13].getObj());
        }
        var13_14 = (X509Name)var0.getSubjectDN();
        var14_15 = new ASN1EncodableVector();
        var14_15.add((DEREncodable)X509Name.CN);
        var14_15.add((DEREncodable)new DERPrintableString(var9_9));
        var15_17 = ((ASN1Sequence)var13_14.getDERObject()).getObjects();
        var16_18 = new ASN1EncodableVector();
        while (var15_17.hasMoreElements()) {
            var16_18.add((DEREncodable)((DERObject)var15_17.nextElement()));
        }
        var16_18.add((DEREncodable)new DERSet((DEREncodable)new DERSequence((DEREncodableVector)var14_15)));
        var17_19 = new X509Name((ASN1Sequence)new DERSequence((DEREncodableVector)var16_18));
        var8_8.setSubjectDN(var17_19);
        var8_8.setIssuerDN(var13_14);
        var8_8.setSerialNumber(var11_11);
        var8_8.setPublicKey(var2_2);
        var8_8.setSignatureAlgorithm(var0.getSigAlgName());
        var18_20 = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        var18_20.add(12, -5);
        var8_8.setNotBefore(var18_20.getTime());
        if (var3_3 <= 0) {
            var8_8.setNotAfter(var0.getNotAfter());
        } else {
            var18_20.add(12, 5);
            var18_20.add(13, var3_3);
            var8_8.setNotAfter(var18_20.getTime());
        }
        try {
            return var8_8.generateX509Certificate(var1_1);
        }
        catch (SignatureException var19_21) {
            VOMSProxyBuilder.log.error((Object)("Error creating proxy: " + var19_21.getMessage()));
            if (VOMSProxyBuilder.log.isDebugEnabled()) {
                VOMSProxyBuilder.log.error((Object)var19_21.getMessage(), (Throwable)var19_21);
            }
            throw new VOMSException(var19_21);
        }
        catch (InvalidKeyException var19_22) {
            VOMSProxyBuilder.log.error((Object)("Error creating proxy: " + var19_22.getMessage()));
            if (VOMSProxyBuilder.log.isDebugEnabled()) {
                VOMSProxyBuilder.log.error((Object)var19_22.getMessage(), (Throwable)var19_22);
            }
            throw new VOMSException(var19_22);
        }
    }

    public static void saveProxy(UserCredentials userCredentials, OutputStream outputStream) {
        try {
            userCredentials.save(outputStream);
        }
        catch (IOException iOException) {
            log.error((Object)("Error saving generated proxy: " + iOException.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)iOException.getMessage(), (Throwable)iOException);
            }
            throw new VOMSException("Error saving generated proxy: " + iOException.getMessage(), iOException);
        }
    }

    public static void saveProxy(UserCredentials userCredentials, String string) throws FileNotFoundException {
        VOMSProxyBuilder.saveProxy(userCredentials, new FileOutputStream(string));
    }
}

