/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.contact;

import org.apache.commons.lang.builder.ToStringBuilder;

public class VOMSServerInfo {
    String hostName;
    int port;
    String hostDn;
    String voName;
    String globusVersion;

    public String getHostDn() {
        return this.hostDn;
    }

    public void setHostDn(String string) {
        this.hostDn = string;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String string) {
        this.hostName = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getVoName() {
        return this.voName;
    }

    public void setVoName(String string) {
        this.voName = string;
    }

    public int getGlobusVersionAsInt() {
        if (this.globusVersion == null) {
            return -1;
        }
        return Integer.parseInt(this.globusVersion) / 10;
    }

    public String getGlobusVersion() {
        return this.globusVersion;
    }

    public void setGlobusVersion(String string) {
        this.globusVersion = string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        VOMSServerInfo vOMSServerInfo = (VOMSServerInfo)object;
        if (this.hostName.equals(vOMSServerInfo.getHostName())) {
            return this.getPort() == vOMSServerInfo.getPort();
        }
        return false;
    }

    public int hashCode() {
        int n = 14;
        n = 29 * n + this.hostName.hashCode();
        n = 29 * n + this.port;
        return n;
    }

    public static VOMSServerInfo fromStringArray(String[] stringArray) {
        VOMSServerInfo vOMSServerInfo = new VOMSServerInfo();
        vOMSServerInfo.setVoName(stringArray[0]);
        vOMSServerInfo.setHostName(stringArray[1]);
        vOMSServerInfo.setPort(Integer.parseInt(stringArray[2]));
        vOMSServerInfo.setHostDn(stringArray[3]);
        if (stringArray.length == 6) {
            vOMSServerInfo.setGlobusVersion(stringArray[5]);
        }
        return vOMSServerInfo;
    }

    public String compactString() {
        return "[vo=" + this.voName + ",host=" + this.hostName + ",port=" + this.port + ",hostDN=" + this.hostDn + ",globusVersion=" + this.globusVersion + "]";
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

