/*
 * Decompiled with CFR 0.152.
 */
package org.globus.common;

public class Version {
    private static String COG_VERSION = "1.7.0";
    public static final int MAJOR;
    public static final int MINOR;
    public static final int PATCH;

    public static String getVersion() {
        return Version.getMajor() + "." + Version.getMinor() + "." + Version.getPatch();
    }

    public static int getMajor() {
        return MAJOR;
    }

    public static int getMinor() {
        return MINOR;
    }

    public static int getPatch() {
        return PATCH;
    }

    public static void main(String[] args) {
        System.out.println("Java CoG version: " + Version.getVersion());
    }

    static {
        int firstDot = COG_VERSION.indexOf(".");
        if (firstDot == -1) {
            throw new IllegalArgumentException("COG version required MAJOR.MINOR.PATCH. It is set as " + COG_VERSION);
        }
        String tmp = COG_VERSION.substring(0, firstDot);
        if (tmp.equals("")) {
            throw new IllegalArgumentException("Number needed after .COG version required MAJOR.MINOR.PATCH. It is set as " + COG_VERSION);
        }
        try {
            MAJOR = Integer.parseInt(tmp);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("COG version numbers are required to be integers" + e.getMessage());
        }
        int secondDot = COG_VERSION.indexOf(".", firstDot + 1);
        if (secondDot == -1) {
            PATCH = 0;
            tmp = COG_VERSION.substring(firstDot + 1, COG_VERSION.length());
            if (tmp.equals("")) {
                throw new IllegalArgumentException("Number needed after . COG version required MAJOR.MINOR.PATCH. It is set as " + COG_VERSION);
            }
            try {
                MINOR = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("COG version numbers are required to be numbers." + e.getMessage());
            }
        }
        try {
            MINOR = Integer.parseInt(COG_VERSION.substring(firstDot + 1, secondDot));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("COG version numbers are required to be numbers." + e.getMessage());
        }
        try {
            PATCH = Integer.parseInt(COG_VERSION.substring(secondDot + 1, COG_VERSION.length()));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("COG version numbers are required to be numbers." + e.getMessage());
        }
    }
}

