/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureList {
    public static final String SIZE = "SIZE";
    public static final String MDTM = "MDTM";
    public static final String PARALLEL = "PARALLEL";
    public static final String ESTO = "ESTO";
    public static final String ERET = "ERET";
    public static final String SBUF = "SBUF";
    public static final String ABUF = "ABUF";
    public static final String DCAU = "DCAU";
    public static final String PIPE = "PIPE";
    public static final String MODEX = "MODEX";
    public static final String GETPUT = "GETPUT";
    public static final String CKSUM = "CKSUM";
    protected final List<Feature> features = new ArrayList<Feature>();

    public FeatureList(String featReplyMsg) {
        StringTokenizer responseTokenizer = new StringTokenizer(featReplyMsg, System.getProperty("line.separator"));
        if (responseTokenizer.hasMoreElements()) {
            responseTokenizer.nextToken();
        }
        while (responseTokenizer.hasMoreElements()) {
            String line = (String)responseTokenizer.nextElement();
            if ((line = line.trim().toUpperCase()).startsWith("211 END")) break;
            String[] splitFeature = line.split(" ");
            if (splitFeature.length == 2) {
                this.features.add(new Feature(splitFeature[0], splitFeature[1]));
                continue;
            }
            this.features.add(new Feature(line));
        }
    }

    public boolean contains(String label) {
        if (label == null) {
            throw new IllegalArgumentException("feature label is null");
        }
        label = label.toUpperCase();
        for (Feature feature : this.features) {
            if (!feature.getLabel().equals(label)) continue;
            return true;
        }
        return false;
    }

    public List<Feature> getFeature(String label) {
        if (label == null) {
            throw new IllegalArgumentException("feature label is null");
        }
        label = label.toUpperCase();
        ArrayList<Feature> foundFeatures = new ArrayList<Feature>();
        for (Feature feature : this.features) {
            if (!feature.getLabel().equals(label)) continue;
            foundFeatures.add(feature);
        }
        return foundFeatures;
    }

    public static final class Feature {
        private final String label;
        private final String parms;

        private Feature(String label) {
            this.label = label;
            this.parms = null;
        }

        private Feature(String label, String parms) {
            this.label = label;
            this.parms = parms;
        }

        public String getLabel() {
            return this.label;
        }

        public String getParms() {
            return this.parms;
        }
    }
}

