/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi;

import java.io.IOException;
import java.security.cert.X509Certificate;
import org.globus.gsi.bc.BouncyCastleUtil;
import org.globus.util.I18n;

public class X509Extension {
    protected boolean critical;
    protected byte[] value;
    protected String oid;
    private static I18n i18n = I18n.getI18n("org.globus.gsi.errors", X509Extension.class.getClassLoader());

    public X509Extension(String oid) {
        this(oid, false, null);
    }

    public X509Extension(String oid, byte[] value) {
        this(oid, false, value);
    }

    public X509Extension(String oid, boolean critical, byte[] value) {
        if (oid == null) {
            throw new IllegalArgumentException(i18n.getMessage("oidNull"));
        }
        this.oid = oid;
        this.critical = critical;
        this.value = value;
    }

    public void setOid(String oid) {
        if (oid == null) {
            throw new IllegalArgumentException(i18n.getMessage("oidNull"));
        }
        this.oid = oid;
    }

    public String getOid() {
        return this.oid;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public byte[] getValue() {
        return this.value;
    }

    public static byte[] getExtensionValue(X509Certificate cert, String oid) throws IOException {
        if (cert == null) {
            throw new IllegalArgumentException(i18n.getMessage("certNull"));
        }
        if (oid == null) {
            throw new IllegalArgumentException(i18n.getMessage("oidNull"));
        }
        byte[] value = cert.getExtensionValue(oid);
        if (value == null) {
            return null;
        }
        return BouncyCastleUtil.getExtensionValue(value);
    }
}

