/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.proxy;

import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.globus.common.ChainedGeneralSecurityException;

public class ProxyPathValidatorException
extends ChainedGeneralSecurityException {
    public static final int FAILURE = -1;
    public static final int PROXY_VIOLATION = 1;
    public static final int UNSUPPORTED_EXTENSION = 2;
    public static final int PATH_LENGTH_EXCEEDED = 3;
    public static final int UNKNOWN_CA = 4;
    public static final int UNKNOWN_POLICY = 5;
    public static final int REVOKED = 6;
    public static final int LIMITED_PROXY_ERROR = 7;
    public static final int EXPIRED_CRL = 8;
    public static final int NO_SIGNING_POLICY_FILE = 9;
    public static final int NO_SIGNING_POLICY = 10;
    public static final int SIGNING_POLICY_VIOLATION = 11;
    private X509Certificate cert;
    private int errorCode = -1;

    public ProxyPathValidatorException(int errorCode) {
        this(errorCode, null);
    }

    public ProxyPathValidatorException(int errorCode, Throwable root) {
        this(errorCode, "", root);
    }

    public ProxyPathValidatorException(int errorCode, String msg, Throwable root) {
        super(msg, root);
        this.errorCode = errorCode;
    }

    public ProxyPathValidatorException(int errorCode, X509Certificate cert, String msg) {
        super(msg, null);
        this.errorCode = errorCode;
        this.cert = cert;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }

    public static String getDateAsString(Date date) {
        TimeZone tz = TimeZone.getTimeZone("GMT");
        SimpleDateFormat df = new SimpleDateFormat("MMM dd HH:mm:ss yyyy z");
        df.setTimeZone(tz);
        return df.format(date);
    }
}

