/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.dc;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ftp.Buffer;
import org.globus.ftp.dc.DataChannelReader;
import org.globus.ftp.dc.EBlockAware;

public class EBlockImageDCReader
extends EBlockAware
implements DataChannelReader {
    boolean eodReceived = false;
    boolean willCloseReceived = false;
    private static Log logger = LogFactory.getLog((String)EBlockImageDCReader.class.getName());
    protected DataInputStream input;

    @Override
    public void setDataStream(InputStream in) {
        this.input = new DataInputStream(in);
    }

    public boolean willCloseReceived() {
        return this.willCloseReceived;
    }

    @Override
    public Buffer read() throws IOException {
        boolean eod;
        if (this.eodReceived) {
            return null;
        }
        if (this.willCloseReceived) {
            return null;
        }
        byte desc = this.input.readByte();
        long size = this.input.readLong();
        long offset = this.input.readLong();
        boolean eof = (desc & 0x40) != 0;
        boolean bl = eod = (desc & 8) != 0;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(desc + " " + size + " " + offset));
        }
        boolean bl2 = this.willCloseReceived = (desc & 4) != 0;
        if (this.willCloseReceived) {
            logger.debug((Object)"Received the CLOSE flag");
        }
        if (eod) {
            this.eodReceived = true;
            this.context.eodTransferred();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Received EOD. Still expecting: " + (this.context.getEodsTotal() == -1 ? "?" : Integer.toString(this.context.eodsTotal - this.context.eodsTransferred))));
            }
        }
        if (eof) {
            this.context.setEodsTotal((int)offset);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Received EODC. Expecting total EODs: " + this.context.getEodsTotal()));
            }
            return null;
        }
        byte[] bt = new byte[(int)size];
        this.input.readFully(bt);
        return new Buffer(bt, (int)size, offset);
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

