/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.dc;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ftp.Buffer;
import org.globus.ftp.dc.DataChannelWriter;
import org.globus.ftp.dc.EBlockAware;
import org.globus.ftp.dc.EBlockParallelTransferContext;

public class EBlockImageDCWriter
extends EBlockAware
implements DataChannelWriter {
    static Log logger = LogFactory.getLog((String)EBlockImageDCWriter.class.getName());
    protected DataOutputStream output;

    @Override
    public void setDataStream(OutputStream out) {
        this.output = new DataOutputStream(out);
    }

    @Override
    public void write(Buffer buf) throws IOException {
        long offset = buf.getOffset();
        if (offset < 0L) {
            throw new IOException("Invalid offset: " + offset);
        }
        this.output.writeByte(0);
        logger.debug((Object)("buffer length: " + buf.getLength()));
        this.output.writeLong(buf.getLength());
        logger.debug((Object)("offset: " + offset));
        this.output.writeLong(offset);
        this.output.write(buf.getBuffer(), 0, buf.getLength());
        logger.debug((Object)"wrote the buffer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endOfData() throws IOException {
        EBlockParallelTransferContext eBlockParallelTransferContext = this.context;
        synchronized (eBlockParallelTransferContext) {
            if (this.context.eodsTransferred == 0) {
                int desc = 72;
                this.output.writeByte(desc);
                this.output.writeLong(0L);
                this.output.writeLong(this.context.eodsTotal);
                logger.debug((Object)("wrote EOF (expected EODS: " + this.context.eodsTotal + ") and EOD"));
            } else {
                int desc = 8;
                this.output.writeByte(desc);
                this.output.writeLong(0L);
                this.output.writeLong(0L);
                logger.debug((Object)"wrote EOD");
            }
            this.context.eodTransferred();
        }
        this.output.flush();
    }

    public static void close(DataOutputStream myOutput) throws IOException {
        int desc = 4;
        myOutput.writeByte(desc);
        myOutput.writeLong(0L);
        myOutput.writeLong(0L);
        logger.debug((Object)"Wrote WILL_CLOSE, closing the socket");
        myOutput.close();
    }

    @Override
    public void close() throws IOException {
        EBlockImageDCWriter.close(this.output);
    }
}

