/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.gssapi;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.ietf.jgss.GSSException;

public class GlobusGSSException
extends GSSException {
    public static final int PROXY_VIOLATION = 5;
    public static final int BAD_ARGUMENT = 7;
    public static final int BAD_NAME = 25;
    public static final int CREDENTIAL_ERROR = 27;
    public static final int TOKEN_FAIL = 29;
    public static final int DELEGATION_ERROR = 30;
    public static final int BAD_MIC = 33;
    public static final int UNKNOWN_OPTION = 37;
    public static final int BAD_OPTION_TYPE = 100;
    public static final int BAD_OPTION = 101;
    public static final int UNKNOWN = 102;
    private static ResourceBundle resources;
    private Throwable exception;

    public GlobusGSSException(int majorCode, Throwable exception) {
        super(majorCode);
        this.exception = exception;
    }

    public GlobusGSSException(int majorCode, int minorCode, String minorString, Throwable exception) {
        super(majorCode, minorCode, minorString);
        this.exception = exception;
    }

    public GlobusGSSException(int majorCode, int minorCode, String key) {
        this(majorCode, minorCode, key, (Object[])null);
    }

    public GlobusGSSException(int majorCode, int minorCode, String key, Object[] args) {
        super(majorCode);
        String msg = null;
        try {
            msg = MessageFormat.format(resources.getString(key), args);
        }
        catch (MissingResourceException e) {
            throw new RuntimeException("bad" + key);
        }
        this.setMinor(minorCode, msg);
        this.exception = null;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream ps) {
        if (this.exception != null) {
            String superString = this.getLocalMessage();
            PrintStream printStream = ps;
            synchronized (printStream) {
                ps.print(superString);
                ps.print(superString.endsWith(".") ? " Caused by " : ". Caused by ");
                this.exception.printStackTrace(ps);
            }
        } else {
            super.printStackTrace(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter pw) {
        if (this.exception != null) {
            String superString = this.getLocalMessage();
            PrintWriter printWriter = pw;
            synchronized (printWriter) {
                pw.print(superString);
                pw.print(superString.endsWith(".") ? " Caused by " : ". Caused by ");
                this.exception.printStackTrace(pw);
            }
        } else {
            super.printStackTrace(pw);
        }
    }

    @Override
    public String getMessage() {
        String answer = super.getMessage();
        if (this.exception != null && this.exception != this) {
            String msg = this.exception.getMessage();
            if (msg == null) {
                msg = this.exception.getClass().getName();
            }
            answer = answer + " [Caused by: " + msg + "]";
        }
        return answer;
    }

    private String getLocalMessage() {
        String message = super.getMessage();
        return message == null ? this.getClass().getName() : message;
    }

    static {
        try {
            resources = ResourceBundle.getBundle("org.globus.gsi.gssapi.errors");
        }
        catch (MissingResourceException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

