/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.gssapi;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class SSLUtil {
    public static int read(InputStream in, byte[] buf, int off, int len) throws IOException {
        int count;
        for (int n = 0; n < len; n += count) {
            count = in.read(buf, off + n, len - n);
            if (count >= 0) continue;
            return count;
        }
        return len;
    }

    public static void readFully(InputStream in, byte[] buf, int off, int len) throws IOException {
        int count;
        for (int n = 0; n < len; n += count) {
            count = in.read(buf, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    public static byte[] readSslMessage(InputStream in) throws IOException {
        byte[] header = new byte[5];
        SSLUtil.readFully(in, header, 0, header.length);
        if (!SSLUtil.isSSLPacket(header)) {
            throw new IOException("Invalid SSL header");
        }
        short length = SSLUtil.toShort(header[3], header[4]);
        byte[] inToken = new byte[header.length + length];
        System.arraycopy(header, 0, inToken, 0, header.length);
        SSLUtil.readFully(in, inToken, header.length, length);
        return inToken;
    }

    public static final boolean isSSLPacket(byte[] header) {
        return SSLUtil.isSSLv3Packet(header) || SSLUtil.isSSLv2HelloPacket(header);
    }

    public static final boolean isSSLv3Packet(byte[] header) {
        return header[0] >= 20 && header[0] <= 26 && (header[1] == 3 && (header[2] == 0 || header[2] == 1) || header[1] == 2 && header[2] == 0);
    }

    public static final boolean isSSLv2HelloPacket(byte[] header) {
        return (header[0] & 0x80) != 0 && (header[2] == 1 || header[2] == 4);
    }

    public static short toShort(byte a, byte b) {
        return (short)(a << 8 | b & 0xFF);
    }

    public static int toUnsignedShort(byte a, byte b) {
        return (a & 0xFF) << 8 | b & 0xFF;
    }

    public static int toInt(byte[] buf, int off) {
        int lg = (buf[off] & 0xFF) << 24;
        lg |= (buf[off + 1] & 0xFF) << 16;
        lg |= (buf[off + 2] & 0xFF) << 8;
        return lg |= buf[off + 3] & 0xFF;
    }

    public static void writeInt(int v, byte[] buf, int off) {
        buf[off] = (byte)(v >>> 24 & 0xFF);
        buf[off + 1] = (byte)(v >>> 16 & 0xFF);
        buf[off + 2] = (byte)(v >>> 8 & 0xFF);
        buf[off + 3] = (byte)(v >>> 0 & 0xFF);
    }

    public static long toLong(byte[] buf, int off) {
        return ((long)SSLUtil.toInt(buf, off) << 32) + ((long)SSLUtil.toInt(buf, off + 4) & 0xFFFFFFFFL);
    }
}

