/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.gssapi.net.impl;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.globus.gsi.gssapi.SSLUtil;
import org.globus.gsi.gssapi.net.GssInputStream;
import org.ietf.jgss.GSSContext;

public class GSIGssInputStream
extends GssInputStream {
    private static final int MAX_LEN = 0x2000000;
    protected byte[] header = new byte[5];
    protected int mode = -1;
    boolean enc = false;

    public GSIGssInputStream(InputStream in, GSSContext context) {
        super(in, context);
    }

    @Override
    protected void readMsg() throws IOException {
        byte[] token = this.readToken();
        this.buff = (byte[])(token == null ? null : this.unwrap(token));
        this.index = 0;
    }

    public int getWrapMode() {
        return this.mode;
    }

    public byte[] readHandshakeToken() throws IOException {
        byte[] token = this.readToken();
        if (token == null) {
            throw new EOFException();
        }
        return token;
    }

    protected byte[] readToken() throws IOException {
        byte[] buf = null;
        if (SSLUtil.read(this.in, this.header, 0, this.header.length - 1) < 0) {
            return null;
        }
        if (SSLUtil.isSSLv3Packet(this.header)) {
            this.mode = 1;
            if (SSLUtil.read(this.in, this.header, 4, 1) < 0) {
                return null;
            }
            int len = SSLUtil.toUnsignedShort(this.header[3], this.header[4]);
            buf = new byte[this.header.length + len];
            System.arraycopy(this.header, 0, buf, 0, this.header.length);
            if (SSLUtil.read(this.in, buf, this.header.length, len) < 0) {
                return null;
            }
            switch (this.header[0]) {
                case 22: {
                    if (this.enc || buf[this.header.length] != 11) break;
                    int flen = SSLUtil.toInt(buf, this.header.length) & 0xFFFFFF;
                    int alreadyRead = len;
                    int bytesToRead = flen - alreadyRead + 4;
                    byte[] certs = new byte[buf.length + bytesToRead];
                    System.arraycopy(buf, 0, certs, 0, buf.length);
                    if (SSLUtil.read(this.in, certs, buf.length, bytesToRead) < 0) {
                        return null;
                    }
                    buf = certs;
                    break;
                }
                case 20: {
                    this.enc = true;
                    break;
                }
            }
        } else if (SSLUtil.isSSLv2HelloPacket(this.header)) {
            this.mode = 1;
            int len = ((this.header[0] & 0x7F) << 8 | this.header[1] & 0xFF) - 2;
            buf = new byte[this.header.length - 1 + len];
            System.arraycopy(this.header, 0, buf, 0, this.header.length - 1);
            if (SSLUtil.read(this.in, buf, this.header.length - 1, len) < 0) {
                return null;
            }
        } else {
            this.mode = 2;
            int len = SSLUtil.toInt(this.header, 0);
            if (len > 0x2000000) {
                throw new IOException("Token length " + len + " > " + 0x2000000);
            }
            if (len < 0) {
                throw new IOException("Token length " + len + " < 0");
            }
            buf = new byte[len];
            if (SSLUtil.read(this.in, buf, 0, buf.length) < 0) {
                return null;
            }
        }
        return buf;
    }
}

