/*
 * Decompiled with CFR 0.152.
 */
package org.globus.io.gass.server;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gram.GramJob;
import org.globus.gram.GramJobListener;
import org.globus.io.gass.server.RemoteGassServer;

class GassServerListener
implements GramJobListener {
    private static Log logger = LogFactory.getLog((String)RemoteGassServer.class.getName());
    private int status = -1;
    private int error = 0;

    GassServerListener() {
    }

    public int getError() {
        return this.error;
    }

    public static boolean isStartState(int status) {
        return status == 2 || status == 4 || status == 8;
    }

    public synchronized void reset() {
        this.error = 0;
        this.status = -1;
    }

    public synchronized int waitFor(int timeout) throws InterruptedException {
        while (!GassServerListener.isStartState(this.status)) {
            this.wait(timeout);
            if (this.status != -1) continue;
            break;
        }
        return this.status;
    }

    @Override
    public synchronized void statusChanged(GramJob job) {
        int st = job.getStatus();
        logger.debug((Object)("Gass job status: " + st));
        if (this.status == -1 && GassServerListener.isStartState(st)) {
            this.status = st;
            this.error = job.getError();
            this.notify();
        }
    }
}

