/*
 * Decompiled with CFR 0.152.
 */
package org.globus.io.urlcopy;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ftp.DataChannelAuthentication;
import org.globus.ftp.FTPClient;
import org.globus.ftp.GridFTPClient;
import org.globus.ftp.exception.FTPException;
import org.globus.gsi.gssapi.auth.Authorization;
import org.globus.gsi.gssapi.auth.HostAuthorization;
import org.globus.gsi.gssapi.auth.SelfAuthorization;
import org.globus.io.streams.FTPInputStream;
import org.globus.io.streams.FTPOutputStream;
import org.globus.io.streams.GassInputStream;
import org.globus.io.streams.GassOutputStream;
import org.globus.io.streams.GlobusFileInputStream;
import org.globus.io.streams.GlobusFileOutputStream;
import org.globus.io.streams.GlobusInputStream;
import org.globus.io.streams.GlobusOutputStream;
import org.globus.io.streams.GridFTPInputStream;
import org.globus.io.streams.GridFTPOutputStream;
import org.globus.io.streams.HTTPInputStream;
import org.globus.io.streams.HTTPOutputStream;
import org.globus.io.urlcopy.UrlCopyException;
import org.globus.io.urlcopy.UrlCopyListener;
import org.globus.util.GlobusURL;
import org.ietf.jgss.GSSCredential;

public class UrlCopy
implements Runnable {
    private static Log logger = LogFactory.getLog((String)UrlCopy.class.getName());
    public static final int BUFF_SIZE = 2048;
    protected int bufferSize = 2048;
    protected GSSCredential srcCreds = null;
    protected Authorization srcAuth = null;
    protected GSSCredential dstCreds = null;
    protected Authorization dstAuth = null;
    protected boolean dcau = true;
    protected boolean appendMode = false;
    protected GlobusURL srcUrl = null;
    protected GlobusURL dstUrl = null;
    protected boolean canceled = false;
    protected boolean thirdParty = true;
    protected boolean gridftp2 = true;
    protected List listeners = null;
    protected long sourceOffset = 0L;
    protected long destinationOffset = 0L;
    protected long sourceLength = Long.MAX_VALUE;
    protected int tcpBufferSize = 0;
    protected boolean disableAllo = false;

    public void setDCAU(boolean dcau) {
        this.dcau = dcau;
    }

    public boolean getDCAU() {
        return this.dcau;
    }

    public void setCredentials(GSSCredential credentials) {
        this.setSourceCredentials(credentials);
        this.setDestinationCredentials(credentials);
    }

    public void setSourceCredentials(GSSCredential srcCredentials) {
        this.srcCreds = srcCredentials;
    }

    public void setDestinationCredentials(GSSCredential dstCredentials) {
        this.dstCreds = dstCredentials;
    }

    public void setSourceAuthorization(Authorization auth) {
        this.srcAuth = auth;
    }

    public void setDestinationAuthorization(Authorization auth) {
        this.dstAuth = auth;
    }

    public GSSCredential getSourceCredentials() {
        return this.srcCreds;
    }

    public GSSCredential getDestinationCredentials() {
        return this.dstCreds;
    }

    public Authorization getSourceAuthorization() {
        return this.srcAuth;
    }

    public Authorization getDestinationAuthorization() {
        return this.dstAuth;
    }

    public void addUrlCopyListener(UrlCopyListener listener) {
        if (this.listeners == null) {
            this.listeners = new LinkedList();
        }
        this.listeners.add(listener);
    }

    public void removeUrlCopyListener(UrlCopyListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setTCPBufferSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("The TCP buffer size must be a positive");
        }
        this.tcpBufferSize = size;
    }

    public int getTCPBufferSize() {
        return this.tcpBufferSize;
    }

    public void setAppendMode(boolean appendMode) {
        this.appendMode = appendMode;
    }

    public boolean isAppendMode() {
        return this.appendMode;
    }

    public long getDestinationOffset() {
        return this.destinationOffset;
    }

    public void setDestinationOffset(long destinationOffset) {
        this.destinationOffset = destinationOffset;
    }

    public long getSourceLength() {
        return this.sourceLength;
    }

    public void setSourceFileLength(long sourceLength) {
        this.sourceLength = sourceLength;
    }

    public long getSourceOffset() {
        return this.sourceOffset;
    }

    public void setSourceFileOffset(long sourceOffset) {
        this.sourceOffset = sourceOffset;
    }

    private void checkUrl(GlobusURL url) throws UrlCopyException {
        String urlPath = url.getPath();
        if (urlPath == null || urlPath.length() == 0) {
            throw new UrlCopyException("The '" + url.getURL() + "' url does not specify the file location.");
        }
    }

    public void setSourceUrl(GlobusURL source) throws UrlCopyException {
        if (source == null) {
            throw new IllegalArgumentException("Source url cannot be null");
        }
        this.checkUrl(source);
        this.srcUrl = source;
    }

    public GlobusURL getSourceUrl() {
        return this.srcUrl;
    }

    public void setDestinationUrl(GlobusURL dest) throws UrlCopyException {
        if (dest == null) {
            throw new IllegalArgumentException("Desitination url cannot be null");
        }
        this.checkUrl(dest);
        this.dstUrl = dest;
    }

    public GlobusURL getDestinationUrl() {
        return this.dstUrl;
    }

    public void setUseThirdPartyCopy(boolean thirdParty) {
        this.thirdParty = thirdParty;
    }

    public boolean getDisableAllo() {
        return this.disableAllo;
    }

    public void setDisableAllo(boolean disableAllo) {
        this.disableAllo = disableAllo;
    }

    public void setGridFTP2(boolean gridftp2) {
        this.gridftp2 = gridftp2;
    }

    public boolean getGridFTP2() {
        return this.gridftp2;
    }

    public void cancel() {
        this.canceled = true;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block9: {
            try {
                this.copy();
            }
            catch (Exception e) {
                if (this.listeners != null) {
                    Iterator iter = this.listeners.iterator();
                    while (iter.hasNext()) {
                        ((UrlCopyListener)iter.next()).transferError(e);
                    }
                }
            }
            finally {
                if (this.listeners == null) break block9;
                Iterator iter = this.listeners.iterator();
                while (iter.hasNext()) {
                    ((UrlCopyListener)iter.next()).transferCompleted();
                }
            }
        }
    }

    public void copy() throws UrlCopyException {
        if (this.srcUrl == null) {
            throw new UrlCopyException("Source url is not specified");
        }
        if (this.dstUrl == null) {
            throw new UrlCopyException("Destination url is not specified");
        }
        String fromP = this.srcUrl.getProtocol();
        String toP = this.dstUrl.getProtocol();
        if (this.thirdParty && fromP.endsWith("ftp") && toP.endsWith("ftp")) {
            this.thirdPartyTransfer();
            return;
        }
        GlobusInputStream in = null;
        GlobusOutputStream out = null;
        boolean rs = false;
        try {
            in = this.getInputStream();
            long size = in.getSize();
            if (size == -1L) {
                logger.debug((Object)"Source size: unknown");
            } else {
                logger.debug((Object)("Source size: " + size));
            }
            out = this.getOutputStream(size);
            rs = this.transfer(size, in, out);
            in.close();
            out.close();
        }
        catch (Exception e) {
            if (out != null) {
                out.abort();
            }
            if (in != null) {
                in.abort();
            }
            throw new UrlCopyException("UrlCopy transfer failed.", e);
        }
        if (!rs && this.isCanceled()) {
            throw new UrlCopyException("Transfer Aborted");
        }
    }

    protected GlobusInputStream getInputStream() throws Exception {
        GlobusInputStream in = null;
        String fromP = this.srcUrl.getProtocol();
        String fromFile = this.srcUrl.getPath();
        if (fromP.equalsIgnoreCase("file")) {
            fromFile = URLDecoder.decode(fromFile);
            in = new GlobusFileInputStream(fromFile);
        } else if (fromP.equalsIgnoreCase("ftp")) {
            fromFile = URLDecoder.decode(fromFile);
            in = new FTPInputStream(this.srcUrl.getHost(), this.srcUrl.getPort(), this.srcUrl.getUser(), this.srcUrl.getPwd(), fromFile);
        } else if (fromP.equalsIgnoreCase("gsiftp") || fromP.equalsIgnoreCase("gridftp")) {
            Authorization auth = this.getSourceAuthorization();
            if (auth == null) {
                auth = HostAuthorization.getInstance();
            }
            fromFile = URLDecoder.decode(fromFile);
            in = new GridFTPInputStream(this.getSourceCredentials(), auth, this.srcUrl.getHost(), this.srcUrl.getPort(), fromFile, this.getDCAU(), this.getGridFTP2());
        } else if (fromP.equalsIgnoreCase("https")) {
            Authorization auth = this.getSourceAuthorization();
            if (auth == null) {
                auth = SelfAuthorization.getInstance();
            }
            in = new GassInputStream(this.getSourceCredentials(), auth, this.srcUrl.getHost(), this.srcUrl.getPort(), fromFile);
        } else if (fromP.equalsIgnoreCase("http")) {
            in = new HTTPInputStream(this.srcUrl.getHost(), this.srcUrl.getPort(), fromFile);
        } else {
            throw new Exception("Source protocol: " + fromP + " not supported!");
        }
        return in;
    }

    protected GlobusOutputStream getOutputStream(long size) throws Exception {
        GlobusOutputStream out = null;
        String toP = this.dstUrl.getProtocol();
        String toFile = this.dstUrl.getPath();
        if (toP.equalsIgnoreCase("file")) {
            toFile = URLDecoder.decode(toFile);
            out = new GlobusFileOutputStream(toFile, this.appendMode);
        } else if (toP.equalsIgnoreCase("ftp")) {
            toFile = URLDecoder.decode(toFile);
            out = new FTPOutputStream(this.dstUrl.getHost(), this.dstUrl.getPort(), this.dstUrl.getUser(), this.dstUrl.getPwd(), toFile, this.appendMode);
        } else if (toP.equalsIgnoreCase("gsiftp") || toP.equalsIgnoreCase("gridftp")) {
            Authorization auth = this.getDestinationAuthorization();
            if (auth == null) {
                auth = HostAuthorization.getInstance();
            }
            toFile = URLDecoder.decode(toFile);
            out = new GridFTPOutputStream(this.getDestinationCredentials(), auth, this.dstUrl.getHost(), this.dstUrl.getPort(), toFile, this.appendMode, this.getDCAU(), this.getGridFTP2(), this.disableAllo ? -1L : size);
        } else if (toP.equalsIgnoreCase("https")) {
            Authorization auth = this.getDestinationAuthorization();
            if (auth == null) {
                auth = SelfAuthorization.getInstance();
            }
            out = new GassOutputStream(this.getDestinationCredentials(), auth, this.dstUrl.getHost(), this.dstUrl.getPort(), toFile, size, this.appendMode);
        } else if (toP.equalsIgnoreCase("http")) {
            out = new HTTPOutputStream(this.dstUrl.getHost(), this.dstUrl.getPort(), toFile, size, this.appendMode);
        } else {
            throw new Exception("Destination protocol: " + toP + " not supported!");
        }
        return out;
    }

    private boolean transfer(long total, GlobusInputStream in, GlobusOutputStream out) throws IOException {
        byte[] buffer = new byte[this.bufferSize];
        int bytes = 0;
        long totalBytes = total;
        long transferedBytes = 0L;
        if (total == -1L) {
            while ((bytes = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytes);
                out.flush();
                if (this.listeners != null) {
                    this.fireUrlTransferProgressEvent(totalBytes, transferedBytes += (long)bytes);
                }
                if (!this.isCanceled()) continue;
                return false;
            }
        } else {
            while (total != 0L) {
                bytes = this.bufferSize;
                if (total < (long)this.bufferSize) {
                    bytes = (int)total;
                }
                bytes = in.read(buffer);
                out.write(buffer, 0, bytes);
                out.flush();
                total -= (long)bytes;
                if (this.listeners != null) {
                    this.fireUrlTransferProgressEvent(totalBytes, transferedBytes += (long)bytes);
                }
                if (!this.isCanceled()) continue;
                return false;
            }
        }
        return true;
    }

    private void fireUrlTransferProgressEvent(long totalBytes, long transferedBytes) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((UrlCopyListener)iter.next()).transfer(transferedBytes, totalBytes);
        }
    }

    private void thirdPartyTransfer() throws UrlCopyException {
        block20: {
            logger.debug((Object)"Trying third party transfer...");
            FTPClient srcFTP = null;
            FTPClient dstFTP = null;
            try {
                srcFTP = this.createFTPConnection(this.srcUrl, true);
                dstFTP = this.createFTPConnection(this.dstUrl, false);
                this.negotiateDCAU(srcFTP, dstFTP);
                srcFTP.setType(1);
                dstFTP.setType(1);
                if (this.listeners != null) {
                    this.fireUrlTransferProgressEvent(-1L, -1L);
                }
                if (this.sourceOffset == 0L && this.destinationOffset == 0L && this.sourceLength == Long.MAX_VALUE) {
                    if (this.gridftp2) {
                        FTPClient.transfer(srcFTP, this.srcUrl.getPath(), dstFTP, this.dstUrl.getPath(), 1, null);
                    } else {
                        srcFTP.setMode(1);
                        dstFTP.setMode(1);
                        srcFTP.transfer(this.srcUrl.getPath(), dstFTP, this.dstUrl.getPath(), false, null);
                    }
                    break block20;
                }
                if (srcFTP instanceof GridFTPClient && dstFTP instanceof GridFTPClient) {
                    GridFTPClient srcGridFTP = (GridFTPClient)srcFTP;
                    GridFTPClient dstGridFTP = (GridFTPClient)dstFTP;
                    srcGridFTP.setMode(3);
                    dstGridFTP.setMode(3);
                    srcGridFTP.extendedTransfer(this.srcUrl.getPath(), this.sourceOffset, this.sourceLength, dstGridFTP, this.dstUrl.getPath(), this.destinationOffset, null);
                    break block20;
                }
                throw new UrlCopyException("Partial 3rd party transfers not supported by FTP client. Use GridFTP for both source and destination.");
            }
            catch (Exception e) {
                throw new UrlCopyException("UrlCopy third party transfer failed.", e);
            }
            finally {
                if (srcFTP != null) {
                    try {
                        srcFTP.close();
                    }
                    catch (Exception ee) {}
                }
                if (dstFTP != null) {
                    try {
                        dstFTP.close();
                    }
                    catch (Exception ee) {}
                }
            }
        }
    }

    protected void negotiateDCAU(FTPClient src, FTPClient dst) throws IOException, FTPException {
        if (src instanceof GridFTPClient) {
            if (dst instanceof GridFTPClient) {
                GridFTPClient s = (GridFTPClient)src;
                GridFTPClient d = (GridFTPClient)dst;
                if (src.isFeatureSupported("DCAU") && dst.isFeatureSupported("DCAU")) {
                    UrlCopy.setDCAU(s, this.getDCAU());
                    UrlCopy.setDCAU(d, this.getDCAU());
                } else {
                    UrlCopy.setDCAU(s, false);
                    UrlCopy.setDCAU(d, false);
                    this.setDCAU(false);
                }
            } else {
                UrlCopy.setDCAU((GridFTPClient)src, false);
                this.setDCAU(false);
            }
        } else {
            if (dst instanceof GridFTPClient) {
                UrlCopy.setDCAU((GridFTPClient)dst, false);
            }
            this.setDCAU(false);
        }
    }

    private static void setDCAU(GridFTPClient c, boolean dcau) throws IOException, FTPException {
        if (c.isFeatureSupported("DCAU")) {
            if (!dcau) {
                c.setDataChannelAuthentication(DataChannelAuthentication.NONE);
            }
        } else if (dcau) {
            throw new IOException("DCAU not supported but DCAU requested");
        }
    }

    private FTPClient createFTPConnection(GlobusURL ftpURL, boolean srcSide) throws Exception {
        String protocol = ftpURL.getProtocol();
        if (protocol.equalsIgnoreCase("ftp")) {
            FTPClient ftp = new FTPClient(ftpURL.getHost(), ftpURL.getPort());
            ftp.authorize(ftpURL.getUser(), ftpURL.getPwd());
            return ftp;
        }
        GridFTPClient ftp = new GridFTPClient(ftpURL.getHost(), ftpURL.getPort());
        if (srcSide) {
            Authorization auth = this.getSourceAuthorization();
            if (auth == null) {
                auth = HostAuthorization.getInstance();
            }
            ftp.setAuthorization(auth);
            ftp.authenticate(this.getSourceCredentials());
        } else {
            Authorization auth = this.getDestinationAuthorization();
            if (auth == null) {
                auth = HostAuthorization.getInstance();
            }
            ftp.setAuthorization(auth);
            ftp.authenticate(this.getDestinationCredentials());
        }
        if (this.tcpBufferSize != 0) {
            ftp.setTCPBufferSize(this.tcpBufferSize);
        }
        return ftp;
    }
}

