/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tools.ui.proxy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.globus.util.ConfigUtil;

public class GridProxyProperties {
    private static final String PROPS_FILE = "cog.properties";
    private static final String gridPropsFile = ConfigUtil.globus_dir + "cog.properties";
    private int hours = 24;
    private int bits = 512;
    private boolean limited = false;
    private String userCertFile = ConfigUtil.discoverUserCertLocation();
    private String userKeyFile = ConfigUtil.discoverUserKeyLocation();
    private String CACertFile = ConfigUtil.discoverCertDirLocation();
    private String proxyFile = ConfigUtil.discoverProxyLocation();
    private int credLifetime = 168;
    private int portalLifetime = 2;
    private String myproxyServer = "localhost";
    private int myproxyPort = 7512;
    private Properties properties = null;

    public GridProxyProperties() {
        if (this.hasProperties()) {
            this.loadProperties();
        }
    }

    public void setHours(int hours) {
        this.hours = hours;
    }

    public int getHours() {
        return this.hours;
    }

    public void setBits(int bits) {
        this.bits = bits;
    }

    public int getBits() {
        return this.bits;
    }

    public void setLimited(boolean limited) {
        this.limited = limited;
    }

    public boolean getLimited() {
        return this.limited;
    }

    public void setProxyFile(String proxyFile) {
        this.proxyFile = proxyFile;
    }

    public String getProxyFile() {
        return this.proxyFile;
    }

    public void setUserCertFile(String userCertFile) {
        this.userCertFile = userCertFile;
    }

    public String getUserCertFile() {
        return this.userCertFile;
    }

    public void setUserKeyFile(String userKeyFile) {
        this.userKeyFile = userKeyFile;
    }

    public String getUserKeyFile() {
        return this.userKeyFile;
    }

    public void setCACertFile(String CACertFile) {
        this.CACertFile = CACertFile;
    }

    public String getCACertFile() {
        return this.CACertFile;
    }

    public void setPortalLifetime(int portalLifetime) {
        this.portalLifetime = portalLifetime;
    }

    public int getPortalLifetime() {
        return this.portalLifetime;
    }

    public void setCredLifetime(int credLifetime) {
        this.credLifetime = credLifetime;
    }

    public int getCredLifetime() {
        return this.credLifetime;
    }

    public void setMyproxyServer(String myproxyServer) {
        this.myproxyServer = myproxyServer;
    }

    public String getMyproxyServer() {
        return this.myproxyServer;
    }

    public void setMyproxyPort(int myproxyPort) {
        this.myproxyPort = myproxyPort;
    }

    public int getMyproxyPort() {
        return this.myproxyPort;
    }

    public boolean hasProperties() {
        File pfile = new File(gridPropsFile);
        return pfile.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProperties() {
        Properties props = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(gridPropsFile);
            props.load(in);
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("loadGridProxyProperties: FileNotFoundException");
        }
        catch (IOException ioe) {
            System.err.println("loadGridProxyProperties: IOException error");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        this.properties = props;
        this.hours = GridProxyProperties.getIntValue(props, "proxy.lifetime", 24);
        this.bits = GridProxyProperties.getIntValue(props, "proxy.strength", 512);
        this.limited = Boolean.valueOf(props.getProperty("limited"));
        this.userCertFile = GridProxyProperties.getStrValue(props, "usercert", ConfigUtil.discoverUserCertLocation());
        this.userKeyFile = GridProxyProperties.getStrValue(props, "userkey", ConfigUtil.discoverUserKeyLocation());
        this.proxyFile = GridProxyProperties.getStrValue(props, "proxy", ConfigUtil.discoverProxyLocation());
        this.CACertFile = GridProxyProperties.getStrValue(props, "cacert", ConfigUtil.discoverCertDirLocation());
        this.credLifetime = GridProxyProperties.getIntValue(props, "cred_lifetime", 168);
        this.portalLifetime = GridProxyProperties.getIntValue(props, "portal_lifetime", 2);
        this.myproxyServer = GridProxyProperties.getStrValue(props, "myproxy_server", "localhost");
        this.myproxyPort = GridProxyProperties.getIntValue(props, "myproxy_port", 7512);
    }

    private static String getStrValue(Properties props, String prop, String defaultValue) {
        String value = props.getProperty(prop);
        if (value != null && value.trim().length() > 0) {
            return value.trim();
        }
        return defaultValue;
    }

    private static int getIntValue(Properties props, String prop, int defaultValue) {
        String value = props.getProperty(prop);
        if (value != null && value.trim().length() > 0) {
            return Integer.parseInt(value.trim());
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveProperties() {
        Properties props = this.properties == null ? new Properties() : this.properties;
        props.setProperty("proxy.lifetime", String.valueOf(this.hours));
        props.setProperty("proxy.strength", String.valueOf(this.bits));
        props.setProperty("limited", String.valueOf(this.limited));
        props.setProperty("usercert", this.userCertFile);
        props.setProperty("userkey", this.userKeyFile);
        props.setProperty("proxy", this.proxyFile);
        props.setProperty("cacert", this.CACertFile);
        props.setProperty("cred_lifetime", String.valueOf(this.credLifetime));
        props.setProperty("portal_lifetime", String.valueOf(this.portalLifetime));
        props.setProperty("myproxy_server", this.myproxyServer);
        props.setProperty("myproxy_port", String.valueOf(this.myproxyPort));
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(gridPropsFile);
            props.store(out, "GridProxyInit properties");
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("saveGridProxyProperties: FileNotFoundException");
            boolean bl = false;
            return bl;
        }
        catch (IOException ioe) {
            System.err.println("saveGridProxyProperties: IOException");
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
        return true;
    }
}

