/*
 * Decompiled with CFR 0.152.
 */
package org.globus.net.protocol.httpg;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

public class Handler
extends URLStreamHandler {
    private static final String CLASS = "org.globus.net.GSIHttpURLConnection";
    private static final Class[] PARAMS = new Class[]{URL.class};
    private static Constructor constructor = null;

    private static synchronized Constructor initConstructor() {
        if (constructor == null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> clazz = Class.forName(CLASS, true, loader);
                constructor = clazz.getConstructor(PARAMS);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to load url handler: " + e.getMessage());
            }
        }
        return constructor;
    }

    @Override
    protected URLConnection openConnection(URL u) {
        if (constructor == null) {
            Handler.initConstructor();
        }
        try {
            return (URLConnection)constructor.newInstance(u);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate url handler: " + e.getMessage());
        }
    }

    @Override
    protected int getDefaultPort() {
        return 8443;
    }

    @Override
    protected void setURL(URL u, String protocol, String host, int port, String authority, String userInfo, String path, String query, String ref) {
        if (port == -1) {
            port = this.getDefaultPort();
        }
        super.setURL(u, protocol, host, port, authority, userInfo, path, query, ref);
    }
}

