/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.nativeimage;

import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public interface Feature {
    default public boolean isInConfiguration(IsInConfigurationAccess access) {
        return true;
    }

    default public List<Class<? extends Feature>> getRequiredFeatures() {
        return Collections.emptyList();
    }

    default public void afterRegistration(AfterRegistrationAccess access) {
    }

    default public void duringSetup(DuringSetupAccess access) {
    }

    default public void beforeAnalysis(BeforeAnalysisAccess access) {
    }

    default public void duringAnalysis(DuringAnalysisAccess access) {
    }

    default public void afterAnalysis(AfterAnalysisAccess access) {
    }

    default public void onAnalysisExit(OnAnalysisExitAccess access) {
    }

    default public void beforeCompilation(BeforeCompilationAccess access) {
    }

    default public void afterCompilation(AfterCompilationAccess access) {
    }

    default public void afterHeapLayout(AfterHeapLayoutAccess access) {
    }

    default public void beforeImageWrite(BeforeImageWriteAccess access) {
    }

    default public void afterImageWrite(AfterImageWriteAccess access) {
    }

    default public void cleanup() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static interface AfterImageWriteAccess
    extends FeatureAccess {
        public Path getImagePath();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static interface BeforeImageWriteAccess
    extends FeatureAccess {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static interface AfterHeapLayoutAccess
    extends FeatureAccess {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static interface AfterCompilationAccess
    extends CompilationAccess {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static interface BeforeCompilationAccess
    extends CompilationAccess {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static interface CompilationAccess
    extends FeatureAccess {
        public long objectFieldOffset(Field var1);

        public void registerAsImmutable(Object var1);

        public void registerAsImmutable(Object var1, Predicate<Object> var2);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static interface OnAnalysisExitAccess
    extends FeatureAccess {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static interface AfterAnalysisAccess
    extends FeatureAccess {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static interface DuringAnalysisAccess
    extends BeforeAnalysisAccess {
        public void requireAnalysisIteration();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static interface BeforeAnalysisAccess
    extends FeatureAccess {
        public void registerAsUsed(Class<?> var1);

        public void registerAsInHeap(Class<?> var1);

        public void registerAsAccessed(Field var1);

        public void registerAsUnsafeWritten(Field var1);

        public void registerForReflectiveInstantiation(Class<?> var1);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static interface DuringSetupAccess
    extends FeatureAccess {
        public void registerObjectReplacer(Function<Object, Object> var1);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static interface AfterRegistrationAccess
    extends FeatureAccess {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static interface IsInConfigurationAccess
    extends FeatureAccess {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static interface FeatureAccess {
        public Class<?> findClassByName(String var1);
    }
}

