/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.word;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.graalvm.word.PointerBase;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public abstract class WordFactory {
    protected static BoxFactory boxFactory;

    protected WordFactory() {
    }

    @FactoryOperation(opcode=FactoryOpcode.ZERO)
    public static <T extends WordBase> T zero() {
        return boxFactory.box(0L);
    }

    @FactoryOperation(opcode=FactoryOpcode.ZERO)
    public static <T extends PointerBase> T nullPointer() {
        return (T)((PointerBase)boxFactory.box(0L));
    }

    @FactoryOperation(opcode=FactoryOpcode.FROM_UNSIGNED)
    public static <T extends UnsignedWord> T unsigned(long val) {
        return (T)((UnsignedWord)boxFactory.box(val));
    }

    @FactoryOperation(opcode=FactoryOpcode.FROM_UNSIGNED)
    public static <T extends PointerBase> T pointer(long val) {
        return (T)((PointerBase)boxFactory.box(val));
    }

    @FactoryOperation(opcode=FactoryOpcode.FROM_UNSIGNED)
    public static <T extends UnsignedWord> T unsigned(int val) {
        return (T)((UnsignedWord)boxFactory.box((long)val & 0xFFFFFFFFL));
    }

    @FactoryOperation(opcode=FactoryOpcode.FROM_SIGNED)
    public static <T extends SignedWord> T signed(long val) {
        return (T)((SignedWord)boxFactory.box(val));
    }

    @FactoryOperation(opcode=FactoryOpcode.FROM_SIGNED)
    public static <T extends SignedWord> T signed(int val) {
        return (T)((SignedWord)boxFactory.box(val));
    }

    protected static interface BoxFactory {
        public <T extends WordBase> T box(long var1);
    }

    protected static enum FactoryOpcode {
        ZERO,
        FROM_UNSIGNED,
        FROM_SIGNED;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    protected static @interface FactoryOperation {
        public FactoryOpcode opcode();
    }
}

