/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.SetPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.helper.JSCollectionsNormalizeNode;
import com.oracle.truffle.js.builtins.helper.JSCollectionsNormalizeNodeGen;
import com.oracle.truffle.js.nodes.access.GetIteratorFromMethodNode;
import com.oracle.truffle.js.nodes.access.GetSetRecordNode;
import com.oracle.truffle.js.nodes.access.IteratorCloseNode;
import com.oracle.truffle.js.nodes.access.IteratorStepNode;
import com.oracle.truffle.js.nodes.access.IteratorValueNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSSet;
import com.oracle.truffle.js.runtime.builtins.JSSetIterator;
import com.oracle.truffle.js.runtime.builtins.JSSetObject;
import com.oracle.truffle.js.runtime.builtins.SetRecord;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.JSHashMap;

public final class SetPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<SetPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new SetPrototypeBuiltins();
    public static final JSBuiltinsContainer NEW_SET_BUILTINS = new NewSetPrototypeBuiltins();

    protected SetPrototypeBuiltins() {
        super(JSSet.PROTOTYPE_NAME, SetPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, SetPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return SetPrototypeBuiltinsFactory.JSSetClearNodeGen.create(context, builtin, SetPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 1: {
                return SetPrototypeBuiltinsFactory.JSSetDeleteNodeGen.create(context, builtin, SetPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 2: {
                return SetPrototypeBuiltinsFactory.JSSetAddNodeGen.create(context, builtin, SetPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 3: {
                return SetPrototypeBuiltinsFactory.JSSetHasNodeGen.create(context, builtin, SetPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 4: {
                return SetPrototypeBuiltinsFactory.JSSetForEachNodeGen.create(context, builtin, SetPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 5: {
                return SetPrototypeBuiltinsFactory.CreateSetIteratorNodeGen.create(context, builtin, 2, SetPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 6: {
                return SetPrototypeBuiltinsFactory.CreateSetIteratorNodeGen.create(context, builtin, 3, SetPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 7: {
                return SetPrototypeBuiltinsFactory.SetGetSizeNodeGen.create(context, builtin, SetPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum SetPrototype implements BuiltinEnum<SetPrototype>
    {
        clear(0),
        delete(1),
        add(1),
        has(1),
        forEach(1),
        values(0),
        entries(0),
        size(0);

        private final int length;

        private SetPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isGetter() {
            return this == size;
        }
    }

    public static abstract class JSSetClearNode
    extends JSBuiltinNode {
        public JSSetClearNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected static JSDynamicObject clear(JSSetObject thisObj) {
            JSSet.getInternalSet(thisObj).clear();
            return Undefined.instance;
        }

        @Specialization(guards={"!isJSSet(thisObj)"})
        protected static JSDynamicObject notSet(Object thisObj) {
            throw Errors.createTypeErrorSetExpected();
        }
    }

    public static abstract class JSSetDeleteNode
    extends JSSetOperation {
        public JSSetDeleteNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean delete(JSSetObject thisObj, Object key) {
            Object normalizedKey = this.normalize(key);
            return JSSet.getInternalSet(thisObj).remove(normalizedKey);
        }

        @Specialization(guards={"!isJSSet(thisObj)"})
        protected static boolean notSet(Object thisObj, Object key) {
            throw Errors.createTypeErrorSetExpected();
        }
    }

    public static abstract class JSSetAddNode
    extends JSSetOperation {
        public JSSetAddNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSDynamicObject add(JSSetObject thisObj, Object key) {
            Object normalizedKey = this.normalize(key);
            JSSet.getInternalSet(thisObj).put(normalizedKey, PRESENT);
            return thisObj;
        }

        @Specialization(guards={"!isJSSet(thisObj)"})
        protected static JSDynamicObject notSet(Object thisObj, Object key) {
            throw Errors.createTypeErrorSetExpected();
        }
    }

    public static abstract class JSSetHasNode
    extends JSSetOperation {
        public JSSetHasNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean has(JSSetObject thisObj, Object key) {
            Object normalizedKey = this.normalize(key);
            return JSSet.getInternalSet(thisObj).has(normalizedKey);
        }

        @Specialization(guards={"!isJSSet(thisObj)"})
        protected boolean hasNoObject(Object thisObj, Object key) {
            throw Errors.createTypeErrorSetExpected();
        }
    }

    public static abstract class JSSetForEachNode
    extends JSBuiltinNode {
        public JSSetForEachNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isCallable.executeBoolean(callback)"})
        protected Object forEachFunction(JSSetObject thisObj, JSDynamicObject callback, Object thisArg, @Cached @Cached.Shared IsCallableNode isCallable, @Cached(value="createCall()") JSFunctionCallNode callNode) {
            JSHashMap map = JSSet.getInternalSet(thisObj);
            JSHashMap.Cursor cursor = map.getEntries();
            while (cursor.advance()) {
                Object key = cursor.getKey();
                callNode.executeCall(JSArguments.create(thisArg, (Object)callback, new Object[]{key, key, thisObj}));
            }
            return Undefined.instance;
        }

        @Specialization(guards={"!isCallable.executeBoolean(callback)"})
        protected static Object forEachFunctionNoFunction(JSSetObject thisObj, Object callback, Object thisArg, @Cached @Cached.Shared IsCallableNode isCallable) {
            throw Errors.createTypeErrorCallableExpected();
        }

        @Specialization(guards={"!isJSSet(thisObj)"})
        protected static Object forEachFunctionNoSet(Object thisObj, Object callback, Object thisArg) {
            throw Errors.createTypeErrorSetExpected();
        }
    }

    public static abstract class CreateSetIteratorNode
    extends JSBuiltinNode {
        private final int iterationKind;

        protected CreateSetIteratorNode(JSContext context, JSBuiltin builtin, int iterationKind) {
            super(context, builtin);
            this.iterationKind = iterationKind;
        }

        @Specialization
        protected final JSObject doSet(JSSetObject set) {
            return JSSetIterator.create(this.getContext(), this.getRealm(), (Object)set, JSSet.getInternalSet(set).getEntries(), this.iterationKind);
        }

        @Specialization(guards={"!isJSSet(thisObj)"})
        protected static JSObject doIncompatibleReceiver(Object thisObj) {
            throw Errors.createTypeError("not a Set");
        }
    }

    public static abstract class SetGetSizeNode
    extends JSBuiltinNode {
        public SetGetSizeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected static int doSet(JSSetObject thisObj) {
            return JSSet.getSetSize(thisObj);
        }

        @Specialization(guards={"!isJSSet(thisObj)"})
        protected static int notSet(Object thisObj) {
            throw Errors.createTypeErrorSetExpected();
        }
    }

    public static final class NewSetPrototypeBuiltins
    extends JSBuiltinsContainer.SwitchEnum<NewSetPrototype> {
        protected NewSetPrototypeBuiltins() {
            super(NewSetPrototype.class);
        }

        @Override
        protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, NewSetPrototype builtinEnum) {
            switch (builtinEnum.ordinal()) {
                case 0: {
                    return SetPrototypeBuiltinsFactory.JSSetUnionNodeGen.create(context, builtin, NewSetPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
                }
                case 1: {
                    return SetPrototypeBuiltinsFactory.JSSetIntersectionNodeGen.create(context, builtin, NewSetPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
                }
                case 2: {
                    return SetPrototypeBuiltinsFactory.JSSetDifferenceNodeGen.create(context, builtin, NewSetPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
                }
                case 3: {
                    return SetPrototypeBuiltinsFactory.JSSetSymmetricDifferenceNodeGen.create(context, builtin, NewSetPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
                }
                case 4: {
                    return SetPrototypeBuiltinsFactory.JSSetIsSubsetOfNodeGen.create(context, builtin, NewSetPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
                }
                case 5: {
                    return SetPrototypeBuiltinsFactory.JSSetIsSupersetOfNodeGen.create(context, builtin, NewSetPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
                }
                case 6: {
                    return SetPrototypeBuiltinsFactory.JSSetIsDisjointFromNodeGen.create(context, builtin, NewSetPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
                }
            }
            return null;
        }

        public static enum NewSetPrototype implements BuiltinEnum<NewSetPrototype>
        {
            union(1),
            intersection(1),
            difference(1),
            symmetricDifference(1),
            isSubsetOf(1),
            isSupersetOf(1),
            isDisjointFrom(1);

            private final int length;

            private NewSetPrototype(int length) {
                this.length = length;
            }

            @Override
            public int getLength() {
                return this.length;
            }
        }
    }

    public static abstract class JSSetIsDisjointFromNode
    extends JSSetNewOperation {
        public JSSetIsDisjointFromNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean isDisjointFrom(JSSetObject set, Object other, @Cached(value="create(getContext())") GetSetRecordNode getSetRecordNode, @Cached(inline=true) JSToBooleanNode toBooleanNode, @Cached GetIteratorFromMethodNode getIteratorFromMethodNode, @Cached InlinedBranchProfile thisSetSmallerProfile) {
            SetRecord otherRec = getSetRecordNode.execute(other);
            JSHashMap thisSetData = set.getMap();
            int thisSize = thisSetData.size();
            if ((double)thisSize <= otherRec.size()) {
                thisSetSmallerProfile.enter((Node)this);
                JSHashMap.Cursor cursor = thisSetData.getEntries();
                while (cursor.advance()) {
                    Object e = cursor.getKey();
                    boolean inOther = toBooleanNode.executeBoolean(this, this.call(otherRec.has(), otherRec.set(), e));
                    if (!inOther) continue;
                    return false;
                }
            } else {
                Object next;
                IteratorRecord keysIter = getIteratorFromMethodNode.execute(this, otherRec.set(), otherRec.keys());
                while ((next = this.iteratorStepNode.execute(keysIter)) != Boolean.FALSE) {
                    Object nextValue = this.normalize(this.iteratorValueNode.execute(next));
                    if (!thisSetData.has(nextValue)) continue;
                    this.iteratorCloseNode.executeVoid(keysIter.getIterator());
                    return false;
                }
            }
            return true;
        }

        @Specialization(guards={"!isJSSet(thisObj)"})
        protected boolean notSet(Object thisObj, Object other) {
            throw Errors.createTypeErrorSetExpected();
        }
    }

    public static abstract class JSSetIsSupersetOfNode
    extends JSSetNewOperation {
        public JSSetIsSupersetOfNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean isSupersetOf(JSSetObject set, Object other, @Cached(value="create(getContext())") GetSetRecordNode getSetRecordNode, @Cached GetIteratorFromMethodNode getIteratorFromMethodNode) {
            Object next;
            SetRecord otherRec = getSetRecordNode.execute(other);
            JSHashMap thisSetData = set.getMap();
            int thisSize = thisSetData.size();
            if ((double)thisSize < otherRec.size()) {
                return false;
            }
            IteratorRecord keysIter = getIteratorFromMethodNode.execute(this, otherRec.set(), otherRec.keys());
            while ((next = this.iteratorStepNode.execute(keysIter)) != Boolean.FALSE) {
                Object nextValue = this.normalize(this.iteratorValueNode.execute(next));
                if (thisSetData.has(nextValue)) continue;
                this.iteratorCloseNode.executeVoid(keysIter.getIterator());
                return false;
            }
            return true;
        }

        @Specialization(guards={"!isJSSet(thisObj)"})
        protected boolean notSet(Object thisObj, Object other) {
            throw Errors.createTypeErrorSetExpected();
        }
    }

    public static abstract class JSSetIsSubsetOfNode
    extends JSSetNewOperation {
        public JSSetIsSubsetOfNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean isSubsetOf(JSSetObject set, Object other, @Cached(value="create(getContext())") GetSetRecordNode getSetRecordNode, @Cached(inline=true) JSToBooleanNode toBooleanNode) {
            SetRecord otherRec = getSetRecordNode.execute(other);
            JSHashMap thisSetData = set.getMap();
            int thisSize = thisSetData.size();
            if ((double)thisSize > otherRec.size()) {
                return false;
            }
            JSHashMap.Cursor cursor = thisSetData.getEntries();
            while (cursor.advance()) {
                Object e = cursor.getKey();
                boolean inOther = toBooleanNode.executeBoolean(this, this.call(otherRec.has(), otherRec.set(), e));
                if (inOther) continue;
                return false;
            }
            return true;
        }

        @Specialization(guards={"!isJSSet(thisObj)"})
        protected boolean notSet(Object thisObj, Object other) {
            throw Errors.createTypeErrorSetExpected();
        }
    }

    public static abstract class JSSetSymmetricDifferenceNode
    extends JSSetNewOperation {
        public JSSetSymmetricDifferenceNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSDynamicObject symmetricDifference(JSSetObject set, Object other, @Cached(value="create(getContext())") GetSetRecordNode getSetRecordNode, @Cached GetIteratorFromMethodNode getIteratorFromMethodNode) {
            Object next;
            SetRecord otherRec = getSetRecordNode.execute(other);
            IteratorRecord keysIter = getIteratorFromMethodNode.execute(this, otherRec.set(), otherRec.keys());
            JSHashMap thisSetData = set.getMap();
            JSHashMap resultSetData = thisSetData.copy();
            while ((next = this.iteratorStepNode.execute(keysIter)) != Boolean.FALSE) {
                Object nextValue = this.normalize(this.iteratorValueNode.execute(next));
                boolean inResult = resultSetData.has(nextValue);
                if (thisSetData.has(nextValue)) {
                    if (!inResult) continue;
                    resultSetData.remove(nextValue);
                    continue;
                }
                if (inResult) continue;
                resultSetData.put(nextValue, PRESENT);
            }
            JSSetObject result = JSSet.create(this.getContext(), JSRealm.get(this), resultSetData);
            return result;
        }

        @Specialization(guards={"!isJSSet(thisObj)"})
        protected JSDynamicObject notSet(Object thisObj, Object other) {
            throw Errors.createTypeErrorSetExpected();
        }
    }

    public static abstract class JSSetDifferenceNode
    extends JSSetNewOperation {
        public JSSetDifferenceNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSDynamicObject difference(JSSetObject set, Object other, @Cached(value="create(getContext())") GetSetRecordNode getSetRecordNode, @Cached(inline=true) JSToBooleanNode toBooleanNode, @Cached GetIteratorFromMethodNode getIteratorFromMethodNode, @Cached InlinedBranchProfile thisSetSmallerProfile) {
            SetRecord otherRec = getSetRecordNode.execute(other);
            JSHashMap thisSetData = set.getMap();
            JSHashMap resultSetData = thisSetData.copy();
            int thisSize = thisSetData.size();
            if ((double)thisSize <= otherRec.size()) {
                thisSetSmallerProfile.enter((Node)this);
                JSHashMap.Cursor cursor = thisSetData.getEntries();
                while (cursor.advance()) {
                    Object e = cursor.getKey();
                    Object inOtherObj = this.call(otherRec.has(), otherRec.set(), e);
                    boolean inOther = toBooleanNode.executeBoolean(this, inOtherObj);
                    if (!inOther) continue;
                    resultSetData.remove(e);
                }
            } else {
                Object next;
                IteratorRecord keysIter = getIteratorFromMethodNode.execute(this, otherRec.set(), otherRec.keys());
                while ((next = this.iteratorStepNode.execute(keysIter)) != Boolean.FALSE) {
                    Object nextValue = this.normalize(this.iteratorValueNode.execute(next));
                    resultSetData.remove(nextValue);
                }
            }
            JSSetObject result = JSSet.create(this.getContext(), JSRealm.get(this), resultSetData);
            return result;
        }

        @Specialization(guards={"!isJSSet(thisObj)"})
        protected JSDynamicObject notSet(Object thisObj, Object other) {
            throw Errors.createTypeErrorSetExpected();
        }
    }

    public static abstract class JSSetIntersectionNode
    extends JSSetNewOperation {
        public JSSetIntersectionNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSDynamicObject intersection(JSSetObject set, Object other, @Cached(value="create(getContext())") GetSetRecordNode getSetRecordNode, @Cached(inline=true) JSToBooleanNode toBooleanNode, @Cached GetIteratorFromMethodNode getIteratorFromMethodNode, @Cached InlinedBranchProfile thisSetSmallerProfile) {
            SetRecord otherRec = getSetRecordNode.execute(other);
            JSHashMap resultSetData = new JSHashMap();
            JSHashMap thisSetData = set.getMap();
            int thisSize = thisSetData.size();
            if ((double)thisSize <= otherRec.size()) {
                thisSetSmallerProfile.enter((Node)this);
                JSHashMap.Cursor cursor = thisSetData.getEntries();
                while (cursor.advance()) {
                    Object e = cursor.getKey();
                    Object inOtherObj = this.call(otherRec.has(), otherRec.set(), e);
                    boolean inOther = toBooleanNode.executeBoolean(this, inOtherObj);
                    if (!inOther || resultSetData.has(e)) continue;
                    resultSetData.put(e, PRESENT);
                }
            } else {
                Object next;
                IteratorRecord keysIter = getIteratorFromMethodNode.execute(this, otherRec.set(), otherRec.keys());
                while ((next = this.iteratorStepNode.execute(keysIter)) != Boolean.FALSE) {
                    Object nextValue = this.normalize(this.iteratorValueNode.execute(next));
                    boolean alreadyInResult = resultSetData.has(nextValue);
                    boolean inThis = thisSetData.has(nextValue);
                    if (alreadyInResult || !inThis) continue;
                    resultSetData.put(nextValue, PRESENT);
                }
            }
            JSSetObject result = JSSet.create(this.getContext(), JSRealm.get(this), resultSetData);
            return result;
        }

        @Specialization(guards={"!isJSSet(thisObj)"})
        protected JSDynamicObject notSet(Object thisObj, Object other) {
            throw Errors.createTypeErrorSetExpected();
        }
    }

    public static abstract class JSSetUnionNode
    extends JSSetNewOperation {
        public JSSetUnionNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSDynamicObject union(JSSetObject set, Object other, @Cached(value="create(getContext())") GetSetRecordNode getSetRecordNode, @Cached GetIteratorFromMethodNode getIteratorFromMethodNode) {
            Object next;
            SetRecord otherRec = getSetRecordNode.execute(other);
            IteratorRecord keysIter = getIteratorFromMethodNode.execute(this, otherRec.set(), otherRec.keys());
            JSHashMap resultSetData = set.getMap().copy();
            while ((next = this.iteratorStepNode.execute(keysIter)) != Boolean.FALSE) {
                Object nextValue = this.normalize(this.iteratorValueNode.execute(next));
                if (resultSetData.has(nextValue)) continue;
                resultSetData.put(nextValue, PRESENT);
            }
            JSSetObject result = JSSet.create(this.getContext(), JSRealm.get(this), resultSetData);
            return result;
        }

        @Specialization(guards={"!isJSSet(thisObj)"})
        protected JSDynamicObject notSet(Object thisObj, Object other) {
            throw Errors.createTypeErrorSetExpected();
        }
    }

    protected static abstract class JSSetNewOperation
    extends JSSetOperation {
        @Node.Child
        protected IteratorStepNode iteratorStepNode = IteratorStepNode.create();
        @Node.Child
        protected IteratorValueNode iteratorValueNode = IteratorValueNode.create();
        @Node.Child
        protected IteratorCloseNode iteratorCloseNode;
        @Node.Child
        protected JSFunctionCallNode callFunctionNode;

        protected JSSetNewOperation(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.iteratorCloseNode = IteratorCloseNode.create(context);
        }

        protected Object call(Object function, Object target, Object ... userArguments) {
            if (this.callFunctionNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callFunctionNode = (JSFunctionCallNode)this.insert(JSFunctionCallNode.createCall());
            }
            return this.callFunctionNode.executeCall(JSArguments.create(target, function, userArguments));
        }
    }

    public static abstract class JSSetOperation
    extends JSBuiltinNode {
        protected static final Object PRESENT = new Object();
        @Node.Child
        private JSCollectionsNormalizeNode normalizeNode;

        public JSSetOperation(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected Object normalize(Object value) {
            if (this.normalizeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.normalizeNode = (JSCollectionsNormalizeNode)this.insert(JSCollectionsNormalizeNodeGen.create());
            }
            return this.normalizeNode.execute(value);
        }
    }
}

