/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins.wasm;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.wasm.WebAssemblyInstancePrototypeBuiltins;
import com.oracle.truffle.js.nodes.wasm.ToJSValueNode;
import com.oracle.truffle.js.nodes.wasm.ToJSValueNodeGen;
import com.oracle.truffle.js.nodes.wasm.ToWebAssemblyValueNode;
import com.oracle.truffle.js.nodes.wasm.ToWebAssemblyValueNodeGen;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.GraalJSException;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssembly;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyGlobal;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyGlobalObject;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyInstanceObject;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyMemory;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyMemoryObject;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyTable;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyTableObject;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyValueTypes;
import com.oracle.truffle.js.runtime.builtins.wasm.WebAssemblyHostFunction;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class JSWebAssemblyInstance
extends JSNonProxy
implements JSConstructorFactory.Default,
PrototypeSupplier {
    public static final TruffleString CLASS_NAME = Strings.constant("Instance");
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("Instance.prototype");
    private static final TruffleString MUT = Strings.constant("mut");
    public static final TruffleString WEB_ASSEMBLY_INSTANCE = Strings.constant("WebAssembly.Instance");
    public static final JSWebAssemblyInstance INSTANCE = new JSWebAssemblyInstance();

    @Override
    public TruffleString getClassName() {
        return CLASS_NAME;
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject constructor) {
        JSObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(prototype, constructor);
        JSObjectUtil.putAccessorsFromContainer(realm, prototype, WebAssemblyInstancePrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(prototype, WEB_ASSEMBLY_INSTANCE);
        return prototype;
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getWebAssemblyInstancePrototype();
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, JSDynamicObject prototype) {
        return JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm);
    }

    public static JSWebAssemblyInstanceObject create(JSContext context, JSRealm realm, Object wasmInstance, Object wasmModule) {
        return JSWebAssemblyInstance.create(context, realm, INSTANCE.getIntrinsicDefaultProto(realm), wasmInstance, wasmModule);
    }

    public static JSWebAssemblyInstanceObject create(JSContext context, JSRealm realm, JSDynamicObject proto, Object wasmInstance, Object wasmModule) {
        JSObjectFactory factory = context.getWebAssemblyInstanceFactory();
        JSObject exportsObject = JSWebAssemblyInstance.createExportsObject(context, realm, wasmInstance, wasmModule);
        Shape shape = factory.getShape(realm, proto);
        JSWebAssemblyInstanceObject newObj = factory.initProto(new JSWebAssemblyInstanceObject(shape, proto, wasmInstance, (Object)exportsObject), realm, proto);
        return factory.trackAllocation(newObj);
    }

    private static JSObject createExportsObject(JSContext context, JSRealm realm, Object wasmInstance, Object wasmModule) {
        JSObject exports = JSOrdinary.createWithNullPrototype(context);
        try {
            Object exportsFunction = realm.getWASMModuleExports();
            Object exportsInfo = InteropLibrary.getUncached((Object)exportsFunction).execute(exportsFunction, new Object[]{wasmModule});
            Object instanceExport = realm.getWASMInstanceExport();
            InteropLibrary exportsInterop = InteropLibrary.getUncached((Object)exportsInfo);
            long size = exportsInterop.getArraySize(exportsInfo);
            for (long i = 0L; i < size; ++i) {
                Object value;
                Object exportInfo = exportsInterop.readArrayElement(exportsInfo, i);
                InteropLibrary exportInterop = InteropLibrary.getUncached((Object)exportInfo);
                TruffleString name = JSWebAssemblyInstance.asTString(exportInterop.readMember(exportInfo, "name"));
                TruffleString externtype = JSWebAssemblyInstance.asTString(exportInterop.readMember(exportInfo, "kind"));
                Object externval = InteropLibrary.getUncached().execute(instanceExport, new Object[]{wasmInstance, Strings.toJavaString(name)});
                if (Strings.equals(Strings.FUNCTION, externtype)) {
                    TruffleString typeInfo = JSWebAssemblyInstance.asTString(exportInterop.readMember(exportInfo, "type"));
                    value = JSWebAssemblyInstance.exportFunction(context, realm, externval, typeInfo);
                } else if (Strings.equals(Strings.GLOBAL, externtype)) {
                    type = JSWebAssemblyInstance.asTString(exportInterop.readMember(exportInfo, "type"));
                    int sepIndex = Strings.indexOf(type, ' ');
                    TruffleString valueType = Strings.substring(context, type, 0, sepIndex);
                    boolean mutable = Strings.regionEquals(type, sepIndex + 1, MUT, 0, 3);
                    value = JSWebAssemblyGlobal.create(context, realm, externval, valueType, mutable);
                } else if (Strings.MEMORY.equals((Object)externtype)) {
                    type = JSWebAssemblyInstance.asTString(exportInterop.readMember(exportInfo, "type"));
                    boolean shared = Strings.regionEquals(type, 0, Strings.SHARED, 0, 6);
                    value = JSWebAssemblyMemory.create(context, realm, externval, shared);
                } else {
                    assert (Strings.TABLE.equals((Object)externtype));
                    type = JSWebAssemblyInstance.asTString(exportInterop.readMember(exportInfo, "type"));
                    value = JSWebAssemblyTable.create(context, realm, externval, type);
                }
                JSObject.set((JSDynamicObject)exports, name, value);
            }
        }
        catch (InteropException ex) {
            throw Errors.shouldNotReachHere(ex);
        }
        exports.setIntegrityLevel(true, true);
        return exports;
    }

    @CompilerDirectives.TruffleBoundary
    public static Object exportFunction(final JSContext context, final JSRealm realm, final Object export, TruffleString typeInfo) {
        Object embedderData = JSWebAssembly.getEmbedderData(realm, export);
        if (embedderData instanceof JSFunctionObject) {
            return embedderData;
        }
        int idxOpen = Strings.indexOf(typeInfo, '(');
        int idxClose = Strings.indexOf(typeInfo, ')');
        TruffleString name = Strings.substring(context, typeInfo, 0, idxOpen);
        TruffleString argTypes = Strings.lazySubstring(typeInfo, idxOpen + 1, idxClose - (idxOpen + 1));
        TruffleString returnTypes = Strings.lazySubstring(typeInfo, idxClose + 1);
        final TruffleString[] paramTypes = !Strings.isEmpty(argTypes) ? Strings.split(context, argTypes, Strings.SPACE) : new TruffleString[]{};
        TruffleString[] resultTypes = !Strings.isEmpty(returnTypes) ? Strings.split(context, returnTypes, Strings.SPACE) : new TruffleString[]{};
        final int argCount = paramTypes.length;
        final int returnLength = resultTypes.length;
        final boolean anyReturnTypeIsI64 = Strings.indexOf(typeInfo, JSWebAssemblyValueTypes.I64, idxClose + 1) >= 0;
        final boolean anyArgTypeIsI64 = Strings.indexOf(typeInfo, JSWebAssemblyValueTypes.I64, idxOpen + 1, idxClose) >= 0;
        final boolean anyReturnTypeIsV128 = Strings.indexOf(typeInfo, JSWebAssemblyValueTypes.V128, idxClose + 1) >= 0;
        final boolean anyArgTypeIsV128 = Strings.indexOf(typeInfo, JSWebAssemblyValueTypes.V128, idxOpen + 1, idxClose) >= 0;
        RootCallTarget callTarget = new JavaScriptRootNode(context.getLanguage(), null, null){
            @Node.Child
            ToWebAssemblyValueNode toWebAssemblyValueNode;
            @Node.Child
            ToJSValueNode toJSValueNode;
            private final BranchProfile errorBranch;
            @Node.Child
            InteropLibrary exportFunctionLib;
            @Node.Child
            InteropLibrary readArrayElementLib;
            @CompilerDirectives.CompilationFinal(dimensions=1)
            TruffleString[] argTypesArray;
            {
                super(lang, sourceSection, frameDescriptor);
                this.toWebAssemblyValueNode = ToWebAssemblyValueNodeGen.create();
                this.toJSValueNode = ToJSValueNodeGen.create();
                this.errorBranch = BranchProfile.create();
                this.exportFunctionLib = (InteropLibrary)InteropLibrary.getFactory().createDispatched(5);
                this.readArrayElementLib = (InteropLibrary)InteropLibrary.getFactory().createDispatched(5);
                this.argTypesArray = paramTypes;
            }

            public Object execute(VirtualFrame frame) {
                if (!context.getLanguageOptions().wasmBigInt() && (anyReturnTypeIsI64 || anyArgTypeIsI64) || anyReturnTypeIsV128 || anyArgTypeIsV128) {
                    this.errorBranch.enter();
                    throw Errors.createTypeError("wasm function signature contains illegal type");
                }
                Object[] frameArguments = frame.getArguments();
                int userArgumentCount = JSArguments.getUserArgumentCount(frameArguments);
                Object[] wasmArgs = new Object[argCount];
                for (int i = 0; i < argCount; ++i) {
                    Object wasmArg = i < userArgumentCount ? JSArguments.getUserArgument(frameArguments, i) : Undefined.instance;
                    wasmArgs[i] = this.toWebAssemblyValueNode.execute(wasmArg, this.argTypesArray[i]);
                }
                try {
                    Object wasmResult;
                    try {
                        wasmResult = this.exportFunctionLib.execute(export, wasmArgs);
                    }
                    catch (GraalJSException jsex) {
                        this.errorBranch.enter();
                        throw jsex;
                    }
                    catch (AbstractTruffleException tex) {
                        this.errorBranch.enter();
                        ExceptionType type = InteropLibrary.getUncached((Object)((Object)tex)).getExceptionType((Object)tex);
                        if (type == ExceptionType.INTERRUPT || type == ExceptionType.EXIT) {
                            throw tex;
                        }
                        throw Errors.createRuntimeError(tex, (Node)this);
                    }
                    if (returnLength == 0) {
                        return Undefined.instance;
                    }
                    if (returnLength == 1) {
                        return this.toJSValueNode.execute(wasmResult);
                    }
                    Object[] values = new Object[returnLength];
                    for (int i = 0; i < returnLength; ++i) {
                        values[i] = this.toJSValueNode.execute(this.readArrayElementLib.readArrayElement(wasmResult, (long)i));
                    }
                    return JSArray.createConstantObjectArray(context, realm, values);
                }
                catch (InteropException ex) {
                    throw Errors.shouldNotReachHere(ex);
                }
            }
        }.getCallTarget();
        JSFunctionData functionData = JSFunctionData.createCallOnly(context, (CallTarget)callTarget, argCount, name);
        JSFunctionObject result = JSFunction.create(realm, functionData);
        JSObjectUtil.putHiddenProperty(result, JSWebAssembly.FUNCTION_ADDRESS, export);
        JSWebAssembly.setEmbedderData(realm, export, (Object)result);
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CompilerDirectives.TruffleBoundary
    public static Object transformImportObject(JSContext context, JSRealm realm, Object wasmModule, Object importObject) {
        try {
            JSObject transformedImportObject = JSOrdinary.createWithNullPrototype(context);
            Object importsFn = realm.getWASMModuleImports();
            Object imports = InteropLibrary.getUncached((Object)importsFn).execute(importsFn, new Object[]{wasmModule});
            InteropLibrary importsInterop = InteropLibrary.getUncached((Object)imports);
            long size = importsInterop.getArraySize(imports);
            for (long i = 0L; i < size; ++i) {
                void var21_20;
                Object wasmValue;
                Object descriptor = importsInterop.readArrayElement(imports, i);
                InteropLibrary descriptorInterop = InteropLibrary.getUncached((Object)descriptor);
                TruffleString module = JSWebAssemblyInstance.asTString(descriptorInterop.readMember(descriptor, "module"));
                Object moduleImportObject = JSRuntime.get(importObject, module);
                InteropLibrary moduleImportObjectInterop = InteropLibrary.getUncached((Object)moduleImportObject);
                if (!moduleImportObjectInterop.hasMembers(moduleImportObject)) {
                    throw Errors.createTypeError("Imported module \"" + String.valueOf(module) + "\" is not an object: " + String.valueOf(JSRuntime.safeToString(moduleImportObject)));
                }
                TruffleString name = JSWebAssemblyInstance.asTString(descriptorInterop.readMember(descriptor, "name"));
                Object value = JSRuntime.get(moduleImportObject, name);
                TruffleString externType = JSWebAssemblyInstance.asTString(descriptorInterop.readMember(descriptor, "kind"));
                if (Strings.equals(Strings.FUNCTION, externType)) {
                    if (!JSRuntime.isCallable(value)) {
                        throw JSWebAssemblyInstance.createLinkErrorImport(i, module, name, "Imported value is not callable");
                    }
                    if (JSWebAssembly.isExportedFunction(value)) {
                        wasmValue = JSWebAssembly.getExportedFunction((JSDynamicObject)((Object)value));
                    } else {
                        TruffleString truffleString = JSWebAssemblyInstance.asTString(descriptorInterop.readMember(descriptor, "type"));
                        wasmValue = JSWebAssemblyInstance.createHostFunction(context, value, truffleString);
                    }
                } else if (Strings.equals(Strings.GLOBAL, externType)) {
                    boolean bl = JSRuntime.isNumber(value);
                    boolean isBigInt = JSRuntime.isBigInt(value);
                    if (bl || context.getLanguageOptions().wasmBigInt() && isBigInt) {
                        TruffleString valueType = JSWebAssemblyInstance.asTString(descriptorInterop.readMember(descriptor, "type"));
                        boolean isI64 = JSWebAssemblyValueTypes.isI64(valueType);
                        if (!context.getLanguageOptions().wasmBigInt() && isI64) {
                            throw JSWebAssemblyInstance.createLinkErrorImport(i, module, name, "Can't import the value of i64 WebAssembly.Global");
                        }
                        if (isI64 && bl) {
                            throw JSWebAssemblyInstance.createLinkErrorImport(i, module, name, "Value of valtype i64 must be BigInt");
                        }
                        if (!isI64 && isBigInt) {
                            throw JSWebAssemblyInstance.createLinkErrorImport(i, module, name, "BigInt can only be stored in valtype i64");
                        }
                        if (JSWebAssemblyValueTypes.isV128(valueType)) {
                            throw JSWebAssemblyInstance.createLinkErrorImport(i, module, name, "Values of valtype v128 cannot be imported from JS");
                        }
                        Object webAssemblyValue = ToWebAssemblyValueNodeGen.getUncached().execute(value, valueType);
                        try {
                            Object createGlobal = realm.getWASMGlobalAlloc();
                            wasmValue = InteropLibrary.getUncached((Object)createGlobal).execute(createGlobal, new Object[]{valueType, false, webAssemblyValue});
                        }
                        catch (InteropException ex) {
                            throw Errors.shouldNotReachHere(ex);
                        }
                    } else {
                        if (!JSWebAssemblyGlobal.isJSWebAssemblyGlobal(value)) throw JSWebAssemblyInstance.createLinkErrorImport(i, module, name, "Imported value is not a WebAssembly.Global object");
                        wasmValue = ((JSWebAssemblyGlobalObject)((Object)value)).getWASMGlobal();
                    }
                } else if (Strings.equals(Strings.MEMORY, externType)) {
                    if (!JSWebAssemblyMemory.isJSWebAssemblyMemory(value)) throw JSWebAssemblyInstance.createLinkErrorImport(i, module, name, "Imported value is not a WebAssembly.Memory object");
                    wasmValue = ((JSWebAssemblyMemoryObject)((Object)value)).getWASMMemory();
                } else {
                    assert (Strings.equals(Strings.TABLE, externType)) : externType;
                    if (!JSWebAssemblyTable.isJSWebAssemblyTable(value)) throw JSWebAssemblyInstance.createLinkErrorImport(i, module, name, "Imported value is not a WebAssembly.Table object");
                    wasmValue = ((JSWebAssemblyTableObject)((Object)value)).getWASMTable();
                }
                if (JSObject.hasOwnProperty((JSDynamicObject)transformedImportObject, module)) {
                    JSDynamicObject jSDynamicObject = (JSDynamicObject)((Object)JSObject.get((JSDynamicObject)transformedImportObject, module));
                } else {
                    JSObject jSObject = JSOrdinary.create(context, realm);
                    JSObject.set((JSDynamicObject)transformedImportObject, module, (Object)jSObject);
                }
                JSObject.set((JSDynamicObject)var21_20, name, wasmValue);
            }
            return transformedImportObject;
        }
        catch (InteropException ex) {
            throw Errors.shouldNotReachHere(ex);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static JSException createLinkErrorImport(long index, TruffleString module, TruffleString name, String message) {
        return Errors.createLinkError("Import #" + index + " \"" + String.valueOf(module) + "\" \"" + String.valueOf(name) + "\": " + message);
    }

    @CompilerDirectives.TruffleBoundary
    private static Object createHostFunction(JSContext context, Object fn, TruffleString typeInfo) {
        return new WebAssemblyHostFunction(context, fn, typeInfo);
    }

    private static TruffleString asTString(Object string) {
        if (string instanceof String) {
            return Strings.fromJavaString((String)string);
        }
        return Strings.interopAsTruffleString(string);
    }
}

