/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.macho;

import com.oracle.objectfile.BuildDependency;
import com.oracle.objectfile.LayoutDecisionMap;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.io.AssemblyBuffer;
import com.oracle.objectfile.macho.MachOObjectFile;
import com.oracle.objectfile.macho.MachORelocationInfo;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

class MachORelocationElement
extends MachOObjectFile.LinkEditElement {
    private Map<MachORelocationInfo, MachORelocationInfo> infos;
    private Set<MachOObjectFile.MachOSection> relocatedSections;

    private static int compareSectionThenOffset(MachORelocationInfo p, MachORelocationInfo q) {
        if (!p.getRelocatedSection().equals(q.getRelocatedSection())) {
            return p.getRelocatedSection().hashCode() - q.getRelocatedSection().hashCode();
        }
        if (p.getOffset() != q.getOffset()) {
            return Math.toIntExact(p.getOffset() - q.getOffset());
        }
        assert (!p.isAddendKind() || !q.isAddendKind()) : "two addends for same relocation";
        return Boolean.compare(q.isAddendKind(), p.isAddendKind());
    }

    MachORelocationElement(MachOObjectFile.Segment64Command segment) {
        MachOObjectFile machOObjectFile = segment.getOwner();
        Objects.requireNonNull(machOObjectFile);
        super("MachORelocationElement", segment);
        this.infos = new TreeMap<MachORelocationInfo, MachORelocationInfo>(MachORelocationElement::compareSectionThenOffset);
        this.relocatedSections = new HashSet<MachOObjectFile.MachOSection>();
        assert (segment.getOwner().relocs == null);
        segment.getOwner().relocs = this;
    }

    public void add(MachORelocationInfo rec) {
        if (this.infos.putIfAbsent(rec, rec) == null) {
            this.relocatedSections.add(rec.getRelocatedSection());
        }
    }

    public boolean relocatesSegment(MachOObjectFile.Segment64Command seg) {
        return seg.elementsInSegment.stream().anyMatch(e -> e instanceof MachOObjectFile.MachOSection && this.relocatedSections.contains(e));
    }

    @Override
    public byte[] getOrDecideContent(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, byte[] contentHint) {
        AssemblyBuffer out = AssemblyBuffer.createOutputAssembler(this.getOwner().getByteOrder());
        for (MachORelocationInfo rec : this.infos.keySet()) {
            rec.write(out, alreadyDecided);
        }
        assert (this.getOrDecideSize(alreadyDecided, -1) == out.pos());
        return out.getBlob();
    }

    @Override
    public int getOrDecideSize(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int sizeHint) {
        return this.infos.size() * this.encodedEntrySize();
    }

    @Override
    public Iterable<BuildDependency> getDependencies(Map<ObjectFile.Element, LayoutDecisionMap> decisions) {
        return ObjectFile.minimalDependencies(decisions, this);
    }

    public int startIndexFor(MachOObjectFile.MachOSection s) {
        int i = 0;
        for (MachORelocationInfo info : this.infos.keySet()) {
            if (info.getRelocatedSection() == s) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int encodedEntrySize() {
        return MachORelocationInfo.getEncodedSize();
    }

    public int countFor(MachOObjectFile.MachOSection s) {
        return Math.toIntExact(this.infos.keySet().stream().filter(struct -> s == struct.getRelocatedSection()).count());
    }
}

